/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.enterprise.spanner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.SchemaObject;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerDatabase;
import org.flywaydb.core.internal.database.enterprise.spanner.SpannerTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;

public class SpannerSchema
extends Schema<SpannerDatabase, SpannerTable> {
    private static final Log LOG = LogFactory.getLog(SpannerSchema.class);

    public SpannerSchema(JdbcTemplate jdbcTemplate, SpannerDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.name.equals("");
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        try (Connection c = ((SpannerDatabase)this.database).getNewRawConnection();){
            boolean bl;
            block12: {
                Statement s = c.createStatement();
                s.close();
                ResultSet tables = c.getMetaData().getTables("", "", null, null);
                try {
                    boolean bl2 = bl = !tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    @Override
    protected void doCreate() {
        LOG.info("Spanner does not support creating schemas. Schema not created: " + this.name);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.doClean();
    }

    @Override
    protected void doClean() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String[] foreignKeyAndTable : this.doAllForeignKeys()) {
            String foreignKey = foreignKeyAndTable[0];
            String string = foreignKeyAndTable[1];
            statements.add("ALTER TABLE " + string + " DROP CONSTRAINT " + foreignKey);
        }
        this.jdbcTemplate.executeBatch(statements);
        statements.clear();
        for (SpannerTable spannerTable : this.doAllTables()) {
            for (String index : this.doAllIndexes(spannerTable)) {
                if (index.equalsIgnoreCase("PRIMARY_KEY")) continue;
                this.jdbcTemplate.execute("DROP INDEX " + index, new Object[0]);
            }
            statements.add("DROP TABLE " + ((SchemaObject)spannerTable).toString());
        }
        this.jdbcTemplate.executeBatch(statements);
    }

    protected SpannerTable[] doAllTables() throws SQLException {
        ArrayList<SpannerTable> tablesList = new ArrayList<SpannerTable>();
        Connection c = this.jdbcTemplate.getConnection();
        ResultSet tablesRs = c.getMetaData().getTables("", "", null, null);
        while (tablesRs.next()) {
            tablesList.add(new SpannerTable(this.jdbcTemplate, (SpannerDatabase)this.database, this, tablesRs.getString("TABLE_NAME")));
        }
        tablesRs.close();
        SpannerTable[] tables = new SpannerTable[tablesList.size()];
        return tablesList.toArray(tables);
    }

    private List<String[]> doAllForeignKeys() {
        ArrayList<String[]> foreignKeyAndTableList = new ArrayList<String[]>();
        Results foreignKeyRs = this.jdbcTemplate.executeStatement("SELECT CONSTRAINT_NAME, TABLE_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE='FOREIGN KEY'");
        for (Result result : foreignKeyRs.getResults()) {
            for (List<String> row : result.getData()) {
                String[] foreignKeyAndTable = new String[]{row.get(0), row.get(1)};
                foreignKeyAndTableList.add(foreignKeyAndTable);
            }
        }
        return foreignKeyAndTableList;
    }

    private List<String> doAllIndexes(Table table) throws SQLException {
        ArrayList<String> indexList = new ArrayList<String>();
        Connection c = this.jdbcTemplate.getConnection();
        ResultSet indexRs = c.getMetaData().getIndexInfo("", "", table.getName(), false, false);
        while (indexRs.next()) {
            indexList.add(indexRs.getString("INDEX_NAME"));
        }
        indexRs.close();
        return indexList;
    }

    @Override
    public Table getTable(String tableName) {
        return new SpannerTable(this.jdbcTemplate, (SpannerDatabase)this.database, this, tableName);
    }
}

