/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.pro;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.UndoResult;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.jdbc.ExecutionTemplateFactory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.TimeFormat;

public class DbUndo {
    private static final Log LOG = LogFactory.getLog(DbUndo.class);
    private final Database database;
    private final SchemaHistory schemaHistory;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final Configuration configuration;
    private final CallbackExecutor callbackExecutor;
    private final Connection connectionUserObjects;
    private final MigrationInfoServiceImpl infoService;
    private final UndoResult undoResult;
    private final CommandResultFactory commandResultFactory;

    public DbUndo(Database database, SchemaHistory schemaHistory, Schema schema, MigrationResolver migrationResolver, Configuration configuration, CallbackExecutor callbackExecutor) {
        this.database = database;
        this.connectionUserObjects = database.getMigrationConnection();
        this.schemaHistory = schemaHistory;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.configuration = configuration;
        this.callbackExecutor = callbackExecutor;
        this.infoService = new MigrationInfoServiceImpl(migrationResolver, schemaHistory, database, configuration, configuration.getTarget(), configuration.isOutOfOrder(), configuration.getCherryPick(), true, true, true, true);
        this.commandResultFactory = new CommandResultFactory();
        this.undoResult = this.commandResultFactory.createUndoResult(database.getCatalog(), configuration);
    }

    public UndoResult undo() throws FlywayException {
        this.callbackExecutor.onMigrateOrUndoEvent(Event.BEFORE_UNDO);
        int count = 0;
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (this.schemaHistory.exists()) {
                count = this.configuration.isGroup() ? this.schemaHistory.lock(new Callable<Integer>(){

                    @Override
                    public Integer call() {
                        return DbUndo.this.undoAll();
                    }
                }).intValue() : this.undoAll();
            }
            stopWatch.stop();
            this.logSummary(count, stopWatch.getTotalTimeMillis());
        }
        catch (FlywayException e) {
            this.callbackExecutor.onMigrateOrUndoEvent(Event.AFTER_UNDO_ERROR);
            throw e;
        }
        this.callbackExecutor.onMigrateOrUndoEvent(Event.AFTER_UNDO);
        if (!this.undoResult.undoneMigrations.isEmpty()) {
            this.infoService.refresh();
            MigrationVersion currentSchemaVersion = this.infoService.current() == null ? MigrationVersion.EMPTY : this.infoService.current().getVersion();
            MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
            this.undoResult.targetSchemaVersion = schemaVersionToOutput.getVersion();
        }
        this.undoResult.migrationsUndone = count;
        return this.undoResult;
    }

    private int undoAll() {
        int count;
        int total = 0;
        do {
            final boolean firstRun = total == 0;
            count = this.configuration.isGroup() ? this.undoGroup(firstRun).intValue() : this.schemaHistory.lock(new Callable<Integer>(){

                @Override
                public Integer call() {
                    return DbUndo.this.undoGroup(firstRun);
                }
            }).intValue();
            total += count;
        } while (count != 0);
        return total;
    }

    private Integer undoGroup(boolean firstRun) {
        MigrationInfo[] failed;
        MigrationInfo[] future;
        MigrationVersion currentSchemaVersion;
        if (this.configuration.getTarget() == null && this.configuration.getCherryPick() == null && !firstRun) {
            return 0;
        }
        this.infoService.refresh();
        MigrationVersion migrationVersion = currentSchemaVersion = this.infoService.current() == null ? MigrationVersion.EMPTY : this.infoService.current().getVersion();
        if (firstRun) {
            LOG.info("Current version of schema " + this.schema + ": " + currentSchemaVersion);
            MigrationVersion schemaVersionToOutput = currentSchemaVersion == null ? MigrationVersion.EMPTY : currentSchemaVersion;
            this.undoResult.initialSchemaVersion = schemaVersionToOutput.getVersion();
        }
        if ((future = this.infoService.future()).length > 0) {
            List<MigrationInfo> resolved = Arrays.asList(this.infoService.resolved());
            Collections.reverse(resolved);
            if (resolved.isEmpty()) {
                LOG.error("Schema " + this.schema + " has version " + currentSchemaVersion + ", but no migration could be resolved in the configured locations !");
            } else {
                for (MigrationInfo migrationInfo : resolved) {
                    if (migrationInfo.getVersion() == null) continue;
                    LOG.warn("Schema " + this.schema + " has a version (" + currentSchemaVersion + ") that is newer than the latest available migration (" + migrationInfo.getVersion() + ") !");
                    break;
                }
            }
        }
        if ((failed = this.infoService.failed()).length > 0) {
            if (failed.length == 1 && failed[0].getState() == MigrationState.FUTURE_FAILED && this.configuration.isIgnoreFutureMigrations()) {
                LOG.warn("Schema " + this.schema + " contains a failed future migration to version " + failed[0].getVersion() + " !");
            } else {
                if (failed[0].getVersion() == null) {
                    throw new FlywayException("Schema " + this.schema + " contains a failed repeatable migration (" + failed[0].getDescription() + ") !");
                }
                throw new FlywayException("Schema " + this.schema + " contains a failed migration to version " + failed[0].getVersion() + " !");
            }
        }
        List<MigrationInfoImpl> undoCandidates = this.findUndoCandidates(this.infoService.applied());
        MigrationInfoImpl[] undos = this.infoService.undo();
        LinkedHashMap<ResolvedMigration, MigrationInfo> group = new LinkedHashMap<ResolvedMigration, MigrationInfo>();
        for (MigrationInfoImpl undoCandidate : undoCandidates) {
            ResolvedMigration undo = this.findUndo(undos, undoCandidate.getVersion());
            if (undo == null) {
                throw new FlywayException("Unable to undo migration to version " + undoCandidate.getVersion() + " as no corresponding undo migration has been found.");
            }
            group.put(undo, undoCandidate);
            if (this.configuration.isGroup() && (this.configuration.getTarget() != null || this.configuration.getCherryPick() != null)) continue;
            break;
        }
        if (!group.isEmpty()) {
            boolean skipExecutingMigrations = false;
            skipExecutingMigrations = this.configuration.isSkipExecutingMigrations();
            this.undoMigrations(group, skipExecutingMigrations);
        }
        return group.size();
    }

    private List<MigrationInfoImpl> findUndoCandidates(MigrationInfoImpl[] appliedMigrations) {
        ArrayList<MigrationInfoImpl> applied = new ArrayList<MigrationInfoImpl>(Arrays.asList(appliedMigrations));
        Collections.reverse(applied);
        ArrayList<MigrationInfoImpl> undoCandidates = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : applied) {
            if (migrationInfo.getVersion() == null || migrationInfo.getType().isSynthetic() || migrationInfo.getType().isUndo() || migrationInfo.getState() == MigrationState.UNDONE) continue;
            if (this.configuration.getCherryPick() != null) {
                boolean containedInVersions = false;
                for (MigrationPattern migration : this.configuration.getCherryPick()) {
                    if (!migration.matches(migrationInfo.getVersion(), migrationInfo.getDescription())) continue;
                    containedInVersions = true;
                    break;
                }
                if (!containedInVersions) continue;
            }
            if (this.configuration.getTarget() != null && this.configuration.getTarget().compareTo(migrationInfo.getVersion()) > 0) break;
            undoCandidates.add(migrationInfo);
        }
        return undoCandidates;
    }

    private ResolvedMigration findUndo(MigrationInfoImpl[] undos, MigrationVersion version) {
        for (MigrationInfoImpl undo : undos) {
            if (!undo.getVersion().equals(version)) continue;
            return undo.getResolvedMigration();
        }
        return null;
    }

    private void logSummary(int migrationSuccessCount, long executionTime) {
        if (migrationSuccessCount == 0) {
            LOG.info("Schema " + this.schema + " has no migrations to undo.");
            return;
        }
        if (migrationSuccessCount == 1) {
            LOG.info("Successfully undid 1 migration to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ")");
        } else {
            LOG.info("Successfully undid " + migrationSuccessCount + " migrations to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ")");
        }
    }

    private void undoMigrations(final Map<ResolvedMigration, MigrationInfo> group, final boolean skipExecutingMigrations) {
        boolean executeGroupInTransaction = this.isExecuteGroupInTransaction(group);
        final StopWatch stopWatch = new StopWatch();
        try {
            if (executeGroupInTransaction) {
                ExecutionTemplateFactory.createExecutionTemplate(this.connectionUserObjects.getJdbcConnection(), this.database).execute(new Callable<Object>(){

                    @Override
                    public Object call() {
                        DbUndo.this.doUndoGroup(group, stopWatch, skipExecutingMigrations);
                        return null;
                    }
                });
            } else {
                this.doUndoGroup(group, stopWatch, skipExecutingMigrations);
            }
        }
        catch (FlywayUndoSqlException e) {
            ResolvedMigration migration = e.getMigration();
            String failedMsg = "Undo of migration of " + this.toMigrationText(migration) + " failed!";
            if (this.database.supportsDdlTransactions() && executeGroupInTransaction) {
                LOG.error(failedMsg + " Changes successfully rolled back.");
            } else {
                LOG.error(failedMsg + " Please restore backups and roll back database and code!");
                stopWatch.stop();
                int executionTime = (int)stopWatch.getTotalTimeMillis();
                this.schemaHistory.addAppliedMigration(migration.getVersion(), migration.getDescription(), migration.getType(), migration.getScript(), migration.getChecksum(), executionTime, false);
            }
            throw e;
        }
    }

    private boolean isExecuteGroupInTransaction(Map<ResolvedMigration, MigrationInfo> group) {
        boolean executeGroupInTransaction = true;
        boolean first = true;
        for (ResolvedMigration undoMigration : group.keySet()) {
            boolean inTransaction = undoMigration.getExecutor().canExecuteInTransaction();
            if (first) {
                executeGroupInTransaction = inTransaction;
                first = false;
                continue;
            }
            if (!this.configuration.isMixed() && executeGroupInTransaction != inTransaction) {
                throw new FlywayException("Detected both transactional and non-transactional undo migrations within the same undo migration group (even though mixed is false). First offending migration:" + undoMigration.getVersion() + (StringUtils.hasLength(undoMigration.getDescription()) ? " " + undoMigration.getDescription() : "") + (inTransaction ? "" : " [non-transactional]"));
            }
            executeGroupInTransaction = executeGroupInTransaction && inTransaction;
        }
        return executeGroupInTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUndoGroup(Map<ResolvedMigration, MigrationInfo> group, StopWatch stopWatch, boolean skipExecutingMigrations) {
        Context context = new Context(){

            @Override
            public Configuration getConfiguration() {
                return DbUndo.this.configuration;
            }

            @Override
            public java.sql.Connection getConnection() {
                return DbUndo.this.connectionUserObjects.getJdbcConnection();
            }
        };
        for (Map.Entry<ResolvedMigration, MigrationInfo> migrationEntry : group.entrySet()) {
            ResolvedMigration migration = migrationEntry.getKey();
            MigrationInfo migrationInfo = migrationEntry.getValue();
            String migrationText = this.toMigrationText(migration);
            stopWatch.start();
            if (skipExecutingMigrations) {
                LOG.debug("Skipping execution of undo migration of " + migrationText);
            } else {
                LOG.info("Undoing migration of " + migrationText);
                this.connectionUserObjects.restoreOriginalState();
                this.connectionUserObjects.changeCurrentSchemaTo(this.schema);
                try {
                    this.callbackExecutor.setMigrationInfo(migrationInfo);
                    this.callbackExecutor.onEachMigrateOrUndoEvent(Event.BEFORE_EACH_UNDO);
                    try {
                        migration.getExecutor().execute(context);
                        this.undoResult.undoneMigrations.add(this.commandResultFactory.createUndoOutput(migration));
                    }
                    catch (FlywayException e) {
                        this.callbackExecutor.onEachMigrateOrUndoEvent(Event.AFTER_EACH_UNDO_ERROR);
                        throw new FlywayUndoSqlException(migration, e);
                    }
                    catch (SQLException e) {
                        this.callbackExecutor.onEachMigrateOrUndoEvent(Event.AFTER_EACH_UNDO_ERROR);
                        throw new FlywayUndoSqlException(migration, e);
                    }
                    LOG.debug("Successfully undid migration of " + migrationText);
                    this.callbackExecutor.onEachMigrateOrUndoEvent(Event.AFTER_EACH_UNDO);
                }
                finally {
                    this.callbackExecutor.setMigrationInfo(null);
                }
            }
            stopWatch.stop();
            int executionTime = (int)stopWatch.getTotalTimeMillis();
            this.schemaHistory.addAppliedMigration(migration.getVersion(), migration.getDescription(), migration.getType(), migration.getScript(), migration.getChecksum(), executionTime, true);
        }
    }

    private String toMigrationText(ResolvedMigration migration) {
        return "schema " + this.schema + " to version " + migration.getVersion() + (StringUtils.hasLength(migration.getDescription()) ? " - " + migration.getDescription() : "") + (migration.getExecutor().canExecuteInTransaction() ? "" : " [non-transactional]");
    }

    public static class FlywayUndoSqlException
    extends FlywayException {
        private final ResolvedMigration migration;

        FlywayUndoSqlException(ResolvedMigration migration, SQLException e) {
            super(ExceptionUtils.toMessage(e), e);
            this.migration = migration;
        }

        FlywayUndoSqlException(ResolvedMigration migration, FlywayException e) {
            super(e.getMessage(), e);
            this.migration = migration;
        }

        public ResolvedMigration getMigration() {
            return this.migration;
        }
    }
}

