/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.math.BigInteger;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;

public class InsertRowLock {
    private static final Log LOG = LogFactory.getLog(InsertRowLock.class);
    private static final Random random = new Random();
    private final String tableLockString = this.getNextRandomString();
    private final JdbcTemplate jdbcTemplate;
    public final int lockTimeoutMins;
    private Timer timer;

    public InsertRowLock(JdbcTemplate jdbcTemplate, int lockTimeoutMins) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockTimeoutMins = lockTimeoutMins;
    }

    public void doLock(String insertStatementTemplate, String updateLockStatement, String deleteExpiredLockStatement, String booleanTrue) throws SQLException {
        int retryCount = 0;
        while (true) {
            try {
                while (true) {
                    this.jdbcTemplate.execute(deleteExpiredLockStatement, new Object[0]);
                    if (this.insertLockingRow(insertStatementTemplate, booleanTrue)) {
                        this.startLockWatchingThread(String.format(updateLockStatement.replace("?", "%s"), this.tableLockString));
                        return;
                    }
                    if (retryCount < 50) {
                        ++retryCount;
                        LOG.debug("Waiting for lock on Flyway schema history table");
                    } else {
                        LOG.error("Waiting for lock on Flyway schema history table. Application may be deadlocked. Lock row may require manual removal from the schema history table.");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean insertLockingRow(String insertStatementTemplate, String booleanTrue) {
        String insertStatement = String.format(insertStatementTemplate.replace("?", "%s"), -100, "'" + this.tableLockString + "'", "'flyway-lock'", "''", "''", 0, "''", 0, booleanTrue);
        Results results = this.jdbcTemplate.executeStatement(insertStatement);
        return results.getException() == null;
    }

    public void doUnlock(String deleteLockTemplate) throws SQLException {
        this.stopLockWatchingThread();
        String deleteLock = String.format(deleteLockTemplate.replace("?", "%s"), this.tableLockString);
        this.jdbcTemplate.execute(deleteLock, new Object[0]);
    }

    private String getNextRandomString() {
        BigInteger bInt = new BigInteger(128, random);
        return bInt.toString(16);
    }

    private void startLockWatchingThread(final String updateLockStatement) {
        TimerTask lockWatcherTask = new TimerTask(){

            @Override
            public void run() {
                LOG.debug("Updating lock in Flyway schema history table");
                InsertRowLock.this.jdbcTemplate.executeStatement(updateLockStatement);
            }
        };
        this.timer = new Timer();
        this.timer.schedule(lockWatcherTask, 0L, Duration.ofMinutes(this.lockTimeoutMins / 2).toMillis());
    }

    private void stopLockWatchingThread() {
        this.timer.cancel();
    }
}

