/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.NBackupManager;

public class FBNBackupManager
extends FBServiceManager
implements NBackupManager {
    private final List<String> backupFiles = new ArrayList<String>();
    private int backupLevel;
    private boolean noDBTriggers;

    public FBNBackupManager() {
    }

    public FBNBackupManager(String gdsType) {
        super(gdsType);
    }

    public FBNBackupManager(GDSType gdsType) {
        super(gdsType);
    }

    @Override
    public void setBackupFile(String backupFile) {
        this.addBackupFile(backupFile);
    }

    @Override
    public void addBackupFile(String backupFile) {
        this.backupFiles.add(backupFile);
    }

    @Override
    public void clearBackupFiles() {
        this.backupFiles.clear();
    }

    @Override
    public void setDatabase(String database) {
        super.setDatabase(database);
    }

    @Override
    public void backupDatabase() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getBackupSRB(service));
        }
    }

    private ServiceRequestBuffer getBackupSRB(FbService service) throws SQLException {
        ServiceRequestBuffer backupSPB = service.createServiceRequestBuffer();
        backupSPB.addArgument(20);
        backupSPB.addArgument(106, this.getDatabase());
        if (this.backupFiles.size() == 0) {
            throw new SQLException("No backup file specified");
        }
        String backupFile = this.backupFiles.get(0);
        backupSPB.addArgument(6, backupFile);
        backupSPB.addArgument(5, this.backupLevel);
        if (this.noDBTriggers) {
            backupSPB.addArgument(108, 1);
        }
        return backupSPB;
    }

    @Override
    public void restoreDatabase() throws SQLException {
        try (FbService service = this.attachServiceManager();){
            this.executeServicesOperation(service, this.getRestoreSRB(service));
        }
    }

    private ServiceRequestBuffer getRestoreSRB(FbService service) throws SQLException {
        ServiceRequestBuffer restoreSPB = service.createServiceRequestBuffer();
        restoreSPB.addArgument(21);
        restoreSPB.addArgument(106, this.getDatabase());
        if (this.backupFiles.size() == 0) {
            throw new SQLException("No backup file specified");
        }
        for (String backupFile : this.backupFiles) {
            restoreSPB.addArgument(6, backupFile);
        }
        return restoreSPB;
    }

    @Override
    public void setBackupLevel(int backupLevel) {
        this.backupLevel = backupLevel;
    }

    @Override
    public void setNoDBTriggers(boolean noDBTriggers) {
        this.noDBTriggers = noDBTriggers;
    }
}

