/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class DryRunJdbcProxies {
    private static final Pattern QUERY_REGEX = Pattern.compile("^(SELECT|CALL|DECLARE|SHOW)[\\s\\S]*", 2);
    private static final List<String> JDBC_VALUE_SETTERS = Arrays.asList("setBoolean", "setDouble", "setFloat", "setInt", "setLong", "setNString", "setShort", "setString", "setURL", "setAsciiStream", "setBinaryStream", "setCharacterStream", "setNCharacterStream", "setUnicodeStream", "setBlob", "setClob", "setNClob", "setDate", "setTime", "setTimestamp", "setArray", "setBigDecimal", "setByte", "setBytes", "setObject", "setRef", "setRowId", "setSQLXML");

    public static Connection createConnectionProxy(final Connection connection, final DryRunStatementInterceptor dryRunStatementInterceptor) {
        final ClassLoader classLoader = Connection.class.getClassLoader();
        return (Connection)Proxy.newProxyInstance(classLoader, new Class[]{Connection.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Object result = method.invoke((Object)connection, args);
                    if ("createStatement".equals(method.getName())) {
                        return DryRunJdbcProxies.createStatementProxy(classLoader, (Statement)result, dryRunStatementInterceptor);
                    }
                    if ("prepareStatement".equals(method.getName())) {
                        return DryRunJdbcProxies.createPreparedStatementProxy(classLoader, (PreparedStatement)result, (String)args[0], dryRunStatementInterceptor);
                    }
                    if ("prepareCall".equals(method.getName())) {
                        return DryRunJdbcProxies.createCallableStatementProxy(classLoader, (CallableStatement)result, (String)args[0], dryRunStatementInterceptor);
                    }
                    return result;
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    private static Statement createStatementProxy(final ClassLoader classLoader, final Statement statement, final DryRunStatementInterceptor dryRunStatementInterceptor) {
        return (Statement)Proxy.newProxyInstance(classLoader, new Class[]{Statement.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    String methodName = method.getName();
                    if ("execute".equals(methodName) || "executeQuery".equals(methodName) && !QUERY_REGEX.matcher((String)args[0]).matches() || "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName)) {
                        dryRunStatementInterceptor.interceptStatement((String)args[0]);
                        if ("execute".equals(methodName)) {
                            return false;
                        }
                        if ("executeQuery".equals(methodName)) {
                            return DryRunJdbcProxies.createDummyResultSet(classLoader);
                        }
                        return 0;
                    }
                    return method.invoke((Object)statement, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    private static boolean isReadOnlyQuery(String sql) {
        String sanitizedSql = sql;
        if (sanitizedSql.startsWith("/*NO LOAD BALANCE*/")) {
            sanitizedSql = sanitizedSql.replaceFirst("/\\*NO LOAD BALANCE\\*/", "");
            sanitizedSql = sanitizedSql.trim();
        }
        return QUERY_REGEX.matcher(sanitizedSql).matches();
    }

    private static PreparedStatement createPreparedStatementProxy(final ClassLoader classLoader, final PreparedStatement statement, final String sql, final DryRunStatementInterceptor dryRunStatementInterceptor) {
        return (PreparedStatement)Proxy.newProxyInstance(classLoader, new Class[]{PreparedStatement.class}, new InvocationHandler(){
            private final Map<Integer, Object> params = new Hashtable<Integer, Object>();

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    String methodName = method.getName();
                    if ("execute".equals(methodName) || "executeQuery".equals(methodName) && !DryRunJdbcProxies.isReadOnlyQuery(sql) || "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName)) {
                        if (args == null) {
                            dryRunStatementInterceptor.interceptPreparedStatement(sql, this.params);
                        } else {
                            dryRunStatementInterceptor.interceptStatement((String)args[0]);
                        }
                        if ("execute".equals(methodName)) {
                            return false;
                        }
                        if ("executeQuery".equals(methodName)) {
                            return DryRunJdbcProxies.createDummyResultSet(classLoader);
                        }
                        return 0;
                    }
                    if ("setNull".equals(methodName)) {
                        this.params.put((Integer)args[0], null);
                    } else if (JDBC_VALUE_SETTERS.contains(methodName)) {
                        this.params.put((Integer)args[0], args[1]);
                    }
                    return method.invoke((Object)statement, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    private static CallableStatement createCallableStatementProxy(final ClassLoader classLoader, final CallableStatement statement, final String sql, final DryRunStatementInterceptor dryRunStatementInterceptor) {
        return (CallableStatement)Proxy.newProxyInstance(classLoader, new Class[]{CallableStatement.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    String methodName = method.getName();
                    if ("execute".equals(methodName) || "executeQuery".equals(methodName) && !QUERY_REGEX.matcher(sql).matches() || "executeUpdate".equals(methodName) || "executeLargeUpdate".equals(methodName)) {
                        if (args == null) {
                            dryRunStatementInterceptor.interceptCallableStatement(sql);
                        } else {
                            dryRunStatementInterceptor.interceptStatement((String)args[0]);
                        }
                        if ("execute".equals(methodName)) {
                            return false;
                        }
                        if ("executeQuery".equals(methodName)) {
                            return DryRunJdbcProxies.createDummyResultSet(classLoader);
                        }
                        return 0;
                    }
                    return method.invoke((Object)statement, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        });
    }

    private static ResultSet createDummyResultSet(ClassLoader classLoader) {
        return (ResultSet)Proxy.newProxyInstance(classLoader, new Class[]{ResultSet.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) {
                Class<?> returnType = method.getReturnType();
                if (Boolean.TYPE.equals(returnType)) {
                    return false;
                }
                if (Number.class.isAssignableFrom(returnType)) {
                    return 0;
                }
                return null;
            }
        });
    }
}

