/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusShowParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusShowParsedSqlStatement.class);
    public static final String SUPPORTED_SHOW_OPTIONS = "CON_ID|EDITION|ERR(ORS)?|LIN(ESIZE)?|REL(EASE)?|SERVEROUT(PUT)?|SUF(FIX)?|USER";
    private final String suffix;
    private final int lineSize;
    private final boolean defineOn;
    private final char defineChar;
    private final boolean verifyOn;
    private final boolean escapeOn;
    private final char escapeChar;

    public SQLPlusShowParsedSqlStatement(int pos, int line, int col, String sql, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider) {
        super(pos, line, col, sql);
        this.suffix = sqlPlusPlaceholderProvider.getSuffix();
        this.lineSize = sqlPlusPlaceholderProvider.getLineSize();
        this.defineOn = sqlPlusPlaceholderProvider.isDefineOn();
        this.defineChar = sqlPlusPlaceholderProvider.getDefineChar();
        this.verifyOn = sqlPlusPlaceholderProvider.isVerifyOn();
        this.escapeOn = sqlPlusPlaceholderProvider.isEscapeOn();
        this.escapeChar = sqlPlusPlaceholderProvider.getEscapeChar();
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        Results results = new Results();
        String sql = this.getSql();
        String allOptions = sql.substring(sql.indexOf(" ") + 1).toUpperCase(Locale.ENGLISH);
        try {
            for (String option : StringUtils.tokenizeToStringCollection(allOptions, " ")) {
                if ("CON_ID".equals(option)) {
                    this.conId(jdbcTemplate);
                    continue;
                }
                if (option.matches("DEF(INE)?")) {
                    this.define();
                    continue;
                }
                if ("SCAN".equals(option)) {
                    this.scan();
                    continue;
                }
                if ("ECHO".equals(option)) {
                    this.echo(sqlScriptExecutor);
                    continue;
                }
                if ("EDITION".equals(option)) {
                    this.edition(jdbcTemplate);
                    continue;
                }
                if (option.startsWith("ERR")) {
                    this.err(jdbcTemplate, option);
                    continue;
                }
                if (option.matches("ESC(APE)?")) {
                    this.escape();
                    continue;
                }
                if (option.matches("HEA(DING)?")) {
                    this.heading(sqlScriptExecutor);
                    continue;
                }
                if (option.matches("LIN(ESIZE)?")) {
                    LOG.info("linesize " + this.lineSize);
                    continue;
                }
                if (option.matches("FEED(BACK)?")) {
                    this.feedback(sqlScriptExecutor);
                    continue;
                }
                if (option.matches("TERM(OUT)?")) {
                    this.termOut(sqlScriptExecutor);
                    continue;
                }
                if (option.matches("TI(ME)?")) {
                    this.time(sqlScriptExecutor);
                    continue;
                }
                if (option.matches("TIMI(NG)?")) {
                    this.timing(sqlScriptExecutor);
                    continue;
                }
                if ("NULL".equals(option)) {
                    this.nullText(sqlScriptExecutor);
                    continue;
                }
                if (option.startsWith("REL")) {
                    this.rel(jdbcTemplate);
                    continue;
                }
                if (option.matches("SERVEROUT(PUT)?")) {
                    this.serverOutput(sqlScriptExecutor);
                    continue;
                }
                if (option.matches("SUF(FIX)?")) {
                    LOG.info("suffix \"" + this.suffix + "\"");
                    continue;
                }
                if (option.startsWith("USER")) {
                    this.user(jdbcTemplate);
                    continue;
                }
                if (option.matches("VER(IFY)?")) {
                    LOG.info("verify " + (this.verifyOn ? "ON" : "OFF"));
                    continue;
                }
                LOG.warn("SP2-0158: unknown SHOW option \"" + option + "\"");
            }
        }
        catch (SQLException e) {
            jdbcTemplate.extractErrors(results, e);
        }
        return results;
    }

    private void define() {
        LOG.info("define " + (this.defineOn ? "\"" + this.defineChar + "\" (hex " + Integer.toHexString(this.defineChar) + ")" : "OFF"));
    }

    private void scan() {
        LOG.info("scan " + (this.defineOn ? "ON" : "OFF"));
    }

    private void escape() {
        LOG.info("escape " + (this.escapeOn ? "\"" + this.escapeChar + "\" (hex " + Integer.toHexString(this.escapeChar) + ")" : "OFF"));
    }

    private void feedback(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("FEEDBACK " + (oracleSqlScriptExecutor.getFeedback() == 0 ? "OFF" : "ON for " + oracleSqlScriptExecutor.getFeedback() + " or more rows"));
        }
    }

    private void echo(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("echo " + (oracleSqlScriptExecutor.isEcho() ? "OFF" : "ON"));
        }
    }

    private void heading(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("heading " + (oracleSqlScriptExecutor.isHeading() ? "OFF" : "ON"));
        }
    }

    private void termOut(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("termout " + (oracleSqlScriptExecutor.isTermOut() ? "OFF" : "ON"));
        }
    }

    private void time(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("time " + (oracleSqlScriptExecutor.isTime() ? "OFF" : "ON"));
        }
    }

    private void timing(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("timing " + (oracleSqlScriptExecutor.isTiming() ? "OFF" : "ON"));
        }
    }

    private void serverOutput(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("serveroutput " + (oracleSqlScriptExecutor.isServerOutput() ? "ON SIZE " + oracleSqlScriptExecutor.getServerOutputSize() + " FORMAT " + (Object)((Object)oracleSqlScriptExecutor.getServerOutputFormat()) : "OFF"));
        }
    }

    private void nullText(SqlScriptExecutor sqlScriptExecutor) {
        if (sqlScriptExecutor instanceof OracleSqlScriptExecutor) {
            OracleSqlScriptExecutor oracleSqlScriptExecutor = (OracleSqlScriptExecutor)sqlScriptExecutor;
            LOG.info("null \"" + oracleSqlScriptExecutor.getNullText() + "\"");
        }
    }

    private void conId(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("CON_ID\n------------------------------\n" + jdbcTemplate.queryForString("SELECT CON_ID FROM V$VERSION WHERE BANNER LIKE 'Oracle Database%'", new String[0]));
    }

    private void edition(JdbcTemplate jdbcTemplate) throws SQLException {
        if (jdbcTemplate.getConnection().getMetaData().getDatabaseMajorVersion() < 11) {
            LOG.warn("SP2-0614: Server version too low for this feature\nSP2-1539: Edition requires Oracle Database 11g or later.");
        } else {
            LOG.info("EDITION\n------------------------------\n" + jdbcTemplate.queryForString("SELECT property_value FROM database_properties\nWHERE  property_name = 'DEFAULT_EDITION'", new String[0]));
        }
    }

    private void err(JdbcTemplate jdbcTemplate, String option) throws SQLException {
        List<Map<String, String>> result;
        String query = "SELECT TYPE,NAME,LINE,POSITION,TEXT FROM USER_ERRORS";
        String orderBy = " ORDER BY SEQUENCE";
        if (option.matches("(ERR|ERRORS)")) {
            result = jdbcTemplate.queryForList(query + orderBy, new Object[0]);
        } else {
            String[] typeName = StringUtils.tokenizeToStringArray(option.substring(option.indexOf(" ") + 1), " ");
            result = jdbcTemplate.queryForList(query + " WHERE TYPE=? AND NAME=?" + orderBy, typeName);
        }
        if (result.isEmpty()) {
            LOG.info("No errors.");
        } else {
            StringBuilder output = new StringBuilder("Errors for " + result.get(0).get("TYPE") + " " + result.get(0).get("NAME") + ":\n\nLINE/COL ERROR\n-------- -----------------------------------------------------------------\n");
            for (Map<String, String> row : result) {
                output.append(StringUtils.trimOrPad(row.get("LINE") + "/" + row.get("POSITION"), 8)).append(" ").append(row.get("TEXT").replace("\n", "\n         ")).append("\n");
            }
            LOG.info(output.toString().substring(0, output.length() - 1));
        }
    }

    private void rel(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("release " + jdbcTemplate.queryForString("SELECT VERSION FROM PRODUCT_COMPONENT_VERSION WHERE PRODUCT LIKE 'Oracle Database%'", new String[0]).replace(".", "0"));
    }

    private void user(JdbcTemplate jdbcTemplate) throws SQLException {
        LOG.info("USER is \"" + jdbcTemplate.getConnection().getMetaData().getUserName() + "\"");
    }
}

