/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ParameterBuffer;
import org.firebirdsql.gds.ParameterTagMapping;
import org.firebirdsql.gds.ServiceParameterBuffer;
import org.firebirdsql.gds.impl.ParameterBufferBase;
import org.firebirdsql.gds.impl.ParameterBufferMetaData;
import org.firebirdsql.gds.impl.argument.ArgumentType;

public class ServiceParameterBufferImp
extends ParameterBufferBase
implements ServiceParameterBuffer {
    public ServiceParameterBufferImp(SpbMetaData spbMetaData, Encoding defaultEncoding) {
        super(spbMetaData, defaultEncoding);
    }

    @Override
    public ParameterTagMapping getTagMapping() {
        return ParameterTagMapping.SPB;
    }

    public static enum SpbMetaData implements ParameterBufferMetaData
    {
        SPB_VERSION_2_ATTACH(2){

            @Override
            public void addPreamble(ParameterBuffer parameterBuffer) {
                parameterBuffer.addArgument(2);
            }

            @Override
            public ArgumentType getStringArgumentType(int tag) {
                return ArgumentType.TraditionalDpb;
            }

            @Override
            public ArgumentType getByteArrayArgumentType(int tag) {
                return ArgumentType.TraditionalDpb;
            }

            @Override
            public ArgumentType getIntegerArgumentType(int tag) {
                return ArgumentType.TraditionalDpb;
            }
        }
        ,
        SPB_VERSION_2(2){

            @Override
            public ArgumentType getStringArgumentType(int tag) {
                return ArgumentType.StringSpb;
            }

            @Override
            public ArgumentType getByteArrayArgumentType(int tag) {
                return ArgumentType.StringSpb;
            }

            @Override
            public ArgumentType getIntegerArgumentType(int tag) {
                switch (tag) {
                    case 49: 
                    case 50: 
                    case 51: {
                        return ArgumentType.BigIntSpb;
                    }
                }
                return ArgumentType.IntSpb;
            }
        }
        ,
        SPB_VERSION_3_ATTACH(3){

            @Override
            public ArgumentType getStringArgumentType(int tag) {
                return ArgumentType.Wide;
            }

            @Override
            public ArgumentType getByteArrayArgumentType(int tag) {
                return ArgumentType.Wide;
            }

            @Override
            public ArgumentType getIntegerArgumentType(int tag) {
                return ArgumentType.Wide;
            }
        };

        private final int spbVersion;

        private SpbMetaData(int spbVersion) {
            this.spbVersion = spbVersion;
        }

        @Override
        public final int getType() {
            return this.spbVersion;
        }

        @Override
        public void addPreamble(ParameterBuffer parameterBuffer) {
        }
    }
}

