/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;

public class FileSystemScanner {
    private static final Log LOG = LogFactory.getLog(FileSystemScanner.class);
    private final Charset encoding;

    public FileSystemScanner(Charset encoding) {
        this.encoding = encoding;
    }

    public Collection<LoadableResource> scanForResources(Location location) {
        String path = location.getPath();
        LOG.debug("Scanning for filesystem resources at '" + path + "'");
        File dir = new File(path);
        if (!dir.exists()) {
            LOG.warn("Skipping filesystem location:" + path + " (not found). Note this warning will become an error in Flyway 7.");
            return Collections.emptyList();
        }
        if (!dir.canRead()) {
            LOG.warn("Skipping filesystem location:" + path + " (not readable). Note this warning will become an error in Flyway 7.");
            return Collections.emptyList();
        }
        if (!dir.isDirectory()) {
            LOG.warn("Skipping filesystem location:" + path + " (not a directory). Note this warning will become an error in Flyway 7.");
            return Collections.emptyList();
        }
        TreeSet<LoadableResource> resources = new TreeSet<LoadableResource>();
        for (String resourceName : this.findResourceNamesFromFileSystem(path, new File(path))) {
            resources.add(new FileSystemResource(location, resourceName, this.encoding));
            LOG.debug("Found filesystem resource: " + resourceName);
        }
        return resources;
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        File[] files;
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                if (file.isHidden()) {
                    LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
                    continue;
                }
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                continue;
            }
            resourceNames.add(file.getPath());
        }
        return resourceNames;
    }
}

