/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.firebird;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.firebird.FirebirdConnection;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;

public class FirebirdDatabase
extends Database<FirebirdConnection> {
    public FirebirdDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, jdbcConnectionFactory, dryRunStatementInterceptor);
    }

    @Override
    protected FirebirdConnection doGetConnection(Connection connection) {
        return new FirebirdConnection(this, connection);
    }

    @Override
    public void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("3.0");
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return false;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return '\"' + identifier.replace("\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        String createScript = "CREATE TABLE " + table + " (\n    \"installed_rank\" INTEGER CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" SMALLINT NOT NULL\n);\nCREATE INDEX \"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");\n";
        if (baseline) {
            createScript = createScript + "COMMIT RETAIN;\n" + this.getBaselineStatement(table) + ";\n";
        }
        return createScript;
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((FirebirdConnection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT_USER from RDB$DATABASE", new String[0]);
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

