/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.TransactionTemplate;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class DbSchemas {
    private static final Log LOG = LogFactory.getLog(DbSchemas.class);
    private final Connection connection;
    private final Schema[] schemas;
    private final SchemaHistory schemaHistory;

    public DbSchemas(Database database, Schema[] schemas, SchemaHistory schemaHistory) {
        this.connection = database.getMainConnection();
        this.schemas = schemas;
        this.schemaHistory = schemaHistory;
    }

    public void create(final boolean baseline) {
        int retries = 0;
        while (true) {
            try {
                TransactionTemplate.createTransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                    @Override
                    public Void call() {
                        ArrayList<Schema> createdSchemas = new ArrayList<Schema>();
                        for (Schema schema : DbSchemas.this.schemas) {
                            if (!schema.exists()) {
                                LOG.debug("Creating schema: " + schema);
                                schema.create();
                                createdSchemas.add(schema);
                                continue;
                            }
                            LOG.debug("Skipping creation of existing schema: " + schema);
                        }
                        if (!createdSchemas.isEmpty()) {
                            DbSchemas.this.schemaHistory.create(baseline);
                            DbSchemas.this.schemaHistory.addSchemasMarker(createdSchemas.toArray(new Schema[0]));
                        }
                        return null;
                    }
                });
                return;
            }
            catch (RuntimeException e) {
                if (++retries >= 10) {
                    throw e;
                }
                try {
                    LOG.debug("Schema creation failed. Retrying in 1 sec ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }
}

