/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.ABSTRACT_DATUM})
public abstract class DatumWithConnection
extends Datum
implements OracleDatumWithConnection {
    private oracle.jdbc.internal.OracleConnection physicalConnection = null;
    protected DatumWithConnection targetDatumWithConnection = null;

    public oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getPhysicalConnection();
        }
        if (this.physicalConnection == null) {
            try {
                this.physicalConnection = (oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.physicalConnection;
    }

    public DatumWithConnection(byte[] byArray) throws SQLException {
        super(byArray);
    }

    public DatumWithConnection() {
    }

    public static void assertNotNull(Connection connection) throws SQLException {
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(68, "Connection is null").fillInStackTrace();
        }
    }

    public static void assertNotNull(TypeDescriptor typeDescriptor) throws SQLException {
        if (typeDescriptor == null) {
            throw (SQLException)DatabaseError.createSqlException(61).fillInStackTrace();
        }
    }

    @Override
    public void setPhysicalConnectionOf(Connection connection) {
        if (this.ojiOracleDatumWithConnection != null) {
            this.ojiOracleDatumWithConnection.setPhysicalConnectionOf(connection);
        } else if (this.targetDatumWithConnection != null) {
            this.targetDatumWithConnection.setPhysicalConnectionOf(connection);
        } else {
            this.physicalConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getJavaSqlConnection();
        }
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.OracleConnection getOracleConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getOracleConnection();
        }
        return this.getPhysicalConnection().getWrapper();
    }

    @Override
    public oracle.jdbc.internal.OracleConnection getInternalConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getInternalConnection();
        }
        return this.getPhysicalConnection();
    }

    @Override
    public OracleConnection getConnection() throws SQLException {
        if (this.ojiOracleDatumWithConnection != null) {
            return this.ojiOracleDatumWithConnection.getConnection();
        }
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getConnection();
        }
        OracleConnection oracleConnection = null;
        try {
            oracleConnection = (OracleConnection)((OracleConnection)this.physicalConnection).getWrapper();
        }
        catch (ClassCastException classCastException) {
            throw (SQLException)DatabaseError.createSqlException(103).fillInStackTrace();
        }
        return oracleConnection;
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        if (this.targetDatumWithConnection != null) {
            return this.targetDatumWithConnection.getConnectionDuringExceptionHandling();
        }
        return this.physicalConnection;
    }
}

