/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.line.PlaceholderReplacingLine;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilder;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class SqlScript
implements Comparable<SqlScript> {
    private static final Log LOG = LogFactory.getLog(SqlScript.class);
    private final SqlStatementBuilderFactory sqlStatementBuilderFactory;
    private final boolean mixed;
    private final List<SqlStatement> sqlStatements;
    private boolean transactionalStatementFound;
    private boolean nonTransactionalStatementFound;
    protected final LoadableResource resource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlScript(SqlStatementBuilderFactory sqlStatementBuilderFactory, LoadableResource resource, boolean mixed) {
        this.resource = resource;
        this.sqlStatementBuilderFactory = sqlStatementBuilderFactory;
        this.mixed = mixed;
        LOG.debug("Parsing " + resource.getFilename() + " ...");
        LineReader reader = null;
        try {
            reader = resource.loadAsString();
            this.sqlStatements = this.extractStatements(reader);
        }
        finally {
            IOUtils.close(reader);
        }
    }

    private List<SqlStatement> extractStatements(LineReader reader) {
        Line line;
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        Delimiter nonStandardDelimiter = null;
        SqlStatementBuilder sqlStatementBuilder = this.sqlStatementBuilderFactory.createSqlStatementBuilder();
        while ((line = reader.readLine()) != null) {
            line = new PlaceholderReplacingLine(line, this.sqlStatementBuilderFactory.getPlaceholderReplacer());
            String lineStr = line.getLine();
            if (sqlStatementBuilder.isEmpty() && !StringUtils.hasText(lineStr)) continue;
            if (!sqlStatementBuilder.hasNonCommentPart()) {
                Delimiter newDelimiter = sqlStatementBuilder.extractNewDelimiterFromLine(lineStr);
                if (newDelimiter != null) {
                    nonStandardDelimiter = newDelimiter;
                    continue;
                }
                if (nonStandardDelimiter != null) {
                    sqlStatementBuilder.setDelimiter(nonStandardDelimiter);
                }
            }
            try {
                sqlStatementBuilder.addLine(line);
            }
            catch (Exception e) {
                throw new FlywayException("Flyway parsing bug (" + e.getMessage() + ") at line " + line.getLineNumber() + ": " + lineStr, e);
            }
            if (sqlStatementBuilder.canDiscard()) {
                sqlStatementBuilder = this.sqlStatementBuilderFactory.createSqlStatementBuilder();
                continue;
            }
            if (!sqlStatementBuilder.isTerminated()) continue;
            this.addStatement(statements, sqlStatementBuilder);
            sqlStatementBuilder = this.sqlStatementBuilderFactory.createSqlStatementBuilder();
        }
        if (!sqlStatementBuilder.isEmpty() && sqlStatementBuilder.hasNonCommentPart()) {
            this.addStatement(statements, sqlStatementBuilder);
        }
        return statements;
    }

    private void addStatement(List<SqlStatement> statements, SqlStatementBuilder sqlStatementBuilder) {
        SqlStatement sqlStatement = sqlStatementBuilder.getSqlStatement();
        statements.add(sqlStatement);
        if (sqlStatementBuilder.executeInTransaction()) {
            this.transactionalStatementFound = true;
        } else {
            this.nonTransactionalStatementFound = true;
        }
        if (!this.mixed && this.transactionalStatementFound && this.nonTransactionalStatementFound) {
            throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
        }
        LOG.debug("Found statement at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatementBuilder.executeInTransaction() ? "" : " [non-transactional]"));
    }

    public List<SqlStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    public Collection<SqlScript> getReferencedSqlScripts() {
        TreeSet<SqlScript> referencedSqlScripts = new TreeSet<SqlScript>();
        for (SqlStatement sqlStatement : this.sqlStatements) {
            SqlScript referencedSqlScript = sqlStatement.getReferencedSqlScript();
            if (referencedSqlScript == null) continue;
            referencedSqlScripts.add(referencedSqlScript);
            referencedSqlScripts.addAll(referencedSqlScript.getReferencedSqlScripts());
        }
        return referencedSqlScripts;
    }

    public final LoadableResource getResource() {
        return this.resource;
    }

    public boolean executeInTransaction() {
        return !this.nonTransactionalStatementFound;
    }

    @Override
    public int compareTo(SqlScript o) {
        return this.resource.getRelativePath().compareTo(o.resource.getRelativePath());
    }
}

