/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLConnection;
import org.flywaydb.core.internal.database.postgresql.PostgreSQLSqlStatementBuilderFactory;
import org.flywaydb.core.internal.jdbc.pro.DryRunStatementInterceptor;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlStatementBuilderFactory;
import org.flywaydb.core.internal.util.StringUtils;

public class PostgreSQLDatabase
extends Database<PostgreSQLConnection> {
    public PostgreSQLDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit, DryRunStatementInterceptor dryRunStatementInterceptor) {
        super(configuration, connection, originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    protected PostgreSQLConnection getConnection(Connection connection, DryRunStatementInterceptor dryRunStatementInterceptor) {
        return new PostgreSQLConnection(this.configuration, this, connection, this.originalAutoCommit, dryRunStatementInterceptor);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("PostgreSQL", "9.0");
        this.ensureDatabaseIsCompatibleWithFlywayEdition("PostgreSQL", "PostgreSQL", "9.3");
        this.recommendFlywayUpgradeIfNecessaryForMajorVersion("PostgreSQL", "10");
    }

    @Override
    protected SqlStatementBuilderFactory createSqlStatementBuilderFactory(PlaceholderReplacer placeholderReplacer, ResourceProvider resourceProvider) {
        return new PostgreSQLSqlStatementBuilderFactory(placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "postgresql";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((PostgreSQLConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return PostgreSQLDatabase.pgQuote(identifier);
    }

    static String pgQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

