/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.util.List;
import java.util.Locale;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderReplacer;
import org.flywaydb.core.internal.database.oracle.pro.ServerOutputFormat;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusSetSqlStatement
extends AbstractSQLPlusSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusSetSqlStatement.class);
    private Boolean heading;
    private Boolean serverOutput;
    String serverOutputSize;
    private ServerOutputFormat serverOutputFormat;
    private String flagger;
    private Integer feedback;
    private Integer lineSize;
    String nullText;
    private String unknown;

    public SQLPlusSetSqlStatement(List<Line> lines, SQLPlusPlaceholderReplacer sqlPlusPlaceholderReplacer) {
        super(lines);
        List<String> allTokens = StringUtils.tokenizeToStringCollection(this.getSql(), ' ', '\"');
        if (allTokens.size() == 1) {
            throw new FlywayException("SP2-0545: SET command requires an argument.");
        }
        for (int pos = 1; pos < allTokens.size(); ++pos) {
            if (this.tokenMatches(allTokens, pos, "SERVEROUT(PUT)?")) {
                this.serverOutput = this.tokenEquals(allTokens, ++pos, "ON");
                if (this.serverOutput.booleanValue()) {
                    if (!this.tokenEquals(allTokens, ++pos, "SIZE")) continue;
                    this.serverOutputSize = this.getToken(allTokens, ++pos);
                    if (!this.tokenMatches(allTokens, pos + 1, "FOR(MAT)?") || !this.tokenMatches(allTokens, pos + 2, "(WRA(PPED)?)|(WOR(D_WRAPPED)?)|(TRUN(CATED)?)")) continue;
                    ++pos;
                    this.serverOutputFormat = ServerOutputFormat.fromText(this.getToken(allTokens, ++pos));
                    continue;
                }
                this.serverOutputSize = "UNLIMITED";
                this.serverOutputFormat = ServerOutputFormat.WORD_WRAPPED;
                continue;
            }
            if (this.tokenEquals(allTokens, pos, "NULL")) {
                this.nullText = this.getToken(allTokens, ++pos);
                continue;
            }
            if (this.tokenMatches(allTokens, pos, "DEF(INE)?")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    sqlPlusPlaceholderReplacer.setDefineOn(true);
                    sqlPlusPlaceholderReplacer.setDefineChar('&');
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    sqlPlusPlaceholderReplacer.setDefineOn(false);
                    continue;
                }
                if (this.tokenMatches(allTokens, pos, "[^A-Z0-9 ]")) {
                    sqlPlusPlaceholderReplacer.setDefineOn(true);
                    sqlPlusPlaceholderReplacer.setDefineChar(allTokens.get(pos).charAt(0));
                    continue;
                }
                throw new FlywayException("Missing argument for SET DEFINE");
            }
            if (this.tokenMatches(allTokens, pos, "ESC(APE)?")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    sqlPlusPlaceholderReplacer.setEscapeOn(true);
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    sqlPlusPlaceholderReplacer.setEscapeOn(false);
                    continue;
                }
                if (this.tokenMatches(allTokens, pos, "[^A-Z0-9 ]")) {
                    sqlPlusPlaceholderReplacer.setEscapeChar(allTokens.get(pos).charAt(0));
                    continue;
                }
                throw new FlywayException("Missing argument for SET DEFINE");
            }
            if (this.tokenMatches(allTokens, pos, "FEED(BACK)?")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    this.feedback = 1;
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    this.feedback = 0;
                    continue;
                }
                if (this.tokenMatches(allTokens, pos, "[0-9]{1-5}")) {
                    this.feedback = Integer.parseInt(allTokens.get(pos));
                    continue;
                }
                throw new FlywayException("SP2-0267: feedback option " + this.getToken(allTokens, pos) + " out of range (0 through 50000)");
            }
            if (this.tokenEquals(allTokens, pos, "FLAGGER")) {
                if (this.tokenMatches(allTokens, ++pos, "OFF|ENTRY|INTERMED(IATE)?|FULL")) {
                    this.flagger = this.getToken(allTokens, pos);
                    continue;
                }
                throw new FlywayException("Missing argument for SET FLAGGER");
            }
            if (this.tokenEquals(allTokens, pos, "SCAN")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    sqlPlusPlaceholderReplacer.setDefineOn(true);
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    sqlPlusPlaceholderReplacer.setDefineOn(false);
                    continue;
                }
                throw new FlywayException("SP2-0265: scan must be set ON or OFF");
            }
            if (this.tokenMatches(allTokens, pos, "HEA(DING)?")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    this.heading = true;
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    this.heading = false;
                    continue;
                }
                throw new FlywayException("SP2-0265: heading must be set ON or OFF");
            }
            if (this.tokenMatches(allTokens, pos, "SUF(FIX)?")) {
                sqlPlusPlaceholderReplacer.setSuffix(this.getToken(allTokens, ++pos));
                continue;
            }
            if (this.tokenMatches(allTokens, pos, "LIN(ESIZE)?")) {
                if (this.tokenMatches(allTokens, ++pos, "[0-9]{1,5}")) {
                    this.lineSize = Integer.parseInt(allTokens.get(pos));
                    sqlPlusPlaceholderReplacer.setLineSize(this.lineSize);
                    continue;
                }
                throw new FlywayException("SP2-0268: linesize option not a valid number");
            }
            if (this.tokenMatches(allTokens, pos, "VER(IFY)?")) {
                if (this.tokenEquals(allTokens, ++pos, "ON")) {
                    sqlPlusPlaceholderReplacer.setVerifyOn(true);
                    continue;
                }
                if (this.tokenEquals(allTokens, pos, "OFF")) {
                    sqlPlusPlaceholderReplacer.setVerifyOn(false);
                    continue;
                }
                throw new FlywayException("SP2-0265: verify must be set ON or OFF");
            }
            this.unknown = this.getToken(allTokens, pos);
        }
    }

    private String getToken(List<String> allTokens, int pos) {
        if (pos >= allTokens.size()) {
            return null;
        }
        return allTokens.get(pos);
    }

    private boolean tokenMatches(List<String> allTokens, int pos, String regex) {
        if (pos >= allTokens.size()) {
            return false;
        }
        return allTokens.get(pos).toUpperCase(Locale.ENGLISH).matches(regex);
    }

    private boolean tokenEquals(List<String> allTokens, int pos, String str) {
        if (pos >= allTokens.size()) {
            return false;
        }
        return allTokens.get(pos).toUpperCase(Locale.ENGLISH).equals(str);
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        if (Boolean.TRUE.equals(this.serverOutput)) {
            OracleResults oracleResults = new OracleResults(jdbcTemplate.executeStatement("BEGIN\nDBMS_OUTPUT.ENABLE(" + (this.serverOutputSize != null && this.serverOutputSize.matches("[0-9]{4,7}") ? this.serverOutputSize : "buffer_size => NULL") + ");\nEND;"));
            oracleResults.setServerOutput(true);
            if (this.serverOutputSize != null) {
                oracleResults.setServerOutputSize(this.serverOutputSize);
            }
            if (this.serverOutputFormat != null) {
                oracleResults.setServerOutputFormat(this.serverOutputFormat);
            }
            return oracleResults;
        }
        if (Boolean.FALSE.equals(this.serverOutput)) {
            OracleResults oracleResults = new OracleResults(jdbcTemplate.executeStatement("BEGIN\nDBMS_OUTPUT.DISABLE;\nEND;"));
            oracleResults.setServerOutput(false);
            return oracleResults;
        }
        if (this.nullText != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setNullText(this.nullText);
            return oracleResults;
        }
        if (this.flagger != null) {
            return jdbcTemplate.executeStatement("ALTER SESSION SET FLAGGER=" + this.flagger);
        }
        if (this.heading != null) {
            OracleResults oracleResults = new OracleResults();
            oracleResults.setHeading(this.heading);
            return oracleResults;
        }
        if (this.lineSize != null) {
            if (this.lineSize < 1 || this.lineSize > Short.MAX_VALUE) {
                throw new FlywayException("SP2-0267: linesize option " + this.lineSize + " out of range (1 through 32767)");
            }
            OracleResults oracleResults = new OracleResults();
            oracleResults.setLineSize(this.lineSize);
            return oracleResults;
        }
        if (this.feedback != null) {
            if (this.feedback < 0 || this.feedback > 50000) {
                throw new FlywayException("SP2-0267: feedback option " + this.feedback + " out of range (0 through 50000)");
            }
            OracleResults oracleResults = new OracleResults();
            oracleResults.setFeedback(this.feedback);
            return oracleResults;
        }
        if (this.unknown != null) {
            LOG.warn("SP2-0158: unknown SET option \"" + this.unknown + "\"");
        }
        return new OracleResults();
    }
}

