/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.StandardSqlStatement;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class SqlStatementBuilder {
    protected final List<Line> lines = new ArrayList<Line>();
    private boolean terminated;
    protected boolean insideQuoteStringLiteral = false;
    protected boolean insideAlternateQuoteStringLiteral = false;
    private String alternateQuote;
    private boolean lineEndsWithSingleLineComment = false;
    protected boolean insideMultiLineComment = false;
    protected int firstNonCommentLine = -1;
    private int nestedBlockDepth = 0;
    protected boolean executeInTransaction = true;
    protected final Delimiter defaultDelimiter;
    protected Delimiter delimiter;

    public SqlStatementBuilder(Delimiter defaultDelimiter) {
        this.defaultDelimiter = defaultDelimiter;
        this.delimiter = defaultDelimiter;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public final boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    protected boolean hasNonCommentPart() {
        return this.firstNonCommentLine >= 0;
    }

    public SqlStatement getSqlStatement() {
        return new StandardSqlStatement(this.lines, this.delimiter);
    }

    public Delimiter extractNewDelimiterFromLine(String line) {
        return null;
    }

    public boolean isCommentDirective(String line) {
        return false;
    }

    protected boolean isSingleLineComment(String line) {
        return line.startsWith("--");
    }

    public void addLine(Line sqlLine) {
        String line = sqlLine.getLine();
        String lineTrimmed = line.trim();
        String lineSimplified = this.simplifyLine(lineTrimmed);
        if (this.isEmpty() && this.delimiter != null && lineSimplified.equals(this.delimiter.getDelimiter().toUpperCase())) {
            return;
        }
        if (this.isCommentDirective(lineTrimmed)) {
            this.firstNonCommentLine = this.lines.size();
        }
        this.applyStateChanges(lineSimplified);
        if (this.endWithOpenMultilineStringLiteral() || this.insideMultiLineComment) {
            this.lines.add(sqlLine);
            return;
        }
        this.delimiter = this.changeDelimiterIfNecessary(lineSimplified, this.delimiter);
        if (!this.lineEndsWithSingleLineComment && this.lineTerminatesStatement(lineSimplified, this.delimiter)) {
            this.terminated = true;
        }
        this.lines.add(sqlLine);
    }

    boolean endWithOpenMultilineStringLiteral() {
        return this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral;
    }

    public boolean canDiscard() {
        return !this.insideAlternateQuoteStringLiteral && !this.insideQuoteStringLiteral && !this.insideMultiLineComment && this.firstNonCommentLine < 0 && (this.lines.isEmpty() || !StringUtils.hasText(this.lines.get(this.lines.size() - 1).getLine()));
    }

    protected String simplifyLine(String line) {
        String cleanLine = this.removeEscapedQuotes(line).replace("--", " -- ").replace("/*", " /* ").replace("*/", " */ ");
        return StringUtils.collapseWhitespace(cleanLine).trim().toUpperCase();
    }

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        return delimiter;
    }

    private boolean lineTerminatesStatement(String line, Delimiter delimiter) {
        if (delimiter == null || this.defaultDelimiter.equals(delimiter) && this.nestedBlockDepth > 0) {
            return false;
        }
        String upperCaseDelimiter = delimiter.getDelimiter().toUpperCase();
        if (delimiter.isAloneOnLine()) {
            return line.equals(upperCaseDelimiter);
        }
        return line.endsWith(upperCaseDelimiter);
    }

    protected String extractAlternateOpenQuote(String token) {
        return null;
    }

    protected String computeAlternateCloseQuote(String openQuote) {
        return openQuote;
    }

    protected void applyStateChanges(String line) {
        Collection<String> tokens = this.tokenizeLine(line);
        List<TokenType> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        this.lineEndsWithSingleLineComment = false;
        for (TokenType delimitingToken : delimitingTokens) {
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT_OPEN.equals((Object)delimitingToken)) {
                this.insideMultiLineComment = true;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && TokenType.MULTI_LINE_COMMENT_CLOSE.equals((Object)delimitingToken)) {
                this.insideMultiLineComment = false;
            }
            if (!this.insideQuoteStringLiteral && !this.insideAlternateQuoteStringLiteral && !this.insideMultiLineComment && TokenType.SINGLE_LINE_COMMENT.equals((Object)delimitingToken)) {
                this.lineEndsWithSingleLineComment = true;
                return;
            }
            if (!this.insideMultiLineComment && !this.insideQuoteStringLiteral && TokenType.ALTERNATE_QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideAlternateQuoteStringLiteral = !this.insideAlternateQuoteStringLiteral;
            }
            if (!this.insideMultiLineComment && !this.insideAlternateQuoteStringLiteral && TokenType.QUOTE.equals((Object)delimitingToken)) {
                boolean bl = this.insideQuoteStringLiteral = !this.insideQuoteStringLiteral;
            }
            if (this.insideMultiLineComment || this.insideQuoteStringLiteral || this.insideAlternateQuoteStringLiteral || !TokenType.OTHER.equals((Object)delimitingToken) && !TokenType.BLOCK_BEGIN.equals((Object)delimitingToken) && !TokenType.BLOCK_END.equals((Object)delimitingToken)) continue;
            if (!this.hasNonCommentPart()) {
                this.firstNonCommentLine = this.lines.size();
            }
            if (!this.isBlockStatement()) continue;
            if (TokenType.BLOCK_BEGIN.equals((Object)delimitingToken)) {
                ++this.nestedBlockDepth;
                continue;
            }
            if (!TokenType.BLOCK_END.equals((Object)delimitingToken)) continue;
            --this.nestedBlockDepth;
        }
    }

    protected boolean isBlockStatement() {
        return false;
    }

    protected Collection<String> tokenizeLine(String line) {
        return StringUtils.tokenizeToStringCollection(line, " @<>;:=|(),+{}");
    }

    private List<TokenType> extractStringLiteralDelimitingTokens(Collection<String> tokens) {
        ArrayList<TokenType> delimitingTokens = new ArrayList<TokenType>();
        for (String token : tokens) {
            String alternateQuoteFromToken;
            String cleanToken = this.cleanToken(token);
            boolean handled = false;
            if (this.alternateQuote == null && (alternateQuoteFromToken = this.extractAlternateOpenQuote(cleanToken)) != null) {
                String closeQuote = this.computeAlternateCloseQuote(alternateQuoteFromToken);
                if (cleanToken.length() >= alternateQuoteFromToken.length() + closeQuote.length() && cleanToken.startsWith(alternateQuoteFromToken) && cleanToken.endsWith(closeQuote)) continue;
                this.alternateQuote = closeQuote;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (this.alternateQuote != null && cleanToken.endsWith(this.alternateQuote)) {
                this.alternateQuote = null;
                delimitingTokens.add(TokenType.ALTERNATE_QUOTE);
                continue;
            }
            if (cleanToken.length() >= 2 && cleanToken.startsWith("'") && cleanToken.endsWith("'")) continue;
            if (cleanToken.length() >= 4) {
                int numberOfOpeningMultiLineComments = StringUtils.countOccurrencesOf(cleanToken, "/*");
                int numberOfClosingMultiLineComments = StringUtils.countOccurrencesOf(cleanToken, "*/");
                if (numberOfOpeningMultiLineComments > 0 && numberOfOpeningMultiLineComments == numberOfClosingMultiLineComments) continue;
            }
            if (this.isSingleLineComment(cleanToken)) {
                delimitingTokens.add(TokenType.SINGLE_LINE_COMMENT);
                handled = true;
            }
            if (cleanToken.contains("/*")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT_OPEN);
                handled = true;
            } else if (cleanToken.startsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (!cleanToken.contains("/*") && cleanToken.contains("*/")) {
                delimitingTokens.add(TokenType.MULTI_LINE_COMMENT_CLOSE);
                handled = true;
            } else if (!cleanToken.startsWith("'") && cleanToken.endsWith("'")) {
                delimitingTokens.add(TokenType.QUOTE);
                handled = true;
            }
            if (handled) continue;
            if (this.isBlockBeginToken(cleanToken)) {
                delimitingTokens.add(TokenType.BLOCK_BEGIN);
                continue;
            }
            if (this.isBlockEndToken(cleanToken)) {
                delimitingTokens.add(TokenType.BLOCK_END);
                continue;
            }
            delimitingTokens.add(TokenType.OTHER);
        }
        return delimitingTokens;
    }

    protected boolean isBlockBeginToken(String token) {
        return false;
    }

    protected boolean isBlockEndToken(String token) {
        return false;
    }

    protected String removeEscapedQuotes(String token) {
        return token.replace("''", "");
    }

    protected String cleanToken(String token) {
        return token;
    }

    public boolean executeInTransaction() {
        return this.executeInTransaction;
    }

    private static enum TokenType {
        OTHER,
        QUOTE,
        ALTERNATE_QUOTE,
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT_OPEN,
        MULTI_LINE_COMMENT_CLOSE,
        BLOCK_BEGIN,
        BLOCK_END;

    }
}

