/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.sqlscript;

import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Locale;
import org.flywaydb.core.internal.line.Line;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlStatement;

public abstract class AbstractSqlStatement
implements SqlStatement {
    protected final List<Line> lines;
    private final Delimiter delimiter;
    private final boolean batchable;
    private SoftReference<String> sqlRef;

    public AbstractSqlStatement(List<Line> lines, Delimiter delimiter, boolean batchable) {
        this.lines = lines;
        this.delimiter = delimiter;
        this.batchable = batchable;
    }

    @Override
    public final int getLineNumber() {
        return this.lines.get(0).getLineNumber();
    }

    @Override
    public final String getSql() {
        String sql;
        String string = sql = this.sqlRef == null ? null : this.sqlRef.get();
        if (sql == null) {
            StringBuilder sqlBuilder = new StringBuilder();
            for (Line line : this.lines) {
                sqlBuilder.append(this.getLine(line));
            }
            this.stripDelimiter(sqlBuilder, this.delimiter);
            sql = sqlBuilder.toString();
            this.sqlRef = new SoftReference<String>(sql);
        }
        return sql;
    }

    protected String getLine(Line line) {
        return line.getLine();
    }

    @Override
    public String getDelimiter() {
        return this.delimiter.toString();
    }

    protected void stripDelimiter(StringBuilder sql, Delimiter delimiter) {
        this.stripTrailingWhitespace(sql);
        int length = delimiter.getDelimiter().length();
        if (length > sql.length()) {
            return;
        }
        String actualDelimiter = sql.substring(sql.length() - length, sql.length());
        if (actualDelimiter.toUpperCase(Locale.ENGLISH).equals(delimiter.getDelimiter().toUpperCase(Locale.ENGLISH))) {
            sql.delete(sql.length() - length, sql.length());
        }
    }

    protected void stripTrailingWhitespace(StringBuilder sql) {
        while (Character.isWhitespace(sql.charAt(sql.length() - 1))) {
            sql.delete(sql.length() - 1, sql.length());
        }
    }

    @Override
    public boolean isBatchable() {
        return this.batchable;
    }

    @Override
    public SqlScript getReferencedSqlScript() {
        return null;
    }
}

