/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusPlaceholderReplacer
implements PlaceholderReplacer {
    private static final Log LOG = LogFactory.getLog(SQLPlusPlaceholderReplacer.class);
    static final char DEFAULT_DEFINE_CHAR = '&';
    private static final char DEFAULT_ESCAPE_CHAR = '\\';
    private final Map<String, String> sqlplusPlaceholders = new HashMap<String, String>();
    private final PlaceholderReplacer placeholderReplacer;
    private final boolean oracleSqlplus;
    private boolean defineOn = true;
    private char defineChar = (char)38;
    private boolean verifyOn = true;
    private boolean escapeOn = true;
    private char escapeChar = (char)92;
    private Pattern anyPlaceholderPattern = this.compileAnyPlaceholderPattern();
    private String suffix = "sql";
    private int lineSize = 80;

    public SQLPlusPlaceholderReplacer(PlaceholderReplacer placeholderReplacer, boolean oracleSqlplus, String user, String connectIdentifier, String oRelease, String oVersion) {
        this.placeholderReplacer = placeholderReplacer;
        this.oracleSqlplus = oracleSqlplus;
        this.sqlplusPlaceholders.put("_CONNECT_IDENTIFIER", connectIdentifier);
        this.sqlplusPlaceholders.put("_DATE", new SimpleDateFormat("dd-MMM-YY", Locale.ENGLISH).format(new Date()).toUpperCase(Locale.ENGLISH));
        this.sqlplusPlaceholders.put("_EDITOR", "");
        this.sqlplusPlaceholders.put("_O_RELEASE", oRelease);
        this.sqlplusPlaceholders.put("_O_VERSION", oVersion);
        this.sqlplusPlaceholders.put("_PRIVILEGE", "");
        this.sqlplusPlaceholders.put("_SQLPLUS_RELEASE", "1202000100");
        this.sqlplusPlaceholders.put("_USER", user);
    }

    @Override
    public Map<String, String> getPlaceholderReplacements() {
        HashMap<String, String> placeholderReplacements = new HashMap<String, String>(this.placeholderReplacer.getPlaceholderReplacements());
        placeholderReplacements.putAll(this.sqlplusPlaceholders);
        return placeholderReplacements;
    }

    @Override
    public String replacePlaceholders(String input) {
        String result = this.placeholderReplacer.replacePlaceholders(input);
        if (this.oracleSqlplus && this.defineOn) {
            Matcher matcher;
            boolean replaced = false;
            Map<String, String> placeholders = this.getPlaceholderReplacements();
            TreeSet<String> unmatchedPlaceHolderExpressions = new TreeSet<String>();
            while ((matcher = this.anyPlaceholderPattern.matcher(result)).find()) {
                String searchTerm = matcher.group(3).toLowerCase(Locale.ENGLISH);
                if (!placeholders.containsKey(searchTerm)) {
                    unmatchedPlaceHolderExpressions.add(matcher.group(1));
                    result = StringUtils.replace(result, matcher.group(1), "");
                    continue;
                }
                result = StringUtils.replace(result, matcher.group(2), placeholders.get(searchTerm));
                replaced = true;
            }
            if (!unmatchedPlaceHolderExpressions.isEmpty()) {
                throw new FlywayException("No value provided for placeholder expressions: " + StringUtils.collectionToCommaDelimitedString(unmatchedPlaceHolderExpressions) + ".  Check your configuration!");
            }
            if (this.escapeOn) {
                result = StringUtils.replace(result, "" + this.escapeChar + this.defineChar, "" + this.defineChar);
            }
            if (replaced && this.verifyOn) {
                LOG.info("old   1: " + input.trim());
                LOG.info("new   1: " + result.trim());
            }
        }
        return result;
    }

    private Pattern compileAnyPlaceholderPattern() {
        String escape = this.escapeOn ? "[^" + Pattern.quote("" + this.escapeChar) + "]" : "";
        String regex = "(" + escape + "(" + Pattern.quote("" + this.defineChar) + "(?i)(.+?)))([^a-z0-9A-Z_]|$)";
        return Pattern.compile(regex);
    }

    public void setDefineOn(boolean defineOn) {
        this.defineOn = defineOn;
        this.anyPlaceholderPattern = this.compileAnyPlaceholderPattern();
    }

    public void setDefineChar(char defineChar) {
        this.defineChar = defineChar;
        this.anyPlaceholderPattern = this.compileAnyPlaceholderPattern();
    }

    public void setEscapeOn(boolean escapeOn) {
        this.escapeOn = escapeOn;
        this.escapeChar = (char)92;
        this.anyPlaceholderPattern = this.compileAnyPlaceholderPattern();
    }

    public void setEscapeChar(char escapeChar) {
        this.escapeOn = true;
        this.escapeChar = escapeChar;
        this.anyPlaceholderPattern = this.compileAnyPlaceholderPattern();
    }

    public void define(String key, String value) {
        this.sqlplusPlaceholders.put(key.toLowerCase(Locale.ENGLISH), value);
    }

    public void undefine(String key) {
        this.sqlplusPlaceholders.remove(key.toLowerCase(Locale.ENGLISH));
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
    }

    public boolean isDefineOn() {
        return this.defineOn;
    }

    public char getDefineChar() {
        return this.defineChar;
    }

    public boolean isEscapeOn() {
        return this.escapeOn;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public boolean isVerifyOn() {
        return this.verifyOn;
    }

    public void setVerifyOn(boolean verifyOn) {
        this.verifyOn = verifyOn;
    }
}

