--
-- Copyright 2010-2018 Boxfuse GmbH
--
--
-- Boxfuse GmbH grants the Licensee a non-exclusive,
-- timely limited and non-transferable license
-- to install and use the Software under the terms of
-- the Flyway License and Maintenance Agreement.
--
--
-- This software is distributed with a LIMITED WARRANTY.
-- See the Flyway License and Maintenance Agreement
-- for more details:
-- https://flywaydb.org/licenses/flyway-trial.txt
--

CREATE TABLE ${table} (
    installed_rank INT NOT NULL,
    version VARCHAR(50) NULL,
    description VARCHAR(200) NOT NULL,
    type VARCHAR(20) NOT NULL,
    script VARCHAR(1000) NOT NULL,
    checksum INT NULL,
    installed_by VARCHAR(100) NOT NULL,
    installed_on datetime DEFAULT getDate() NOT NULL,
    execution_time INT NOT NULL,
    success decimal NOT NULL,
    PRIMARY KEY (installed_rank)
)
lock datarows on 'default'
go

CREATE INDEX ${table}_s_idx ON ${table} (success)
go

