/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.function.BiFunction;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.read.ErrorPacket;
import org.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import org.mariadb.jdbc.internal.com.send.gssapi.GssUtility;
import org.mariadb.jdbc.internal.com.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.com.send.gssapi.StandardGssapiAuthentication;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class SendGssApiAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    private static final BiFunction<PacketInputStream, Integer, GssapiAuth> gssMethod;
    private final PacketInputStream reader;

    public SendGssApiAuthPacket(PacketInputStream reader, String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
        this.reader = reader;
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException, SQLException {
        Buffer buffer = new Buffer(this.authData);
        String serverPrincipalName = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        String mechanisms = buffer.readStringNullEnd(StandardCharsets.UTF_8);
        if (mechanisms.isEmpty()) {
            mechanisms = "Kerberos";
        }
        GssapiAuth gssapiAuth = gssMethod.apply(this.reader, this.packSeq);
        gssapiAuth.authenticate(pos, serverPrincipalName, mechanisms);
    }

    @Override
    public void handleResultPacket(PacketInputStream reader) throws SQLException, IOException {
        try {
            Buffer buffer = reader.getPacket(true);
            if (buffer.getByteAt(0) == -1) {
                ErrorPacket ep = new ErrorPacket(buffer);
                String message = ep.getMessage();
                throw new SQLException("Could not connect: " + message, ep.getSqlState(), ep.getErrorNumber());
            }
        }
        catch (EOFException e) {
            throw new SQLException("Authentication exception", "28000", 1045, e);
        }
    }

    static {
        BiFunction<PacketInputStream, Integer, GssapiAuth> init;
        try {
            init = GssUtility.getAuthenticationMethod();
        }
        catch (Throwable t) {
            BiFunction<PacketInputStream, Integer, GssapiAuth> defaultAuthenticationMethod = (reader, packSeq) -> new StandardGssapiAuthentication((PacketInputStream)reader, (int)packSeq);
            init = defaultAuthenticationMethod;
        }
        gssMethod = init;
    }
}

