/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc.pro;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.Warning;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.pro.ErrorOverride;

public class ErrorOverrideCallback
implements Callback {
    private static final Log LOG = LogFactory.getLog(ErrorOverrideCallback.class);
    private final List<ErrorOverride> errorOverrides = new ArrayList<ErrorOverride>();

    public ErrorOverrideCallback(String ... errorOverrides) {
        for (String errorOverride : errorOverrides) {
            this.errorOverrides.add(new ErrorOverride(errorOverride));
        }
    }

    @Override
    public boolean supports(Event event, Context context) {
        return !this.errorOverrides.isEmpty() && (event == Event.AFTER_EACH_MIGRATE_STATEMENT || event == Event.AFTER_EACH_MIGRATE_STATEMENT_ERROR || event == Event.AFTER_EACH_UNDO_STATEMENT || event == Event.AFTER_EACH_UNDO_STATEMENT_ERROR);
    }

    @Override
    public boolean canHandleInTransaction(Event event, Context context) {
        return false;
    }

    @Override
    public void handle(Event event, Context context) {
        if (this.errorOverrides.isEmpty()) {
            return;
        }
        boolean suppressErrors = false;
        for (ErrorOverride errorOverride : this.errorOverrides) {
            for (Error error : context.getStatement().getErrors()) {
                if (!error.getState().equals(errorOverride.getState()) || error.getCode() != errorOverride.getCode() || errorOverride.getBehavior() != ErrorOverride.ErrorOverrideBehavior.WARNING) continue;
                LOG.warn(error.getMessage() + " (SQL state: " + error.getState() + ", error code: " + error.getCode() + ")");
                suppressErrors = true;
            }
            for (Warning warning : context.getStatement().getWarnings()) {
                if (!warning.getState().equals(errorOverride.getState()) || warning.getCode() != errorOverride.getCode() || errorOverride.getBehavior() != ErrorOverride.ErrorOverrideBehavior.ERROR) continue;
                throw new FlywayException(warning.getMessage() + " (SQL state: " + warning.getState() + ", error code: " + warning.getCode() + ")");
            }
        }
        context.getStatement().setSuppressErrors(suppressErrors);
    }
}

