/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.sqlite;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.sqlite.SQLiteDatabase;
import org.flywaydb.core.internal.database.sqlite.SQLiteTable;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class SQLiteSchema
extends Schema<SQLiteDatabase> {
    private static final Log LOG = LogFactory.getLog(SQLiteSchema.class);
    private static final List<String> IGNORED_SYSTEM_TABLE_NAMES = Arrays.asList("android_metadata", "sqlite_sequence");

    SQLiteSchema(JdbcTemplate jdbcTemplate, SQLiteDatabase database, String name) {
        super(jdbcTemplate, database, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        try {
            this.doAllTables();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        Table[] tables = this.allTables();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tables) {
            String tableName = table.getName();
            if (IGNORED_SYSTEM_TABLE_NAMES.contains(tableName)) continue;
            tableNames.add(tableName);
        }
        return tableNames.isEmpty();
    }

    @Override
    protected void doCreate() throws SQLException {
        LOG.info("SQLite does not support creating schemas. Schema not created: " + this.name);
    }

    @Override
    protected void doDrop() throws SQLException {
        LOG.info("SQLite does not support dropping schemas. Schema not dropped: " + this.name);
    }

    @Override
    protected void doClean() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT tbl_name FROM " + ((SQLiteDatabase)this.database).quote(this.name) + ".sqlite_master WHERE type='view'", new String[0]);
        for (String viewName : viewNames) {
            this.jdbcTemplate.execute("DROP VIEW " + ((SQLiteDatabase)this.database).quote(this.name, viewName), new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
        if (this.getTable("sqlite_sequence").exists()) {
            this.jdbcTemplate.execute("DELETE FROM sqlite_sequence", new Object[0]);
        }
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT tbl_name FROM " + ((SQLiteDatabase)this.database).quote(this.name) + ".sqlite_master WHERE type='table'", new String[0]);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new SQLiteTable(this.jdbcTemplate, this.database, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new SQLiteTable(this.jdbcTemplate, this.database, this, tableName);
    }
}

