/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.nio.charset.Charset;
import java.util.Date;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.pro.LicenseInfo;
import org.flywaydb.core.internal.line.LineReader;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.IOUtils;

public class VersionPrinter {
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);
    private static final String version = VersionPrinter.readVersion();
    private static boolean printed;

    private VersionPrinter() {
    }

    public static void printVersion(String licenseKey) {
        if (printed) {
            return;
        }
        printed = true;
        LicenseInfo licenseInfo = new LicenseInfo(licenseKey);
        LOG.info(licenseInfo.getLicenseType() + " " + version + " by Boxfuse" + " licensed to " + licenseInfo.getLicensedTo() + " until " + DateUtils.toDateString(licenseInfo.getValidUntil()));
        if (licenseInfo.getValidUntil().before(new Date())) {
            LOG.error("Your Flyway license has expired and is no longer valid. You must renew your license immediately to keep on using this software.");
        }
    }

    public static void printVersionOnly() {
        String edition = "Flyway Pro Edition";
        LOG.info(edition + " " + version + " by Boxfuse");
    }

    private static String readVersion() {
        String version;
        ClassPathResource resource = new ClassPathResource(null, "org/flywaydb/core/internal/version.txt", VersionPrinter.class.getClassLoader(), Charset.forName("UTF-8"));
        LineReader lineReader = null;
        try {
            lineReader = resource.loadAsString();
            version = lineReader.readLine().getLine();
        }
        finally {
            IOUtils.close(lineReader);
        }
        return version;
    }
}

