/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class DbInfo {
    private final MigrationResolver migrationResolver;
    private final SchemaHistory schemaHistory;
    private final Configuration configuration;
    private final CallbackExecutor callbackExecutor;

    public DbInfo(MigrationResolver migrationResolver, SchemaHistory schemaHistory, Configuration configuration, CallbackExecutor callbackExecutor) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.configuration = configuration;
        this.callbackExecutor = callbackExecutor;
    }

    public MigrationInfoService info() {
        MigrationInfoServiceImpl migrationInfoService;
        this.callbackExecutor.executeOnMainConnection(Event.BEFORE_INFO);
        try {
            migrationInfoService = new MigrationInfoServiceImpl(this.migrationResolver, this.schemaHistory, this.configuration.getTarget(), this.configuration.isOutOfOrder(), true, true, true, true);
            migrationInfoService.refresh();
        }
        catch (FlywayException e) {
            this.callbackExecutor.executeOnMainConnection(Event.AFTER_INFO_ERROR);
            throw e;
        }
        this.callbackExecutor.executeOnMainConnection(Event.AFTER_INFO);
        return migrationInfoService;
    }
}

