/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlScript;
import org.flywaydb.core.internal.database.redshift.RedshiftConnection;
import org.flywaydb.core.internal.database.redshift.RedshiftSqlScript;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.placeholder.PlaceholderReplacer;
import org.flywaydb.core.internal.util.scanner.LoadableResource;

public class RedshiftDatabase
extends Database<RedshiftConnection> {
    public static boolean isRedshift(Connection connection) {
        try {
            return new JdbcTemplate(connection).queryForString("SELECT version()", new String[0]).contains("Redshift");
        }
        catch (Exception e) {
            return false;
        }
    }

    public RedshiftDatabase(Configuration configuration, Connection connection, boolean originalAutoCommit) {
        super(configuration, connection, originalAutoCommit);
    }

    @Override
    protected RedshiftConnection getConnection(Connection connection) {
        return new RedshiftConnection(this.configuration, this, connection, this.originalAutoCommit);
    }

    @Override
    protected final void ensureSupported() {
    }

    @Override
    protected SqlScript doCreateSqlScript(LoadableResource sqlScriptResource, PlaceholderReplacer placeholderReplacer, boolean mixed) {
        return new RedshiftSqlScript(this.configuration, sqlScriptResource, mixed, placeholderReplacer);
    }

    @Override
    public String getDbName() {
        return "redshift";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((RedshiftConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    protected boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public String doQuote(String identifier) {
        return RedshiftDatabase.redshiftQuote(identifier);
    }

    static String redshiftQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

