/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.callback;

import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.callback.Context;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.callback.FlywayCallback;

public class LegacyCallback
implements Callback {
    private final FlywayCallback flywayCallback;

    public LegacyCallback(FlywayCallback flywayCallback) {
        this.flywayCallback = flywayCallback;
    }

    @Override
    public boolean supports(Event event, Context context) {
        return true;
    }

    @Override
    public boolean canHandleInTransaction(Event event, Context context) {
        return true;
    }

    @Override
    public void handle(Event event, Context context) {
        switch (event) {
            case BEFORE_CLEAN: {
                this.flywayCallback.beforeClean(context.getConnection());
                return;
            }
            case AFTER_CLEAN: {
                this.flywayCallback.afterClean(context.getConnection());
                return;
            }
            case BEFORE_MIGRATE: {
                this.flywayCallback.beforeMigrate(context.getConnection());
                return;
            }
            case BEFORE_EACH_MIGRATE: {
                this.flywayCallback.beforeEachMigrate(context.getConnection(), context.getMigrationInfo());
                return;
            }
            case AFTER_EACH_MIGRATE: {
                this.flywayCallback.afterEachMigrate(context.getConnection(), context.getMigrationInfo());
                return;
            }
            case AFTER_MIGRATE: {
                this.flywayCallback.afterMigrate(context.getConnection());
                return;
            }
            case BEFORE_VALIDATE: {
                this.flywayCallback.beforeValidate(context.getConnection());
                return;
            }
            case AFTER_VALIDATE: {
                this.flywayCallback.afterValidate(context.getConnection());
                return;
            }
            case BEFORE_INFO: {
                this.flywayCallback.beforeInfo(context.getConnection());
                return;
            }
            case AFTER_INFO: {
                this.flywayCallback.afterInfo(context.getConnection());
                return;
            }
            case BEFORE_BASELINE: {
                this.flywayCallback.beforeBaseline(context.getConnection());
                return;
            }
            case AFTER_BASELINE: {
                this.flywayCallback.afterBaseline(context.getConnection());
                return;
            }
            case BEFORE_REPAIR: {
                this.flywayCallback.beforeRepair(context.getConnection());
                return;
            }
            case AFTER_REPAIR: {
                this.flywayCallback.afterRepair(context.getConnection());
                return;
            }
        }
    }
}

