/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.filesystem;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.scanner.LoadableResource;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemResource;

public class FileSystemScanner {
    private static final Log LOG = LogFactory.getLog(FileSystemScanner.class);

    public LoadableResource[] scanForResources(Location location, String prefix, String ... suffixes) {
        String path = location.getPath();
        LOG.debug("Scanning for filesystem resources at '" + path + "' (Prefix: '" + prefix + "', Suffixes: '" + StringUtils.arrayToCommaDelimitedString(suffixes) + "')");
        File dir = new File(path);
        if (!dir.isDirectory() || !dir.canRead()) {
            LOG.warn("Unable to resolve location filesystem:" + path);
            return new LoadableResource[0];
        }
        TreeSet<FileSystemResource> resources = new TreeSet<FileSystemResource>();
        Set<String> resourceNames = this.findResourceNames(path, prefix, suffixes);
        for (String resourceName : resourceNames) {
            resources.add(new FileSystemResource(resourceName));
            LOG.debug("Found filesystem resource: " + resourceName);
        }
        return resources.toArray(new LoadableResource[resources.size()]);
    }

    private Set<String> findResourceNames(String path, String prefix, String[] suffixes) {
        Set<String> resourceNames = this.findResourceNamesFromFileSystem(path, new File(path));
        return this.filterResourceNames(resourceNames, prefix, suffixes);
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        File[] files;
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                continue;
            }
            resourceNames.add(file.getPath());
        }
        return resourceNames;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String[] suffixes) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf(File.separator) + 1);
            if (this.fileNameMatches(fileName, prefix, suffixes)) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug("Filtering out resource: " + resourceName + " (filename: " + fileName + ")");
        }
        return filteredResourceNames;
    }

    private boolean fileNameMatches(String fileName, String prefix, String[] suffixes) {
        for (String suffix : suffixes) {
            if (!fileName.startsWith(prefix) || !fileName.endsWith(suffix) || fileName.length() <= (prefix + suffix).length()) continue;
            return true;
        }
        return false;
    }
}

