/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.internal.database.AbstractSqlStatement;
import org.flywaydb.core.internal.util.jdbc.ContextImpl;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.jdbc.Result;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLCopyStatement
extends AbstractSqlStatement {
    PostgreSQLCopyStatement(int lineNumber, String sql) {
        super(lineNumber, sql);
    }

    @Override
    public List<Result> execute(ContextImpl context, JdbcTemplate jdbcTemplate) throws SQLException {
        int split = this.sql.indexOf(";");
        String statement = this.sql.substring(0, split);
        String data = this.sql.substring(split + 1).trim();
        ArrayList<Result> results = new ArrayList<Result>();
        CopyManager copyManager = new CopyManager(jdbcTemplate.getConnection().unwrap(BaseConnection.class));
        try {
            long updateCount = copyManager.copyIn(statement, (Reader)new StringReader(data));
            results.add(new Result(updateCount));
        }
        catch (IOException e) {
            throw new SQLException("Unable to execute COPY operation", e);
        }
        return results;
    }
}

