/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.h2;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.h2.H2Database;
import org.flywaydb.core.internal.database.h2.H2Schema;

public class H2Connection
extends Connection<H2Database> {
    H2Connection(FlywayConfiguration configuration, H2Database database, java.sql.Connection connection, int nullType) {
        super(configuration, database, connection, nullType);
    }

    @Override
    public void doChangeCurrentSchemaTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((H2Database)this.database).quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new H2Schema(this.jdbcTemplate, (H2Database)this.database, name);
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("CALL SCHEMA()", new String[0]);
    }
}

