/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedHostNameAddressTranslator
implements AddressTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(FixedHostNameAddressTranslator.class);
    public static final String ADDRESS_TRANSLATOR_ADVERTISED_HOSTNAME = "advanced.address-translator.advertised-hostname";
    public static DriverOption ADDRESS_TRANSLATOR_ADVERTISED_HOSTNAME_OPTION = new DriverOption(){

        @Override
        @NonNull
        public String getPath() {
            return FixedHostNameAddressTranslator.ADDRESS_TRANSLATOR_ADVERTISED_HOSTNAME;
        }
    };
    private final String advertisedHostname;
    private final String logPrefix;

    public FixedHostNameAddressTranslator(@NonNull DriverContext context) {
        this.logPrefix = context.getSessionName();
        this.advertisedHostname = context.getConfig().getDefaultProfile().getString(ADDRESS_TRANSLATOR_ADVERTISED_HOSTNAME_OPTION);
    }

    @Override
    @NonNull
    public InetSocketAddress translate(@NonNull InetSocketAddress address) {
        int port = address.getPort();
        LOG.debug("[{}] Resolved {}:{} to {}:{}", new Object[]{this.logPrefix, address, port, this.advertisedHostname, port});
        return new InetSocketAddress(this.advertisedHostname, port);
    }

    @Override
    public void close() {
    }
}

