/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.scanners;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.experimental.migration.ExperimentalMigrationScanner;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.scanner.filesystem.DirectoryValidationResult;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;

public abstract class BaseSqlMigrationScanner
implements ExperimentalMigrationScanner {
    private static final Log LOG = LogFactory.getLog(BaseSqlMigrationScanner.class);

    protected Collection<Pair<LoadableResource, SqlScriptMetadata>> scanFromFileSystem(File dir, Location location, Configuration configuration, ParsingContext parsingContext) {
        String fileOrClasspath;
        DirectoryValidationResult validationResult = this.getDirectoryValidationResult(dir);
        String string = fileOrClasspath = location.isFileSystem() ? "filesystem" : "classpath";
        if (validationResult != DirectoryValidationResult.VALID) {
            if (configuration.isFailOnMissingLocations()) {
                throw new FlywayException("Failed to find " + fileOrClasspath + " location: " + location.getRootPath() + " (" + validationResult + ")");
            }
            String message = "Skipping " + fileOrClasspath + " location: " + location.getRootPath() + " (" + validationResult + ")";
            if (location.isFileSystem()) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
            return Collections.emptyList();
        }
        Set<String> resourceNames = this.findResourceNamesFromFileSystem(location.getRootPath(), dir, configuration.isFailOnMissingLocations(), new ResourceNameParser(configuration), location.isFileSystem());
        return resourceNames.stream().filter(path -> this.matchesPath((String)path, location)).map(resourceName -> this.processResource(location, configuration, (String)resourceName, parsingContext)).toList();
    }

    abstract boolean matchesPath(String var1, Location var2);

    private Pair<LoadableResource, SqlScriptMetadata> processResource(Location location, Configuration configuration, String resourceName, ParsingContext parsingContext) {
        boolean detectEncodingForThisResource = configuration.isDetectEncoding();
        Charset encoding = configuration.getEncoding();
        Object encodingBlurb = "";
        SqlScriptMetadata metadata = null;
        if (new File(resourceName + ".conf").exists() && (metadata = this.getSqlScriptMetadata(location, configuration, resourceName, parsingContext)).encoding() != null) {
            encoding = Charset.forName(metadata.encoding());
            detectEncodingForThisResource = false;
            encodingBlurb = " (with overriding encoding " + encoding + ")";
        }
        String fileOrClasspath = location.isFileSystem() ? "filesystem" : "classpath";
        LOG.debug("Found " + fileOrClasspath + " resource: " + resourceName + (String)encodingBlurb);
        FileSystemResource fileSystemResource = new FileSystemResource(location, resourceName, encoding, detectEncodingForThisResource, configuration.isStream());
        return Pair.of((Object)fileSystemResource, (Object)metadata);
    }

    private SqlScriptMetadata getSqlScriptMetadata(Location location, Configuration configuration, String resourceName, ParsingContext parsingContext) {
        FileSystemResource metadataResource = new FileSystemResource(location, resourceName + ".conf", configuration.getEncoding(), false);
        return SqlScriptMetadata.fromResource((LoadableResource)metadataResource, (Parser)new MetadataParser(configuration, parsingContext), (Configuration)configuration);
    }

    private DirectoryValidationResult getDirectoryValidationResult(File directory) {
        if (!directory.exists()) {
            return DirectoryValidationResult.NOT_FOUND;
        }
        if (!directory.canRead()) {
            return DirectoryValidationResult.NOT_READABLE;
        }
        if (!directory.isDirectory()) {
            return DirectoryValidationResult.NOT_A_DIRECTORY;
        }
        return DirectoryValidationResult.VALID;
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder, boolean throwOnMissingLocations, ResourceNameParser resourceNameParser, boolean isFileSystem) {
        String path = folder.getPath();
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        String fileOrClasspath = isFileSystem ? "filesystem" : "classpath";
        File[] files = folder.listFiles();
        if (files == null) {
            if (throwOnMissingLocations) {
                throw new FlywayException("Failed to find " + fileOrClasspath + " location: " + path + " (" + DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER + ")");
            }
            String message = "Skipping " + fileOrClasspath + " location: " + path + " (" + DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER + ")";
            if (isFileSystem) {
                LOG.error(message);
            } else {
                LOG.debug(message);
            }
            return Collections.emptySet();
        }
        Arrays.stream(files).filter(File::canRead).map(file -> Pair.of((Object)file, (Object)resourceNameParser.parse(file.getName()))).filter(pair -> ((ResourceName)pair.getRight()).isValid() && !"".equals(((ResourceName)pair.getRight()).getSuffix())).forEach(pair -> resourceNames.add(((File)pair.getLeft()).getPath()));
        Arrays.stream(files).filter(File::canRead).filter(File::isDirectory).forEach(file -> {
            if (file.isHidden()) {
                LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
            } else {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, (File)file, throwOnMissingLocations, resourceNameParser, isFileSystem));
            }
        });
        return resourceNames;
    }

    private static class MetadataParser
    extends Parser {
        private MetadataParser(Configuration configuration, ParsingContext parsingContext) {
            super(configuration, parsingContext, 0);
        }
    }
}

