/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.ing.data.cassandra.jdbc.utils.ContactPoint;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcUrlUtil {
    public static final int DEFAULT_PORT = 9042;
    public static final String PROTOCOL = "jdbc:cassandra:";
    public static final String PROTOCOL_DBAAS = "jdbc:cassandra:dbaas:";
    @Deprecated
    public static final String KEY_VERSION = "version";
    @Deprecated
    public static final String TAG_ACTIVE_CQL_VERSION = "activeCqlVersion";
    @Deprecated
    public static final String TAG_CQL_VERSION = "cqlVersion";
    public static final String KEY_CONSISTENCY = "consistency";
    public static final String TAG_CONSISTENCY_LEVEL = "consistencyLevel";
    public static final String KEY_CONNECTION_RETRIES = "retries";
    public static final String TAG_CONNECTION_RETRIES = "retries";
    public static final String KEY_LOAD_BALANCING_POLICY = "loadbalancing";
    public static final String TAG_LOAD_BALANCING_POLICY = "loadBalancing";
    public static final String KEY_LOCAL_DATACENTER = "localdatacenter";
    public static final String TAG_LOCAL_DATACENTER = "localDatacenter";
    public static final String KEY_RETRY_POLICY = "retry";
    public static final String TAG_RETRY_POLICY = "retry";
    public static final String KEY_RECONNECT_POLICY = "reconnection";
    public static final String TAG_RECONNECT_POLICY = "reconnection";
    public static final String KEY_DEBUG = "debug";
    public static final String TAG_DEBUG = "debug";
    public static final String KEY_ENABLE_SSL = "enablessl";
    public static final String TAG_ENABLE_SSL = "enableSsl";
    public static final String KEY_SSL_ENGINE_FACTORY = "sslenginefactory";
    public static final String TAG_SSL_ENGINE_FACTORY = "sslEngineFactory";
    public static final String KEY_SSL_HOSTNAME_VERIFICATION = "hostnameverification";
    public static final String TAG_SSL_HOSTNAME_VERIFICATION = "hostnameVerification";
    public static final String KEY_CLOUD_SECURE_CONNECT_BUNDLE = "secureconnectbundle";
    public static final String TAG_CLOUD_SECURE_CONNECT_BUNDLE = "secureConnectBundle";
    public static final String KEY_USER = "user";
    public static final String TAG_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String TAG_PASSWORD = "password";
    public static final String KEY_REQUEST_TIMEOUT = "requesttimeout";
    public static final String TAG_REQUEST_TIMEOUT = "requestTimeout";
    public static final String KEY_CONNECT_TIMEOUT = "connecttimeout";
    public static final String TAG_CONNECT_TIMEOUT = "connectTimeout";
    public static final String KEY_TCP_NO_DELAY = "tcpnodelay";
    public static final String TAG_TCP_NO_DELAY = "tcpNoDelay";
    public static final String KEY_KEEP_ALIVE = "keepalive";
    public static final String TAG_KEEP_ALIVE = "keepAlive";
    public static final String KEY_CONFIG_FILE = "configfile";
    public static final String TAG_CONFIG_FILE = "configFile";
    public static final String KEY_COMPLIANCE_MODE = "compliancemode";
    public static final String TAG_COMPLIANCE_MODE = "complianceMode";
    public static final String TAG_DATABASE_NAME = "databaseName";
    public static final String TAG_CONTACT_POINTS = "contactPoints";
    static final Logger LOG = LoggerFactory.getLogger(JdbcUrlUtil.class);
    private static final String HOST_SEPARATOR = "--";

    private JdbcUrlUtil() {
    }

    public static Properties parseURL(String url) throws SQLException {
        Properties props = new Properties();
        if (url != null) {
            String keyspace;
            URI uri;
            boolean isDbaasConnection = false;
            int uriStartIndex = PROTOCOL.length();
            if (url.startsWith(PROTOCOL_DBAAS)) {
                uriStartIndex = PROTOCOL_DBAAS.length();
                isDbaasConnection = true;
            }
            String rawUri = url.substring(uriStartIndex);
            try {
                uri = new URI(rawUri);
            }
            catch (URISyntaxException e) {
                throw new SQLSyntaxErrorException(e);
            }
            if (!isDbaasConnection) {
                try {
                    if (StringUtils.isBlank((CharSequence)uri.getAuthority())) {
                        throw new SQLNonTransientConnectionException("Connection url must specify a host, e.g. jdbc:cassandra://localhost:9042/keyspace");
                    }
                    List<ContactPoint> contactPoints = JdbcUrlUtil.parseContactPoints(uri.getAuthority());
                    if (contactPoints.isEmpty()) {
                        throw new SQLNonTransientConnectionException("Connection url must specify a host, e.g. jdbc:cassandra://localhost:9042/keyspace");
                    }
                    props.put(TAG_CONTACT_POINTS, contactPoints);
                }
                catch (RuntimeException e) {
                    throw new SQLNonTransientConnectionException(e.getMessage());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(keyspace = uri.getPath()))) {
                if (keyspace.startsWith("/")) {
                    keyspace = keyspace.substring(1);
                }
                if (!keyspace.matches("[a-zA-Z]\\w+")) {
                    throw new SQLNonTransientConnectionException(String.format("Keyspace names must be composed of alphanumerics and underscores (parsed: '%s').", keyspace));
                }
                props.setProperty(TAG_DATABASE_NAME, keyspace);
            }
            if (uri.getUserInfo() != null) {
                throw new SQLNonTransientConnectionException("Connection URL may only include host, port, keyspace, and allowed options, e.g. jdbc:cassandra://localhost:9042/keyspace?consistency=ONE");
            }
            String query = uri.getQuery();
            if (query != null && !query.isEmpty()) {
                Map<String, String> params = JdbcUrlUtil.parseQueryPart(query);
                if (params.containsKey(KEY_VERSION)) {
                    props.setProperty(TAG_CQL_VERSION, params.get(KEY_VERSION));
                }
                if (params.containsKey("debug")) {
                    props.setProperty("debug", params.get("debug"));
                }
                if (params.containsKey(KEY_CONSISTENCY)) {
                    props.setProperty(TAG_CONSISTENCY_LEVEL, params.get(KEY_CONSISTENCY));
                }
                if (params.containsKey("retries")) {
                    props.setProperty("retries", params.get("retries"));
                }
                if (params.containsKey(KEY_LOAD_BALANCING_POLICY)) {
                    props.setProperty(TAG_LOAD_BALANCING_POLICY, params.get(KEY_LOAD_BALANCING_POLICY));
                }
                if (params.containsKey(KEY_LOCAL_DATACENTER)) {
                    props.setProperty(TAG_LOCAL_DATACENTER, params.get(KEY_LOCAL_DATACENTER));
                }
                if (params.containsKey("retry")) {
                    props.setProperty("retry", params.get("retry"));
                }
                if (params.containsKey("reconnection")) {
                    props.setProperty("reconnection", params.get("reconnection"));
                }
                if (params.containsKey(KEY_ENABLE_SSL)) {
                    props.setProperty(TAG_ENABLE_SSL, params.get(KEY_ENABLE_SSL));
                }
                if (params.containsKey(KEY_SSL_ENGINE_FACTORY)) {
                    props.setProperty(TAG_SSL_ENGINE_FACTORY, params.get(KEY_SSL_ENGINE_FACTORY));
                }
                if (params.containsKey(KEY_SSL_HOSTNAME_VERIFICATION)) {
                    props.setProperty(TAG_SSL_HOSTNAME_VERIFICATION, params.get(KEY_SSL_HOSTNAME_VERIFICATION));
                }
                if (params.containsKey(KEY_CLOUD_SECURE_CONNECT_BUNDLE)) {
                    props.setProperty(TAG_CLOUD_SECURE_CONNECT_BUNDLE, params.get(KEY_CLOUD_SECURE_CONNECT_BUNDLE));
                } else if (isDbaasConnection) {
                    throw new SQLNonTransientConnectionException("A 'secureconnectbundle' parameter is required.");
                }
                if (params.containsKey("user")) {
                    props.setProperty("user", params.get("user"));
                }
                if (params.containsKey("password")) {
                    props.setProperty("password", params.get("password"));
                }
                if (params.containsKey(KEY_REQUEST_TIMEOUT)) {
                    props.setProperty(TAG_REQUEST_TIMEOUT, params.get(KEY_REQUEST_TIMEOUT));
                }
                if (params.containsKey(KEY_CONNECT_TIMEOUT)) {
                    props.setProperty(TAG_CONNECT_TIMEOUT, params.get(KEY_CONNECT_TIMEOUT));
                }
                if (params.containsKey(KEY_TCP_NO_DELAY)) {
                    props.setProperty(TAG_TCP_NO_DELAY, params.get(KEY_TCP_NO_DELAY));
                }
                if (params.containsKey(KEY_KEEP_ALIVE)) {
                    props.setProperty(TAG_KEEP_ALIVE, params.get(KEY_KEEP_ALIVE));
                }
                if (params.containsKey(KEY_CONFIG_FILE)) {
                    props.setProperty(TAG_CONFIG_FILE, params.get(KEY_CONFIG_FILE));
                }
                if (params.containsKey(KEY_COMPLIANCE_MODE)) {
                    props.setProperty(TAG_COMPLIANCE_MODE, params.get(KEY_COMPLIANCE_MODE));
                }
            } else if (isDbaasConnection) {
                throw new SQLNonTransientConnectionException("A 'secureconnectbundle' parameter is required.");
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("URL: '{}' parsed to: {}", (Object)url, (Object)props);
        }
        return props;
    }

    private static List<ContactPoint> parseContactPoints(String toParse) {
        String portValue;
        AtomicInteger defaultPort = new AtomicInteger(9042);
        Pattern endWithPort = Pattern.compile(":(\\d{1,5})$");
        Matcher endWithPortMatcher = endWithPort.matcher(toParse);
        if (endWithPortMatcher.find() && (portValue = endWithPortMatcher.group(1)) != null) {
            defaultPort.set(Integer.parseInt(portValue));
        }
        return Arrays.stream(toParse.split(HOST_SEPARATOR)).map(part -> {
            try {
                int port = defaultPort.get();
                String[] splitPart = part.split(":");
                if (splitPart.length > 1) {
                    port = Integer.parseInt(splitPart[1]);
                }
                return ContactPoint.of(splitPart[0], port);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Invalid contact point: %s", part));
            }
        }).collect(Collectors.toList());
    }

    public static String createSubName(Properties props) throws SQLException {
        URI uri;
        String keyspace = props.getProperty(TAG_DATABASE_NAME);
        if (keyspace != null) {
            keyspace = StringUtils.prependIfMissing((String)keyspace, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        String hostsAndPorts = null;
        List contactPoints = (List)props.get(TAG_CONTACT_POINTS);
        if (contactPoints != null && !contactPoints.isEmpty()) {
            hostsAndPorts = contactPoints.stream().map(ContactPoint::toString).collect(Collectors.joining(HOST_SEPARATOR));
        }
        if (hostsAndPorts == null) {
            throw new SQLNonTransientConnectionException("A host name is required to build a connection.");
        }
        try {
            uri = new URI(null, hostsAndPorts, keyspace, JdbcUrlUtil.makeQueryString(props), null);
        }
        catch (Exception e) {
            throw new SQLNonTransientConnectionException(e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Sub-name: '{}' created from: {}", (Object)uri, (Object)props);
        }
        return uri.toString();
    }

    static String makeQueryString(Properties props) {
        StringBuilder sb = new StringBuilder();
        String consistency = props.getProperty(TAG_CONSISTENCY_LEVEL);
        if (StringUtils.isNotBlank((CharSequence)consistency)) {
            sb.append(KEY_CONSISTENCY).append("=").append(consistency);
        }
        if (sb.length() > 0) {
            return sb.toString().trim();
        }
        return null;
    }

    static Map<String, String> parseQueryPart(String query) throws SQLException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String param : query.split("&")) {
            try {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], StandardCharsets.UTF_8.displayName()).toLowerCase();
                String value = "";
                if (pair.length > 1) {
                    value = URLDecoder.decode(pair[1], StandardCharsets.UTF_8.displayName());
                }
                params.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLSyntaxErrorException(e);
            }
        }
        return params;
    }

    public static Map<DriverOption, Object> parseReconnectionPolicy(String reconnectionPolicyString) {
        String policyRegex = "([a-zA-Z.]*Policy)(\\()(.*)(\\))";
        Pattern policyPattern = Pattern.compile("([a-zA-Z.]*Policy)(\\()(.*)(\\))");
        Matcher policyMatcher = policyPattern.matcher(reconnectionPolicyString);
        if (policyMatcher.matches() && policyMatcher.groupCount() > 0) {
            String primaryReconnectionPolicy = policyMatcher.group(1);
            String reconnectionPolicyParams = policyMatcher.group(3);
            return JdbcUrlUtil.getReconnectionPolicy(primaryReconnectionPolicy, reconnectionPolicyParams);
        }
        return null;
    }

    private static Map<DriverOption, Object> getReconnectionPolicy(String primaryReconnectionPolicy, String parameters) {
        HashMap<DriverOption, Object> policyParametersMap = new HashMap<DriverOption, Object>();
        String primaryReconnectionPolicyClass = primaryReconnectionPolicy;
        if (!primaryReconnectionPolicy.contains(".")) {
            primaryReconnectionPolicyClass = "com.datastax.oss.driver.internal.core.connection." + primaryReconnectionPolicy;
        }
        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, primaryReconnectionPolicyClass);
        if (!parameters.isEmpty()) {
            String paramsRegex = "([^,]+\\(.+?\\))|([^,]+)";
            Pattern paramsPattern = Pattern.compile("([^,]+\\(.+?\\))|([^,]+)");
            Matcher paramsMatcher = paramsPattern.matcher(parameters);
            int argPos = 0;
            while (paramsMatcher.find()) {
                if (paramsMatcher.groupCount() <= 0 || !paramsMatcher.group().trim().startsWith("(")) continue;
                String param = paramsMatcher.group();
                if (param.toLowerCase().contains("(long)")) {
                    long delay = Long.parseLong(param.toLowerCase().replace("(long)", "").trim());
                    if (argPos == 0) {
                        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(delay));
                    } else if (argPos == 1 && "com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy".equals(primaryReconnectionPolicyClass)) {
                        policyParametersMap.put((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofSeconds(delay));
                    }
                }
                ++argPos;
            }
        }
        return policyParametersMap;
    }
}

