/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CassandraBlobSerializer
extends JsonSerializer<ByteBuffer> {
    private static final char[] HEX_CHARS_ARRAY = "0123456789ABCDEF".toCharArray();

    public void serialize(ByteBuffer value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value != null) {
            gen.writeString(CassandraBlobSerializer.byteArrayToHexString(value.array()));
        } else {
            gen.writeNull();
        }
    }

    private static String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_CHARS_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_CHARS_ARRAY[v & 0xF];
        }
        return String.format("0x%s", new String(hexChars));
    }
}

