/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.community.database.db2z.DB2ZCallProcedureParsedStatement;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Recorder;
import org.flywaydb.core.internal.parser.StatementType;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;

public class DB2ZParser
extends Parser {
    private static final Log LOG = LogFactory.getLog(DB2ZParser.class);
    private static final String COMMENT_DIRECTIVE = "--#";
    private static final String SET_TERMINATOR_DIRECTIVE = "--#SET TERMINATOR ";
    private static final List<String> CONTROL_FLOW_KEYWORDS = Arrays.asList("LOOP", "CASE", "DO", "REPEAT", "IF");
    private static final Pattern CREATE_IF_NOT_EXISTS = Pattern.compile(".*CREATE\\s([^\\s]+\\s){0,2}IF\\sNOT\\sEXISTS");
    private static final Pattern DROP_IF_EXISTS = Pattern.compile(".*DROP\\s([^\\s]+\\s){0,2}IF\\sEXISTS");
    private static final Pattern STORED_PROCEDURE_CALL = Pattern.compile("^CALL");
    private static final StatementType DB2Z_CALL_STATEMENT = new StatementType();
    private static final Pattern DB2Z_CALL_WITH_PARMS_REGEX = Pattern.compile("CALL\\s+(?<procname>([^\\s]+\\.)?[^\\s]+)(\\(\\s*(?<args>\\S.*)\\s*\\))", 2);
    private static final Pattern PARMS_SPLIT_REGEX = Pattern.compile(",(?=(?:[^']*'[^']*')*[^']*$)");
    private static final Pattern STRING_PARM_REGEX = Pattern.compile("'.*'");
    private static final Pattern INTEGER_PARM_REGEX = Pattern.compile("-?\\d+");

    public DB2ZParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, COMMENT_DIRECTIVE.length());
    }

    protected StatementType detectStatementType(String simplifiedStatement, ParserContext context, PeekingReader reader) {
        LOG.debug("detectStatementType: simplifiedStatement=" + simplifiedStatement);
        if (STORED_PROCEDURE_CALL.matcher(simplifiedStatement).matches()) {
            LOG.debug("detectStatementType: DB2Z CALL statement found");
            return DB2Z_CALL_STATEMENT;
        }
        return super.detectStatementType(simplifiedStatement, context, reader);
    }

    protected ParsedSqlStatement createStatement(PeekingReader reader, Recorder recorder, int statementPos, int statementLine, int statementCol, int nonCommentPartPos, int nonCommentPartLine, int nonCommentPartCol, StatementType statementType, boolean canExecuteInTransaction, Delimiter delimiter, String sql, List<Token> tokens, boolean batchable) throws IOException {
        Matcher callMatcher;
        LOG.debug(sql);
        if (statementType == DB2Z_CALL_STATEMENT && (callMatcher = DB2Z_CALL_WITH_PARMS_REGEX.matcher(sql)).find()) {
            String procName = callMatcher.group("procname");
            String parmsString = callMatcher.group("args");
            String[] parmStrings = PARMS_SPLIT_REGEX.split(parmsString);
            Object[] parms = new Object[parmStrings.length];
            for (int i = 0; i < parmStrings.length; ++i) {
                String prmTrimmed = parmStrings[i].trim();
                LOG.debug("createStatement: DB2Z CALL with parms: " + procName + " " + prmTrimmed);
                parms[i] = STRING_PARM_REGEX.matcher(prmTrimmed).matches() ? prmTrimmed.substring(1, prmTrimmed.length() - 1).replace("''", "'") : (INTEGER_PARM_REGEX.matcher(prmTrimmed).matches() ? Integer.valueOf(prmTrimmed) : (prmTrimmed.toUpperCase().equals("NULL") ? null : prmTrimmed));
            }
            return new DB2ZCallProcedureParsedStatement(statementPos, statementLine, statementCol, sql, delimiter, canExecuteInTransaction, batchable, procName, parms);
        }
        LOG.debug("createStatement: DB2Z CALL no parms " + statementType + " " + sql);
        return super.createStatement(reader, recorder, statementPos, statementLine, statementCol, nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, statementType, canExecuteInTransaction, delimiter, sql, tokens, batchable);
    }

    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) throws IOException {
        String previousPreviousToken;
        boolean previousTokenIsKeyword = !tokens.isEmpty() && tokens.get(tokens.size() - 1).getType() == TokenType.KEYWORD;
        int lastKeywordIndex = this.getLastKeywordIndex(tokens);
        String previousKeyword = lastKeywordIndex >= 0 ? tokens.get(lastKeywordIndex).getText() : null;
        lastKeywordIndex = this.getLastKeywordIndex(tokens, lastKeywordIndex);
        String string = previousPreviousToken = lastKeywordIndex >= 0 ? tokens.get(lastKeywordIndex).getText() : null;
        if ("BEGIN".equals(keyword.getText()) && (!"ROW".equals(previousKeyword) || previousPreviousToken == null || "EACH".equals(previousPreviousToken)) || CONTROL_FLOW_KEYWORDS.contains(keyword.getText())) {
            if (!previousTokenIsKeyword || !"END".equals(previousKeyword)) {
                context.increaseBlockDepth(keyword.getText());
            }
        } else if ("END".equals(keyword.getText()) && !"ROW".equals(previousKeyword) || this.doTokensMatchPattern(tokens, keyword, CREATE_IF_NOT_EXISTS) || this.doTokensMatchPattern(tokens, keyword, DROP_IF_EXISTS)) {
            context.decreaseBlockDepth();
        }
    }

    protected void resetDelimiter(ParserContext context) {
    }

    protected boolean isCommentDirective(String peek) {
        return peek.startsWith(COMMENT_DIRECTIVE);
    }

    protected Token handleCommentDirective(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        if (SET_TERMINATOR_DIRECTIVE.equals(reader.peek(SET_TERMINATOR_DIRECTIVE.length()))) {
            reader.swallow(SET_TERMINATOR_DIRECTIVE.length());
            String delimiter = reader.readUntilExcluding('\n', '\r');
            return new Token(TokenType.NEW_DELIMITER, pos, line, col, delimiter.trim(), delimiter, context.getParensDepth());
        }
        reader.swallowUntilExcluding('\n', '\r');
        return new Token(TokenType.COMMENT, pos, line, col, null, null, context.getParensDepth());
    }
}

