/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.repair;

import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.verb.VerbUtils;

public class RepairVerbExtension
implements VerbExtension {
    private static final Log LOG = LogFactory.getLog(RepairVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "repair".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        ExperimentalDatabase experimentalDatabase;
        try {
            experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
        }
        catch (Exception e) {
            throw new FlywayException((Throwable)e);
        }
        ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
        RepairResult repairResult = new RepairResult(VersionPrinter.getVersion(), experimentalDatabase.getDatabaseMetaData().databaseName());
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        RepairVerbExtension.removeFailedMigrations(configuration, repairResult, experimentalDatabase);
        SchemaHistoryModel postRemovalSchemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
        MigrationInfo[] migrations = VerbUtils.getMigrationInfos((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase, (SchemaHistoryModel)postRemovalSchemaHistoryModel);
        RepairVerbExtension.markRemovedMigrationsAsDeleted(configuration, migrations, repairResult, postRemovalSchemaHistoryModel, experimentalDatabase);
        this.alignAppliedMigrationsWithResolvedMigrations(configuration, migrations, repairResult, experimentalDatabase);
        stopWatch.stop();
        if (repairResult.repairActions.isEmpty()) {
            LOG.info("Repair of schema history table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}) + " not needed, no migrations need repairing.");
        } else {
            LOG.info("Successfully repaired schema history table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}) + " (execution time " + TimeFormat.format((long)stopWatch.getTotalTimeMillis()) + ").");
            if (repairResult.repairActions.contains("Marked missing migrations as deleted")) {
                LOG.info("Please ensure the previous contents of the deleted migrations are removed from the database, or moved into an existing migration.");
            }
        }
        return repairResult;
    }

    private void alignAppliedMigrationsWithResolvedMigrations(Configuration configuration, MigrationInfo[] migrations, RepairResult repairResult, ExperimentalDatabase experimentalDatabase) {
        List<MigrationInfo> appliedVersionedInfos = Arrays.stream(migrations).filter(x -> x.getVersion() != null).filter(x -> x.getState().isResolved()).filter(x -> x.getState().isApplied()).filter(x -> !x.getType().isSynthetic()).filter(x -> x.getState() != MigrationState.UNDONE).filter(this::updateNeeded).toList();
        if (!appliedVersionedInfos.isEmpty()) {
            repairResult.migrationsAligned = appliedVersionedInfos.stream().map(x -> new RepairOutput(x.isRepeatable() ? "" : x.getVersion().getVersion(), x.getDescription(), x.getPhysicalLocation())).toList();
            SchemaHistoryModel postDeletedSchemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
            for (MigrationInfo updatedEntry : appliedVersionedInfos) {
                SchemaHistoryItem item = (SchemaHistoryItem)postDeletedSchemaHistoryModel.getSchemaHistoryItem(updatedEntry.getInstalledRank().intValue()).orElseThrow(() -> new FlywayException("Fatal error when repairing, please contact support!"));
                LOG.info("Repairing Schema History table for version " + item.getVersion() + " (Description: " + updatedEntry.getResolvedDescription() + ", Type: " + updatedEntry.getResolvedType() + ", Checksum: " + updatedEntry.getResolvedChecksum() + ")  ...");
                experimentalDatabase.updateSchemaHistoryItem(item.toBuilder().type(updatedEntry.getResolvedType().name()).checksum(updatedEntry.getResolvedChecksum()).description(updatedEntry.getResolvedDescription()).build(), configuration.getTable());
            }
            repairResult.repairActions.add("Aligned applied migration checksums");
        } else {
            LOG.info("No migrations to realign in Schema History table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}));
        }
    }

    private static void markRemovedMigrationsAsDeleted(Configuration configuration, MigrationInfo[] migrations, RepairResult repairResult, SchemaHistoryModel postRemovalSchemaHistoryModel, ExperimentalDatabase experimentalDatabase) {
        List<MigrationInfo> migrationInfo = VerbUtils.removeIgnoredMigrations((Configuration)configuration, (MigrationInfo[])migrations).stream().filter(x -> !x.getState().isResolved()).toList();
        repairResult.migrationsDeleted = migrationInfo.stream().map(x -> new RepairOutput(x.isRepeatable() ? "" : x.getVersion().getVersion(), x.getDescription(), "")).toList();
        if (!repairResult.migrationsDeleted.isEmpty()) {
            int nextInstalledRank = postRemovalSchemaHistoryModel.calculateInstalledRank((MigrationType)CoreMigrationType.DELETE);
            List<SchemaHistoryItem> schemaHistoryItems = migrationInfo.stream().map(x -> postRemovalSchemaHistoryModel.getSchemaHistoryItem(x.getInstalledRank().intValue())).map(x -> (SchemaHistoryItem)x.orElseThrow(() -> new FlywayException("Fatal error when repairing, please contact support!"))).toList();
            for (SchemaHistoryItem schemaHistoryItem : schemaHistoryItems) {
                if (schemaHistoryItem.getVersion() == null) {
                    LOG.info("Repairing Schema History table for description \"" + schemaHistoryItem.getDescription() + "\" (Marking as DELETED)  ...");
                } else {
                    LOG.info("Repairing Schema History table for version \"" + schemaHistoryItem.getVersion() + "\" (Marking as DELETED)  ...");
                }
                experimentalDatabase.appendSchemaHistoryItem(schemaHistoryItem.toBuilder().type(CoreMigrationType.DELETE.name()).installedRank(nextInstalledRank++).build(), configuration.getTable());
            }
            repairResult.repairActions.add("Marked missing migrations as deleted");
        } else {
            LOG.info("No missing or future migrations to be marked as deleted in Schema History table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}));
        }
    }

    private static void removeFailedMigrations(Configuration configuration, RepairResult repairResult, ExperimentalDatabase experimentalDatabase) {
        SchemaHistoryModel schemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
        repairResult.migrationsRemoved = schemaHistoryModel.getSchemaHistoryItems().stream().filter(x -> !x.isSuccess()).map(x -> new RepairOutput(x.getVersion() == null ? "" : x.getVersion(), x.getDescription(), "")).toList();
        if (!repairResult.migrationsRemoved.isEmpty()) {
            experimentalDatabase.removeFailedSchemaHistoryItems(configuration.getTable());
            repairResult.repairActions.add("Removed failed migrations");
            LOG.info("Removed " + repairResult.migrationsRemoved.size() + " failed migration from Schema History table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}));
        } else {
            LOG.info("Repair of failed migration in Schema History table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}) + " not necessary. No failed migration detected.");
        }
    }

    private boolean updateNeeded(MigrationInfo migrationInfo) {
        return !(migrationInfo.isChecksumMatching() & migrationInfo.isDescriptionMatching() & migrationInfo.isTypeMatching());
    }
}

