/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.ThreadFactoryUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import org.threeten.bp.Duration;

public class LatencyTest {
    public static void main(String[] args) throws Exception {
        ThreadFactory threadFactory = ThreadFactoryUtil.tryCreateVirtualThreadFactory("spanner-async-worker");
        if (threadFactory == null) {
            return;
        }
        ScheduledExecutorService service = Executors.newScheduledThreadPool(0, threadFactory);
        Spanner spanner = (Spanner)((SpannerOptions.Builder)SpannerOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)Files.newInputStream(Paths.get("/Users/loite/Downloads/appdev-soda-spanner-staging.json", new String[0]), new OpenOption[0])))).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).build()).setUseVirtualThreads(true).setAsyncExecutorProvider(SpannerOptions.FixedCloseableExecutorProvider.create(service)).build().getService();
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of("appdev-soda-spanner-staging", "knut-test-ycsb", "latencytest"));
        for (int i = 0; i < 1000000; ++i) {
            try (AsyncResultSet resultSet = client.singleUse().executeQueryAsync(Statement.newBuilder("select col_varchar from latency_test where col_bigint=$1").bind("p1").to(ThreadLocalRandom.current().nextLong(100000L)).build(), new Options.QueryOption[0]);){
                while (resultSet.next()) {
                    for (int col = 0; col < resultSet.getColumnCount(); ++col) {
                        if (resultSet.getValue(col) != null) continue;
                        throw new IllegalStateException();
                    }
                }
                continue;
            }
        }
    }
}

