/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.clickhouse;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.community.database.clickhouse.ClickHouseConfigurationExtension;
import org.flywaydb.community.database.clickhouse.ClickHouseConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.util.StringUtils;

public class ClickHouseDatabase
extends Database<ClickHouseConnection> {
    private ClickHouseConnection systemConnection;

    public boolean useSingleConnection() {
        return true;
    }

    public ClickHouseDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public String getClusterName() {
        return ((ClickHouseConfigurationExtension)this.configuration.getPluginRegister().getPlugin(ClickHouseConfigurationExtension.class)).getClusterName();
    }

    public String getZookeeperPath() {
        return ((ClickHouseConfigurationExtension)this.configuration.getPluginRegister().getPlugin(ClickHouseConfigurationExtension.class)).getZookeeperPath();
    }

    public ClickHouseConnection getSystemConnection() {
        if (this.systemConnection == null) {
            Connection connection = this.jdbcConnectionFactory.openConnection();
            try {
                this.systemConnection = this.doGetConnection(connection);
                this.systemConnection.doChangeCurrentSchemaOrSearchPathTo("system");
            }
            catch (SQLException e) {
                throw new FlywaySqlException("Unable to switch connection to read-only", e);
            }
        }
        return this.systemConnection;
    }

    protected ClickHouseConnection doGetConnection(Connection connection) {
        return new ClickHouseConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public void close() {
        if (this.systemConnection != null) {
            this.systemConnection.close();
        }
        super.close();
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String clusterName = this.getClusterName();
        boolean isClustered = StringUtils.hasText((String)clusterName);
        String script = "CREATE TABLE IF NOT EXISTS " + table + (String)(isClustered ? " ON CLUSTER " + clusterName : "") + "(    installed_rank Int32,    version Nullable(String),    description String,    type String,    script String,    checksum Nullable(Int32),    installed_by String,    installed_on DateTime DEFAULT now(),    execution_time Int32,    success Bool)";
        Object engine = isClustered ? "ReplicatedMergeTree('" + this.getZookeeperPath() + "', '{replica}')" : "MergeTree";
        script = script + " ENGINE = " + (String)engine + " PRIMARY KEY (script);";
        return script + (String)(baseline ? this.getBaselineStatement(table) + ";" : "");
    }
}

