/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.database.spanner.SpannerDatabase;
import org.flywaydb.database.spanner.SpannerTable;

public class SpannerSchema
extends Schema<SpannerDatabase, SpannerTable> {
    private static final Log LOG = LogFactory.getLog(SpannerSchema.class);

    public SpannerSchema(JdbcTemplate jdbcTemplate, SpannerDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() {
        return this.name.equals("");
    }

    protected boolean doEmpty() throws SQLException {
        try (Connection c = ((SpannerDatabase)this.database).getNewRawConnection();){
            boolean bl;
            block12: {
                Statement s = c.createStatement();
                s.close();
                ResultSet tables = c.getMetaData().getTables("", "", null, null);
                try {
                    boolean bl2 = bl = !tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    protected void doCreate() {
        LOG.info("Spanner does not support creating schemas. Schema not created: " + this.name);
    }

    protected void doDrop() throws SQLException {
        this.doClean();
    }

    protected void doClean() throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        for (String[] foreignKeyAndTable : this.doAllForeignKeys()) {
            String foreignKey = foreignKeyAndTable[0];
            String string = foreignKeyAndTable[1];
            statements.add("ALTER TABLE " + string + " DROP CONSTRAINT " + foreignKey);
        }
        this.executeStatements(statements);
        for (String string : this.doAllViews()) {
            statements.add("DROP VIEW " + string);
        }
        this.executeStatements(statements);
        for (SpannerTable spannerTable : this.doAllTables()) {
            for (String index : this.doAllIndexes(spannerTable)) {
                if (index.equalsIgnoreCase("PRIMARY_KEY")) continue;
                this.jdbcTemplate.execute("DROP INDEX " + index, new Object[0]);
            }
            statements.add("DROP TABLE " + spannerTable);
        }
        this.executeStatements(statements);
    }

    private void executeStatements(List<String> statements) throws SQLException {
        Configuration config = ((SpannerDatabase)this.database).getConfiguration();
        Results cleanStatementResults = this.jdbcTemplate.executeBatch(statements, config);
        if (cleanStatementResults.getException() != null) {
            throw cleanStatementResults.getException();
        }
        statements.clear();
    }

    private String[] doAllViews() throws SQLException {
        ArrayList<String> viewList = new ArrayList<String>();
        Connection connection = this.jdbcTemplate.getConnection();
        ResultSet viewResults = connection.getMetaData().getTables("", "", null, new String[]{"VIEW"});
        while (viewResults.next()) {
            viewList.add(viewResults.getString("TABLE_NAME"));
        }
        viewResults.close();
        return viewList.toArray(new String[0]);
    }

    protected SpannerTable[] doAllTables() throws SQLException {
        ArrayList<SpannerTable> tablesList = new ArrayList<SpannerTable>();
        Connection connection = this.jdbcTemplate.getConnection();
        ResultSet tablesRs = connection.getMetaData().getTables("", "", null, new String[]{"TABLE"});
        while (tablesRs.next()) {
            tablesList.add(new SpannerTable(this.jdbcTemplate, (SpannerDatabase)this.database, this, tablesRs.getString("TABLE_NAME")));
        }
        tablesRs.close();
        SpannerTable[] tables = new SpannerTable[tablesList.size()];
        return tablesList.toArray(tables);
    }

    private List<String[]> doAllForeignKeys() {
        ArrayList<String[]> foreignKeyAndTableList = new ArrayList<String[]>();
        Results foreignKeyRs = this.jdbcTemplate.executeStatement("SELECT CONSTRAINT_NAME, TABLE_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE CONSTRAINT_TYPE='FOREIGN KEY' AND TABLE_SCHEMA=''");
        for (Result result : foreignKeyRs.getResults()) {
            for (List row : result.data()) {
                String[] foreignKeyAndTable = new String[]{(String)row.get(0), (String)row.get(1)};
                foreignKeyAndTableList.add(foreignKeyAndTable);
            }
        }
        return foreignKeyAndTableList;
    }

    private List<String> doAllIndexes(Table table) throws SQLException {
        ArrayList<String> indexList = new ArrayList<String>();
        Connection c = this.jdbcTemplate.getConnection();
        ResultSet indexRs = c.getMetaData().getIndexInfo("", "", table.getName(), false, false);
        while (indexRs.next()) {
            indexList.add(indexRs.getString("INDEX_NAME"));
        }
        indexRs.close();
        return indexList;
    }

    public Table getTable(String tableName) {
        return new SpannerTable(this.jdbcTemplate, (SpannerDatabase)this.database, this, tableName);
    }
}

