/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.info;

import java.sql.SQLException;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.VerbExtension;
import org.flywaydb.verb.VerbUtils;
import org.flywaydb.verb.info.ExperimentalMigrationInfoService;

public class InfoVerbExtension
implements VerbExtension {
    private static final Log LOG = LogFactory.getLog(InfoVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "info".equals(verb);
    }

    public Object executeVerb(Configuration configuration, FlywayTelemetryManager flywayTelemetryManager) {
        try {
            ExperimentalDatabase experimentalDatabase = VerbUtils.getExperimentalDatabase((Configuration)configuration);
            SchemaHistoryModel schemaHistoryModel = VerbUtils.getSchemaHistoryModel((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase);
            ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)flywayTelemetryManager, (MetaData)experimentalDatabase.getDatabaseMetaData());
            MigrationInfo[] migrations = VerbUtils.getMigrationInfos((Configuration)configuration, (ExperimentalDatabase)experimentalDatabase, (SchemaHistoryModel)schemaHistoryModel);
            if (!experimentalDatabase.schemaHistoryTableExists(configuration.getTable())) {
                LOG.info("Schema history table " + experimentalDatabase.quote(new String[]{experimentalDatabase.getCurrentSchema(), configuration.getTable()}) + " does not exist yet");
            }
            return new ExperimentalMigrationInfoService(migrations, configuration, experimentalDatabase.getName(), experimentalDatabase.allSchemasEmpty(VerbUtils.getAllSchemasFromConfiguration((Configuration)configuration)));
        }
        catch (SQLException e) {
            throw new FlywayException((Throwable)e);
        }
    }
}

