/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.sql;

import com.amazonaws.secretsmanager.caching.SecretCache;
import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.sql.AWSSecretsManagerDriver;
import java.sql.SQLException;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.utils.StringUtils;

public final class AWSSecretsManagerOracleDriver
extends AWSSecretsManagerDriver {
    public static final int USER_CREDENTIALS_DO_NOT_MATCH = 17079;
    public static final int INVALID_USERNAME_OR_PASSWORD = 1017;
    public static final int INCORRECT_USER_PASSWORD = 9911;
    public static final String SUBPREFIX = "oracle";

    public AWSSecretsManagerOracleDriver() {
    }

    public AWSSecretsManagerOracleDriver(SecretCache cache) {
        super(cache);
    }

    public AWSSecretsManagerOracleDriver(SecretsManagerClientBuilder builder) {
        super(builder);
    }

    public AWSSecretsManagerOracleDriver(SecretsManagerClient client) {
        super(client);
    }

    public AWSSecretsManagerOracleDriver(SecretCacheConfiguration cacheConfig) {
        super(cacheConfig);
    }

    @Override
    public String getPropertySubprefix() {
        return SUBPREFIX;
    }

    @Override
    public boolean isExceptionDueToAuthenticationError(Exception e) {
        if (e instanceof SQLException) {
            SQLException sqle = (SQLException)e;
            int errorCode = sqle.getErrorCode();
            return errorCode == 17079 || errorCode == 1017 || errorCode == 9911;
        }
        return false;
    }

    @Override
    public String constructUrlFromEndpointPortDatabase(String endpoint, String port, String dbname) {
        String url = "jdbc:oracle:thin:@//" + endpoint;
        if (StringUtils.isNotBlank((CharSequence)port)) {
            url = url + ":" + port;
        }
        if (StringUtils.isNotBlank((CharSequence)dbname)) {
            url = url + "/" + dbname;
        }
        return url;
    }

    @Override
    public String getDefaultDriverClass() {
        return "oracle.jdbc.OracleDriver";
    }

    static {
        AWSSecretsManagerDriver.register(new AWSSecretsManagerOracleDriver());
    }
}

