/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.LoadableMigrationInfo;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.output.CommandResultFactory;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.experimental.ConnectionType;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.internal.exception.FlywayMigrateException;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlStatementIterator;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.verb.VerbUtils;
import org.flywaydb.verb.migrate.MigrationExecutionGroup;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class JdbcMigrator
extends Migrator {
    private static final Log LOG = LogFactory.getLog(JdbcMigrator.class);

    @Override
    public List<MigrationExecutionGroup> createGroups(MigrationInfo[] allPendingMigrations, Configuration configuration, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext) {
        if (experimentalDatabase.getDatabaseMetaData().connectionType() != ConnectionType.JDBC) {
            return List.of(new MigrationExecutionGroup(List.of(allPendingMigrations), true));
        }
        List<MigrationInfo> currentGroup = Arrays.asList(allPendingMigrations);
        List<Pair> shouldExecuteMigrations = currentGroup.stream().map(x -> Pair.of((Object)x, (Object)this.shouldExecuteInTransaction((MigrationInfo)x, configuration, experimentalDatabase, parsingContext))).toList();
        if (!configuration.isGroup()) {
            return shouldExecuteMigrations.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
        }
        for (Pair pair : shouldExecuteMigrations) {
            MigrationInfo migrationInfo = (MigrationInfo)pair.getLeft();
            boolean shouldExecuteMigrationInTransaction = (Boolean)pair.getRight();
            if (configuration.isExecuteInTransaction() == shouldExecuteMigrationInTransaction) continue;
            if (configuration.isMixed()) {
                return shouldExecuteMigrations.stream().map(x -> new MigrationExecutionGroup(List.of((MigrationInfo)x.getLeft()), (Boolean)x.getRight())).toList();
            }
            throw new FlywayMigrateException(migrationInfo, "Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration: " + experimentalDatabase.doQuote((migrationInfo.isVersioned() ? migrationInfo.getVersion().getVersion() : "") + (String)(StringUtils.hasLength((String)migrationInfo.getDescription()) ? " " + migrationInfo.getDescription() : "")) + (shouldExecuteMigrationInTransaction ? "" : " [non-transactional]"), shouldExecuteMigrationInTransaction, migrateResult);
        }
        if (!configuration.isExecuteInTransaction()) {
            return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), false)).toList();
        }
        List<Pair> migrationContainsNonTransactionalStatements = currentGroup.stream().map(x -> Pair.of((Object)x, (Object)this.containsNonTransactionalStatements(configuration, experimentalDatabase, (MigrationInfo)x, parsingContext))).toList();
        for (Pair pair : migrationContainsNonTransactionalStatements) {
            LoadableMigrationInfo loadableMigrationInfo;
            boolean containsNonTransactionalStatements;
            MigrationInfo migrationInfo = (MigrationInfo)pair.getLeft();
            if (!(migrationInfo instanceof LoadableMigrationInfo) || !(containsNonTransactionalStatements = this.containsNonTransactionalStatements(configuration, experimentalDatabase, (MigrationInfo)(loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo), parsingContext))) continue;
            if (configuration.isMixed()) {
                return Arrays.stream(allPendingMigrations).map(x -> new MigrationExecutionGroup(List.of(x), (Boolean)pair.getRight())).toList();
            }
            throw new FlywayMigrateException(migrationInfo, "Detected both transactional and non-transactional migrations within the same migration group (even though mixed is false). First offending migration: " + experimentalDatabase.doQuote((migrationInfo.isVersioned() ? migrationInfo.getVersion().getVersion() : "") + (String)(StringUtils.hasLength((String)migrationInfo.getDescription()) ? " " + migrationInfo.getDescription() : "")) + " [non-transactional]", false, migrateResult);
        }
        return List.of(new MigrationExecutionGroup(currentGroup, true));
    }

    @Override
    public int doExecutionGroup(Configuration configuration, MigrationExecutionGroup executionGroup, ExperimentalDatabase experimentalDatabase, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank) {
        int rank = installedRank;
        boolean executeInTransaction = executionGroup.shouldExecuteInTransaction();
        if (executeInTransaction) {
            experimentalDatabase.startTransaction();
        }
        for (MigrationInfo migrationInfo : executionGroup.migrations()) {
            if (!configuration.isMixed() && configuration.isExecuteInTransaction()) {
                this.validateMixedStatements(configuration, experimentalDatabase, migrationInfo, parsingContext);
            }
            this.doIndividualMigration(migrationInfo, experimentalDatabase, configuration, migrateResult, parsingContext, rank, executeInTransaction);
            ++rank;
        }
        if (executeInTransaction) {
            experimentalDatabase.commitTransaction();
        }
        return rank;
    }

    private void doIndividualMigration(MigrationInfo migrationInfo, ExperimentalDatabase experimentalDatabase, Configuration configuration, MigrateResult migrateResult, ParsingContext parsingContext, int installedRank, boolean executeInTransaction) {
        StopWatch watch;
        block13: {
            watch = new StopWatch();
            watch.start();
            SqlStatement sqlStatement = null;
            boolean outOfOrder = migrationInfo.getState() == MigrationState.OUT_OF_ORDER && configuration.isOutOfOrder();
            String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
            try {
                if (configuration.isSkipExecutingMigrations()) {
                    LOG.debug("Skipping execution of migration of " + migrationText);
                    break block13;
                }
                LOG.debug("Starting migration of " + migrationText + " ...");
                if (!migrationInfo.getType().isUndo()) {
                    LOG.info("Migrating " + migrationText);
                } else {
                    LOG.info("Undoing migration of " + migrationText);
                }
                if (!(migrationInfo instanceof LoadableMigrationInfo)) break block13;
                LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
                try (SqlStatementIterator sqlStatementIterator = this.getSqlStatementIterator(experimentalDatabase, configuration, loadableMigrationInfo, parsingContext);){
                    int batchNumber = 0;
                    while (sqlStatementIterator.hasNext()) {
                        sqlStatement = (SqlStatement)sqlStatementIterator.next();
                        JdbcMigrator.doIndividualStatement(experimentalDatabase, sqlStatement, configuration.isBatch(), configuration.isOutputQueryResults(), sqlStatementIterator.hasNext(), batchNumber++);
                    }
                }
            }
            catch (FlywayException e) {
                watch.stop();
                int totalTimeMillis = (int)watch.getTotalTimeMillis();
                this.handleMigrationError(e, experimentalDatabase, migrationInfo, sqlStatement, migrateResult, configuration.getTable(), configuration.isOutOfOrder(), installedRank, experimentalDatabase.getInstalledBy(configuration), executeInTransaction, totalTimeMillis);
            }
        }
        watch.stop();
        ++migrateResult.migrationsExecuted;
        int totalTimeMillis = (int)watch.getTotalTimeMillis();
        migrateResult.putSuccessfulMigration(migrationInfo, totalTimeMillis);
        if (migrationInfo.isVersioned()) {
            migrateResult.targetSchemaVersion = migrationInfo.getVersion().getVersion();
        }
        migrateResult.migrations.add(CommandResultFactory.createMigrateOutput((MigrationInfo)migrationInfo, (int)totalTimeMillis, null));
        JdbcMigrator.updateSchemaHistoryTable(configuration.getTable(), migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, experimentalDatabase.getInstalledBy(configuration), true);
    }

    private boolean containsNonTransactionalStatements(Configuration configuration, ExperimentalDatabase experimentalDatabase, MigrationInfo migrationInfo, ParsingContext parsingContext) {
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            try (SqlStatementIterator sqlStatementIterator = this.getSqlStatementIterator(experimentalDatabase, configuration, loadableMigrationInfo, parsingContext);){
                while (sqlStatementIterator.hasNext()) {
                    SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                    if (sqlStatement.canExecuteInTransaction()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    private boolean shouldExecuteInTransaction(MigrationInfo migrationInfo, Configuration configuration, ExperimentalDatabase experimentalDatabase, ParsingContext parsingContext) {
        LoadableMigrationInfo loadableMigrationInfo;
        if (migrationInfo instanceof LoadableMigrationInfo && (loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo).getSqlScriptMetadata() != null && loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction() != null) {
            return loadableMigrationInfo.getSqlScriptMetadata().executeInTransaction();
        }
        return configuration.isExecuteInTransaction() && !this.containsNonTransactionalStatements(configuration, experimentalDatabase, migrationInfo, parsingContext);
    }

    private static void doIndividualStatement(ExperimentalDatabase experimentalDatabase, SqlStatement sqlStatement, boolean isBatch, boolean outputQueryResults, boolean hasNextStatement, int batchNumber) {
        if (isBatch) {
            if (sqlStatement.isBatchable()) {
                experimentalDatabase.addToBatch(sqlStatement.getSql());
                if (batchNumber >= 100 || !hasNextStatement) {
                    experimentalDatabase.doExecuteBatch();
                }
            } else {
                experimentalDatabase.doExecuteBatch();
                experimentalDatabase.doExecute(sqlStatement.getSql(), outputQueryResults);
            }
        } else {
            experimentalDatabase.doExecute(sqlStatement.getSql(), outputQueryResults);
        }
    }

    private SqlStatementIterator getSqlStatementIterator(ExperimentalDatabase experimentalDatabase, Configuration configuration, LoadableMigrationInfo loadableMigrationInfo, ParsingContext parsingContext) {
        Parser parser = (Parser)experimentalDatabase.getParser().apply(configuration, parsingContext);
        SqlScriptMetadata metadata = loadableMigrationInfo.getSqlScriptMetadata();
        return parser.parse(loadableMigrationInfo.getLoadableResource(), metadata);
    }

    private void handleMigrationError(FlywayException e, ExperimentalDatabase experimentalDatabase, MigrationInfo migrationInfo, SqlStatement sqlStatement, MigrateResult migrateResult, String schemaHistoryTableName, boolean outOfOrder, int installedRank, String installedBy, boolean executeInTransaction, int totalTimeMillis) {
        String migrationText = VerbUtils.toMigrationText((MigrationInfo)migrationInfo, (boolean)executeInTransaction, (ExperimentalDatabase)experimentalDatabase, (boolean)outOfOrder);
        String failedMsg = !migrationInfo.getType().isUndo() ? "Migration of " + migrationText + " failed!" : "Undo of migration of " + migrationText + " failed!";
        migrateResult.putFailedMigration(migrationInfo, totalTimeMillis);
        migrateResult.setSuccess(false);
        if (executeInTransaction) {
            experimentalDatabase.rollbackTransaction();
        }
        if (experimentalDatabase.supportsDdlTransactions() && executeInTransaction) {
            LOG.error(failedMsg + " Changes successfully rolled back.");
        } else {
            LOG.error(failedMsg + " Please restore backups and roll back database and code!");
            JdbcMigrator.updateSchemaHistoryTable(schemaHistoryTableName, migrationInfo, totalTimeMillis, installedRank, experimentalDatabase, installedBy, false);
        }
        if (sqlStatement == null) {
            throw new FlywayMigrateException(migrationInfo, e.getMessage(), executeInTransaction, migrateResult);
        }
        String message = this.calculateErrorMessage((Exception)((Object)e), migrationInfo, sqlStatement);
        throw new FlywayMigrateException(migrationInfo, outOfOrder, message, e, executeInTransaction, migrateResult, sqlStatement);
    }

    private String calculateErrorMessage(Exception e, MigrationInfo migrationInfo, SqlStatement sqlStatement) {
        String title = "Script " + Paths.get(migrationInfo.getScript(), new String[0]).getFileName() + " failed";
        String underline = StringUtils.trimOrPad((String)"", (int)title.length(), (char)'-');
        StringBuilder messageBuilder = new StringBuilder().append(title).append("\n").append(underline).append("\n");
        Throwable throwable = e.getCause();
        if (throwable instanceof SQLException) {
            SQLException sqlException = (SQLException)throwable;
            messageBuilder.append(ExceptionUtils.toMessage((SQLException)sqlException));
        }
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            messageBuilder.append("Location   : ").append(loadableMigrationInfo.getLoadableResource().getAbsolutePath()).append(" (").append(loadableMigrationInfo.getLoadableResource().getAbsolutePathOnDisk()).append(")\n");
        } else {
            messageBuilder.append("Location   : ").append(migrationInfo.getPhysicalLocation());
        }
        if (sqlStatement != null) {
            messageBuilder.append("Line       : ").append(sqlStatement.getLineNumber()).append("\n");
            messageBuilder.append("Statement  : ").append(LOG.isDebugEnabled() ? sqlStatement.getSql() : "Run Flyway with -X option to see the actual statement causing the problem").append("\n");
        }
        return messageBuilder.toString();
    }

    private void validateMixedStatements(Configuration configuration, ExperimentalDatabase experimentalDatabase, MigrationInfo migrationInfo, ParsingContext parsingContext) {
        if (migrationInfo instanceof LoadableMigrationInfo) {
            LoadableMigrationInfo loadableMigrationInfo = (LoadableMigrationInfo)migrationInfo;
            try (SqlStatementIterator sqlStatementIterator = this.getSqlStatementIterator(experimentalDatabase, configuration, loadableMigrationInfo, parsingContext);){
                boolean haveFoundNonTransactionalStatements = false;
                boolean haveFoundTransactionalStatements = false;
                while (sqlStatementIterator.hasNext()) {
                    SqlStatement sqlStatement = (SqlStatement)sqlStatementIterator.next();
                    if (sqlStatement.canExecuteInTransaction()) {
                        haveFoundTransactionalStatements = true;
                    } else {
                        haveFoundNonTransactionalStatements = true;
                    }
                    if (!haveFoundTransactionalStatements || !haveFoundNonTransactionalStatements) continue;
                    throw new FlywayException("Detected both transactional and non-transactional statements within the same migration (even though mixed is false). Offending statement found at line " + sqlStatement.getLineNumber() + ": " + sqlStatement.getSql() + (sqlStatement.canExecuteInTransaction() ? "" : " [non-transactional]"));
                }
            }
        }
    }
}

