/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.spanner;

import java.io.IOException;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;

public class SpannerParser
extends Parser {
    private static final Log LOG = LogFactory.getLog(SpannerParser.class);
    private boolean previousStatementStartedBatch = false;

    public SpannerParser(Configuration configuration, ParsingContext parsingContext) {
        super(configuration, parsingContext, 3);
    }

    protected char getIdentifierQuote() {
        return '`';
    }

    protected char getAlternativeIdentifierQuote() {
        return '\"';
    }

    protected Boolean detectCanExecuteInTransaction(String simplifiedStatement, List<Token> keywords) {
        LOG.debug("checking if [" + simplifiedStatement + "] can run in transaction");
        return false;
    }

    protected boolean shouldAdjustBlockDepth(ParserContext context, List<Token> tokens, Token token) {
        return this.previousStatementStartedBatch || super.shouldAdjustBlockDepth(context, tokens, token) || token.getType() == TokenType.DELIMITER;
    }

    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) throws IOException {
        String keywordText = keyword.getText();
        if (this.previousStatementStartedBatch) {
            context.increaseBlockDepth("");
            this.previousStatementStartedBatch = false;
        }
        if (tokens.stream().anyMatch(t -> "START".equals(t.getText())) && keyword.getType() == TokenType.DELIMITER) {
            this.previousStatementStartedBatch = true;
        }
        if ("RUN".equals(keywordText) && context.getBlockDepth() > 0) {
            context.decreaseBlockDepth();
        }
        super.adjustBlockDepth(context, tokens, keyword, reader);
    }
}

