/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.rpc.Code;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;

class JdbcTypeConverter {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    JdbcTypeConverter() {
    }

    static Object convert(Object value, Type type, Class<?> targetType) throws SQLException {
        JdbcPreconditions.checkArgument(type != null, "type may not be null");
        JdbcPreconditions.checkArgument(targetType != null, "targetType may not be null");
        JdbcTypeConverter.checkValidTypeAndValueForConvert(type, value);
        if (value == null) {
            return null;
        }
        try {
            if (targetType.equals(Value.class)) {
                return JdbcTypeConverter.convertToSpannerValue(value, type);
            }
            if (targetType.equals(String.class)) {
                if (type.getCode() == Type.Code.BYTES) {
                    return new String((byte[])value, UTF8);
                }
                if (type.getCode() == Type.Code.TIMESTAMP) {
                    Timestamp timestamp = Timestamp.of((java.sql.Timestamp)((java.sql.Timestamp)value));
                    return TIMESTAMP_FORMAT.format(ZonedDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()), ZoneId.systemDefault()));
                }
                return value.toString();
            }
            if (targetType.equals(byte[].class)) {
                if (type.getCode() == Type.Code.BYTES) {
                    return value;
                }
                if (type.getCode() == Type.Code.STRING || type.getCode() == Type.Code.JSON || type.getCode() == Type.Code.PG_JSONB) {
                    return ((String)value).getBytes(UTF8);
                }
            }
            if (targetType.equals(Boolean.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return value;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return (Long)value != 0L;
                }
                if (type.getCode() == Type.Code.FLOAT64) {
                    return (Double)value != 0.0;
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return !value.equals(BigDecimal.ZERO);
                }
            }
            if (targetType.equals(BigDecimal.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return BigDecimal.valueOf((Long)value);
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return value;
                }
            }
            if (targetType.equals(Long.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? 1L : 0L;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return value;
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return AbstractJdbcWrapper.checkedCastToLong((BigDecimal)value);
                }
            }
            if (targetType.equals(Integer.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return AbstractJdbcWrapper.checkedCastToInt((Long)value);
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return AbstractJdbcWrapper.checkedCastToInt((BigDecimal)value);
                }
            }
            if (targetType.equals(Short.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return AbstractJdbcWrapper.checkedCastToShort((Long)value);
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return AbstractJdbcWrapper.checkedCastToShort((BigDecimal)value);
                }
            }
            if (targetType.equals(Byte.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? 1 : 0;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return AbstractJdbcWrapper.checkedCastToByte((Long)value);
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return AbstractJdbcWrapper.checkedCastToByte((BigDecimal)value);
                }
            }
            if (targetType.equals(BigInteger.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
                }
                if (type.getCode() == Type.Code.INT64) {
                    return BigInteger.valueOf((Long)value);
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return AbstractJdbcWrapper.checkedCastToBigInteger((BigDecimal)value);
                }
            }
            if (targetType.equals(Float.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? Float.valueOf(1.0f) : Float.valueOf(0.0f);
                }
                if (type.getCode() == Type.Code.FLOAT64) {
                    return Float.valueOf(AbstractJdbcWrapper.checkedCastToFloat((Double)value));
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return Float.valueOf(((BigDecimal)value).floatValue());
                }
            }
            if (targetType.equals(Double.class)) {
                if (type.getCode() == Type.Code.BOOL) {
                    return (Boolean)value != false ? Double.valueOf(1.0) : Double.valueOf(0.0);
                }
                if (type.getCode() == Type.Code.FLOAT64) {
                    return value;
                }
                if (type.getCode() == Type.Code.NUMERIC) {
                    return ((BigDecimal)value).doubleValue();
                }
            }
            if (targetType.equals(java.sql.Date.class) && type.getCode() == Type.Code.DATE) {
                return value;
            }
            if (targetType.equals(LocalDate.class) && type.getCode() == Type.Code.DATE) {
                return ((java.sql.Date)value).toLocalDate();
            }
            if (targetType.equals(java.sql.Timestamp.class) && type.getCode() == Type.Code.TIMESTAMP) {
                return value;
            }
            if (targetType.equals(OffsetDateTime.class) && type.getCode() == Type.Code.TIMESTAMP) {
                Timestamp timestamp = Timestamp.of((java.sql.Timestamp)((java.sql.Timestamp)value));
                return OffsetDateTime.ofInstant(Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos()), ZoneId.systemDefault());
            }
            if (targetType.equals(Array.class) && type.getCode() == Type.Code.ARRAY) {
                return value;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw JdbcSqlExceptionFactory.of("Cannot convert " + value + " to " + targetType.getName(), Code.INVALID_ARGUMENT, e);
        }
        throw JdbcSqlExceptionFactory.of("Cannot convert " + type.getCode().name() + " to " + targetType.getName(), Code.INVALID_ARGUMENT);
    }

    private static Value convertToSpannerValue(Object value, Type type) throws SQLException {
        switch (type.getCode()) {
            case ARRAY: {
                switch (type.getArrayElementType().getCode()) {
                    case BOOL: {
                        return Value.boolArray(Arrays.asList((Boolean[])((Array)value).getArray()));
                    }
                    case BYTES: {
                        return Value.bytesArray(JdbcTypeConverter.toGoogleBytes((byte[][])((Array)value).getArray()));
                    }
                    case DATE: {
                        return Value.dateArray(JdbcTypeConverter.toGoogleDates((java.sql.Date[])((Array)value).getArray()));
                    }
                    case FLOAT64: {
                        return Value.float64Array(Arrays.asList((Double[])((Array)value).getArray()));
                    }
                    case INT64: {
                        return Value.int64Array(Arrays.asList((Long[])((Array)value).getArray()));
                    }
                    case NUMERIC: {
                        return Value.numericArray(Arrays.asList((BigDecimal[])((Array)value).getArray()));
                    }
                    case PG_NUMERIC: {
                        return Value.pgNumericArray(Arrays.asList((String[])((Array)value).getArray()));
                    }
                    case STRING: {
                        return Value.stringArray(Arrays.asList((String[])((Array)value).getArray()));
                    }
                    case TIMESTAMP: {
                        return Value.timestampArray(JdbcTypeConverter.toGoogleTimestamps((java.sql.Timestamp[])((Array)value).getArray()));
                    }
                    case JSON: {
                        return Value.jsonArray(Arrays.asList((String[])((Array)value).getArray()));
                    }
                    case PG_JSONB: {
                        return Value.pgJsonbArray(Arrays.asList((String[])((Array)value).getArray()));
                    }
                }
                throw JdbcSqlExceptionFactory.of("invalid argument: " + value, Code.INVALID_ARGUMENT);
            }
            case BOOL: {
                return Value.bool((Boolean)((Boolean)value));
            }
            case BYTES: {
                return Value.bytes((ByteArray)ByteArray.copyFrom((byte[])((byte[])value)));
            }
            case DATE: {
                return Value.date((Date)JdbcTypeConverter.toGoogleDate((java.sql.Date)value));
            }
            case FLOAT64: {
                return Value.float64((Double)((Double)value));
            }
            case INT64: {
                return Value.int64((Long)((Long)value));
            }
            case NUMERIC: {
                return Value.numeric((BigDecimal)((BigDecimal)value));
            }
            case PG_NUMERIC: {
                return Value.pgNumeric((String)(value == null ? null : value.toString()));
            }
            case STRING: {
                return Value.string((String)((String)value));
            }
            case TIMESTAMP: {
                return Value.timestamp((Timestamp)JdbcTypeConverter.toGoogleTimestamp((java.sql.Timestamp)value));
            }
            case JSON: {
                return Value.json((String)((String)value));
            }
            case PG_JSONB: {
                return Value.pgJsonb((String)((String)value));
            }
        }
        throw JdbcSqlExceptionFactory.of("invalid argument: " + value, Code.INVALID_ARGUMENT);
    }

    private static void checkValidTypeAndValueForConvert(Type type, Object value) throws SQLException {
        if (value == null) {
            return;
        }
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.ARRAY || Array.class.isAssignableFrom(value.getClass()), "input type is array, but input value is not an instance of java.sql.Array");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.BOOL || value.getClass().equals(Boolean.class), "input type is bool, but input value is not an instance of Boolean");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.BYTES || value.getClass().equals(byte[].class), "input type is bytes, but input value is not an instance of byte[]");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.DATE || value.getClass().equals(java.sql.Date.class), "input type is date, but input value is not an instance of java.sql.Date");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.FLOAT64 || value.getClass().equals(Double.class), "input type is float64, but input value is not an instance of Double");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.INT64 || value.getClass().equals(Long.class), "input type is int64, but input value is not an instance of Long");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.STRING || value.getClass().equals(String.class), "input type is string, but input value is not an instance of String");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.TIMESTAMP || value.getClass().equals(java.sql.Timestamp.class), "input type is timestamp, but input value is not an instance of java.sql.Timestamp");
        JdbcPreconditions.checkArgument(type.getCode() != Type.Code.NUMERIC || value.getClass().equals(BigDecimal.class), "input type is numeric, but input value is not an instance of BigDecimal");
    }

    static Date toGoogleDate(java.sql.Date date) {
        return date == null ? null : Date.fromYearMonthDay((int)(date.getYear() + 1900), (int)(date.getMonth() + 1), (int)date.getDate());
    }

    static Date toGoogleDate(Time date) {
        return Date.fromYearMonthDay((int)1970, (int)1, (int)1);
    }

    static Date toGoogleDate(java.sql.Timestamp date) {
        return date == null ? null : Date.fromYearMonthDay((int)(date.getYear() + 1900), (int)(date.getMonth() + 1), (int)date.getDate());
    }

    static List<Date> toGoogleDates(java.sql.Date[] dates) {
        ArrayList<Date> res = new ArrayList<Date>(dates.length);
        for (java.sql.Date date : dates) {
            res.add(JdbcTypeConverter.toGoogleDate(date));
        }
        return res;
    }

    static java.sql.Date toSqlDate(Date date) {
        return JdbcTypeConverter.toSqlDate(date, Calendar.getInstance());
    }

    static java.sql.Date toSqlDate(Date date, Calendar cal) {
        if (date != null) {
            cal.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth(), 0, 0, 0);
            cal.clear(14);
            return new java.sql.Date(cal.getTimeInMillis());
        }
        return null;
    }

    static List<java.sql.Date> toSqlDates(List<Date> dates) {
        ArrayList<java.sql.Date> res = new ArrayList<java.sql.Date>(dates.size());
        for (Date date : dates) {
            res.add(JdbcTypeConverter.toSqlDate(date));
        }
        return res;
    }

    static java.sql.Timestamp toSqlTimestamp(Timestamp ts) {
        return ts == null ? null : ts.toSqlTimestamp();
    }

    static java.sql.Timestamp toSqlTimestamp(Date date) {
        return date == null ? null : new java.sql.Timestamp(JdbcTypeConverter.toSqlDate(date).getTime());
    }

    static java.sql.Timestamp toSqlTimestamp(Date date, Calendar cal) {
        return date == null ? null : new java.sql.Timestamp(JdbcTypeConverter.toSqlDate(date, cal).getTime());
    }

    static java.sql.Timestamp getAsSqlTimestamp(Timestamp ts, Calendar cal) {
        return ts == null ? null : JdbcTypeConverter.getTimestampInCalendar(ts.toSqlTimestamp(), cal);
    }

    static java.sql.Timestamp getTimestampInCalendar(java.sql.Timestamp sqlTs, Calendar cal) {
        return JdbcTypeConverter.getOrSetTimestampInCalendar(sqlTs, cal, GetOrSetTimestampInCalendar.GET);
    }

    static java.sql.Timestamp setTimestampInCalendar(java.sql.Timestamp sqlTs, Calendar cal) {
        return JdbcTypeConverter.getOrSetTimestampInCalendar(sqlTs, cal, GetOrSetTimestampInCalendar.SET);
    }

    private static java.sql.Timestamp getOrSetTimestampInCalendar(java.sql.Timestamp sqlTs, Calendar cal, GetOrSetTimestampInCalendar getOrSet) {
        if (sqlTs != null) {
            Calendar newCal = Calendar.getInstance(cal.getTimeZone());
            newCal.setTimeInMillis(sqlTs.getTime());
            newCal.set(14, 0);
            int offset = newCal.getTimeZone().getOffset(newCal.getTimeInMillis());
            newCal.add(14, getOrSet == GetOrSetTimestampInCalendar.GET ? offset : -offset);
            java.sql.Timestamp res = new java.sql.Timestamp(newCal.getTimeInMillis());
            res.setNanos(sqlTs.getNanos());
            return res;
        }
        return null;
    }

    static List<java.sql.Timestamp> toSqlTimestamps(List<Timestamp> timestamps) {
        ArrayList<java.sql.Timestamp> res = new ArrayList<java.sql.Timestamp>(timestamps.size());
        for (Timestamp timestamp : timestamps) {
            res.add(JdbcTypeConverter.toSqlTimestamp(timestamp));
        }
        return res;
    }

    static Timestamp toGoogleTimestamp(java.util.Date ts) {
        if (ts != null) {
            long milliseconds = ts.getTime();
            long seconds = milliseconds / 1000L;
            long nanos = (milliseconds - seconds * 1000L) * 1000000L;
            return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)((int)nanos));
        }
        return null;
    }

    static Timestamp toGoogleTimestamp(java.sql.Timestamp ts) {
        if (ts != null) {
            long milliseconds = ts.getTime();
            long seconds = milliseconds / 1000L;
            int nanos = ts.getNanos();
            return Timestamp.ofTimeSecondsAndNanos((long)seconds, (int)nanos);
        }
        return null;
    }

    static List<Timestamp> toGoogleTimestamps(java.sql.Timestamp[] timestamps) {
        ArrayList<Timestamp> res = new ArrayList<Timestamp>(timestamps.length);
        for (java.sql.Timestamp timestamp : timestamps) {
            res.add(JdbcTypeConverter.toGoogleTimestamp(timestamp));
        }
        return res;
    }

    static Time toSqlTime(Timestamp ts) {
        if (ts != null) {
            java.sql.Timestamp sqlTs = JdbcTypeConverter.toSqlTimestamp(ts);
            Time time = new Time(sqlTs.getHours(), sqlTs.getMinutes(), sqlTs.getSeconds());
            time.setTime(time.getTime() + TimeUnit.MILLISECONDS.convert(sqlTs.getNanos(), TimeUnit.NANOSECONDS));
            return time;
        }
        return null;
    }

    static Time toSqlTime(Timestamp ts, Calendar cal) {
        if (ts != null) {
            java.sql.Timestamp sqlTs = JdbcTypeConverter.getAsSqlTimestamp(ts, cal);
            Time time = new Time(sqlTs.getHours(), sqlTs.getMinutes(), sqlTs.getSeconds());
            time.setTime(time.getTime() + TimeUnit.MILLISECONDS.convert(sqlTs.getNanos(), TimeUnit.NANOSECONDS));
            return time;
        }
        return null;
    }

    static Time parseSqlTime(String val, Calendar cal) {
        if (val != null) {
            Time time = Time.valueOf(val);
            cal.set(1970, 0, 1, time.getHours(), time.getMinutes(), time.getSeconds());
            cal.clear(14);
            return new Time(cal.getTimeInMillis());
        }
        return null;
    }

    static List<ByteArray> toGoogleBytes(byte[][] bytes) {
        ArrayList<ByteArray> res = new ArrayList<ByteArray>(bytes.length);
        for (byte[] aByte : bytes) {
            res.add(aByte == null ? null : ByteArray.copyFrom((byte[])aByte));
        }
        return res;
    }

    static List<byte[]> toJavaByteArrays(List<ByteArray> bytes) {
        ArrayList<byte[]> res = new ArrayList<byte[]>(bytes.size());
        for (ByteArray ba : bytes) {
            res.add(ba == null ? null : ba.toByteArray());
        }
        return res;
    }

    private static enum GetOrSetTimestampInCalendar {
        GET,
        SET;

    }
}

