# WAMR-IDE (Experimental)

## Introduction

The WAMR-IDE is an Integrated Development Environment to develop WebAssembly application with coding, compiling and source debugging support. It contains 3 components: `VSCode extension`, `WASM-toolchain-provider docker image` and `WASM source debug server docker image`.

-   `VSCode extension` is an extension which can be installed in `vscode`, with which user can build and manage projects, develop `wasm application`, including `building`, `running` and `debugging`.

-   `WASM-toolchain-provider` is a docker image which provides building environment for wasm.

-   `WASM source debug server` is a docker image which provides running and source debugging environment for wasm application.

---

## How to setup WAMR IDE

1.  Install `VSCode` on host.

    -   make sure the version of [vscode](https://code.visualstudio.com/Download) you installed is at least _1.59.0_

2.  Install `Docker` on host.

    1. [Windows: Docker Desktop](https://docs.docker.com/desktop/windows/install/)
    2. [Ubuntu: Docker Engine](https://docs.docker.com/engine/install/ubuntu)
        ```xml
        OS requirements:
        To install Docker Engine, you need the 64-bit version of one of these Ubuntu versions:
        - Ubuntu Impish 21.10
        - Ubuntu Hirsute 21.04
        - Ubuntu Focal 20.04(LTS)
        - Ubuntu Bionic 18.04(LTS)
        ```

3.  Build docker images

    We have 2 docker images which should be built or loaded on your host, `wasm-toolchain-provider` and `wamr-debug-server`. To build these 2 images, please enter the `WASM_Source_Debug_Server/Docker` & `WASM_Toolchain/Docker`, then execute the `build_docker_image` script respectively.

         ```shell
         $ cd WASM_Toolchain/Docker
         $ ./build_docker_image.bat # or ./build_docker_image.sh on linux
         $ cd WASM_Source_Debug_Server/Docker
         $ ./build_docker_image.bat # or ./build_docker_image.sh on linux
         ```

4.  Generate wamride extension package file

    `wamride-0.0.1.vsix` can be packaged by [`npm vsce`](https://code.visualstudio.com/api/working-with-extensions/publishing-extension).

    > Note that patched `lldb` should be built and put into the `VSCode_Extension/resource/debug` folder before your package or extension debug process if you want to enable `source debugging` feature. Please follow this [instruction](../../doc/source_debugging.md#debugging-with-interpreter) to build `lldb`.
    >
    > **You can also debug the extension directly follow this [instruction](./VSCode_Extension/README.md) without packing the extension.**

5.  Install extension from vsix

    ![install_from_vsix](./Media/install_from_vsix.png "install wamr-ide from vsix")

    and select `wamride-0.0.1.vsix` which you have saved on your host.

---

## How to use `wamr-ide`

#### `WAMR-IDE` extension contains 2 components as following picture showing. `Project management` and `Execution management`

![wamr_ide_main_menu](./Media/wamr_ide_main_menu.png "wamr-ide main menu")

### Project Management

1.  New project

    When you click `New project` button, extension will pop up a message box at the bottom right of the screen as picture showing.

    ![set_up_workspace_message](./Media/set_up_workspace_message.png "set up workspace message box")

    You can click `Set up now` and select the target folder to create project workspace, click `Maybe later` to close the message box.

    > Note that your selected workspace folder should be **empty**.

    After setting up workspace, extension will prompt successful message:

    ```xml
    workspace set up successfully!
    ```

    Then click `New project` button again, a new page will show as following.

    ![new_project_page](./Media/new_project_page.png "new project page")

    Enter the `project name` and select the `template`, then click `Create` button. And a new project will be generated and opened in your current `vscode window` or in a new `vscode window`.

    > Opening in current windows or a new one depends on whether your `vscode's explorer` is empty or not. If empty, open in current window, or open in the new vscode window.

    A new initialized project is as following picture shows.

    ![project_template](./Media/project_template.png "default project template")

    `.wamr` is the project configuration folder which contains 3 files, `CMakeLists.txt`, `project.cmake` and `compilation_config.json`. `CMakeLists.txt` is used to build `wasm target` and the `project.cmake` is included in `CMakeLists.txt`. `project.cmake` includes the user's customized configuration like those folders which should be added include path.

2.  Open project

    Click `Open project` button, `quick-pick-box` will show as following. All projects under your current workspace will be shown and can be selected.

    ![configuration file](./Media/open_project_page.png "configuration file")

3.  Change workspace

    Click `Change workspace` button, a dialog will show as following. You can select 1 folder in file system as workspace, and the new workspace path will override previous workspace, and all new created projects will be generated in the new workspace.

    ![change workspace ](./Media/change_workspace_dialog.png "change workspace dialog")

4.  Configuration
    Click `Configuration` button, a new page will be shown as following. You can config building target with `Include paths`, `Initial & Max linear memory`, `stack size`, `exported_symbols` and `include paths`, `exclude files`.

    ![config building target](./Media/Config_building_target.png "config building target")

    Then click `Modify` button to confirm, if configurations are modified successfully and following message will pop. Click `OK`, the page will be auto closed.

    ![save configuration](./Media/save_configuration.png "save configuration")

    And all configuration will be saved in `.wamr/compilation_config.json`.

    ![configuration file](./Media/compilation_config.png "configuration file")

5.  Customize `include paths` and `exclude source files`

    Extension supports adding header file folder to `include path` and excluding source file from build.

-   `Add to include path`

    -   Move the cursor to the `folder` and right click, then `menus` will be shown as following. Click `Toggle state of path including`.

    ![right click menus](./Media/right_click_menus_1.png "right click menus")

-   `Exclude source file from build`

    -   Move the cursor to the `source file` and right click, then `menus` will be shown as following. Click `Toggle state of excluding`.

    ![right click menus](./Media/right_click_menus_2.png "right click menus")

    #### After setting up `include path` and `exclude files`, the corresponding folder and files will be decorated with color and icon as following picture shows.

    ![decoration for files](./Media/decoration_for_files.png "decoration for files")

    At the same time, all added `include path` and `exclude files` will be saved in `.wamr/compilation_config.json` as json array.

    ![compilation config](./Media/compilation_config_2.png "compilation config")

> `Toggle state of path including` just shows when selecting `folder` and hides with other resources.
>
> `Toggle state of excluding` just shows when selecting `[.c | .cpp | .cxx] source files` and hides with other resources.

### Execution Management

1. `Build`

    When you have completed coding and ready to build target, click `build` button and the `wasm-toolchain` will auto start a container and execute the building process.

    ![build terminal output](./Media/build_terminal.png "build terminal output")

    After successful building execution, `build` folder will be generated in `explorer`, in which `${output_file_name}.wasm` is exist.

    ![build folder](./Media/build_folder.png "build folder")

    > Note that to start `docker service` firstly.

2. `Run`

    Click `Run` button and `wasm-debug-server` docker image will auto start a container and execute the running process.

    ![run](./Media/run.png "run wasm")

3. `Debug`

    Click `Debug` button will trigger start ip `wamr-debug-server` docker image, and boot up `lldb debug server` inside of iwasm. Then start a debugging session with configuration to connect. Tap `F11` or click `step into` to start debugging.

    ![debug](./Media/debug.png "source debugging")

    > Docker containers will be auto stopped and removed after the execution.
