#ifndef LAPACK_STRUCTURES_H
#define LAPACK_STRUCTURES_H

#include <stdint.h>

#include "flexiblas_fortran_mangle.h"
#include <complex.h>

#ifdef __cplusplus
extern "C" {
#endif

#define FLEXIBLAS_LAPACK_MAJOR 3
#define FLEXIBLAS_LAPACK_MINOR 4
#define FLEXIBLAS_LAPACK_PATCH 0
#define FLEXIBLAS_LAPACK_EXTRA "with deprecated"

typedef struct _flexiblas_lapack_backend {
    struct flexiblas_blasfn cbbcsd;
    struct flexiblas_blasfn cbdsqr;
    struct flexiblas_blasfn cgbbrd;
    struct flexiblas_blasfn cgbcon;
    struct flexiblas_blasfn cgbequ;
    struct flexiblas_blasfn cgbequb;
    struct flexiblas_blasfn cgbrfs;
    struct flexiblas_blasfn cgbsv;
    struct flexiblas_blasfn cgbsvx;
    struct flexiblas_blasfn cgbtf2;
    struct flexiblas_blasfn cgbtrf;
    struct flexiblas_blasfn cgbtrs;
    struct flexiblas_blasfn cgebak;
    struct flexiblas_blasfn cgebal;
    struct flexiblas_blasfn cgebd2;
    struct flexiblas_blasfn cgebrd;
    struct flexiblas_blasfn cgecon;
    struct flexiblas_blasfn cgeequ;
    struct flexiblas_blasfn cgeequb;
    struct flexiblas_blasfn cgees;
    struct flexiblas_blasfn cgeesx;
    struct flexiblas_blasfn cgeev;
    struct flexiblas_blasfn cgeevx;
    struct flexiblas_blasfn cgegs;
    struct flexiblas_blasfn cgegv;
    struct flexiblas_blasfn cgehd2;
    struct flexiblas_blasfn cgehrd;
    struct flexiblas_blasfn cgelq2;
    struct flexiblas_blasfn cgelqf;
    struct flexiblas_blasfn cgels;
    struct flexiblas_blasfn cgelsd;
    struct flexiblas_blasfn cgelss;
    struct flexiblas_blasfn cgelsx;
    struct flexiblas_blasfn cgelsy;
    struct flexiblas_blasfn cgeql2;
    struct flexiblas_blasfn cgeqlf;
    struct flexiblas_blasfn cgeqp3;
    struct flexiblas_blasfn cgeqpf;
    struct flexiblas_blasfn cgeqr2;
    struct flexiblas_blasfn cgeqr2p;
    struct flexiblas_blasfn cgeqrf;
    struct flexiblas_blasfn cgeqrfp;
    struct flexiblas_blasfn cgerfs;
    struct flexiblas_blasfn cgerq2;
    struct flexiblas_blasfn cgerqf;
    struct flexiblas_blasfn cgesc2;
    struct flexiblas_blasfn cgesdd;
    struct flexiblas_blasfn cgesv;
    struct flexiblas_blasfn cgesvd;
    struct flexiblas_blasfn cgesvx;
    struct flexiblas_blasfn cgetc2;
    struct flexiblas_blasfn cgetf2;
    struct flexiblas_blasfn cgetrf;
    struct flexiblas_blasfn cgetri;
    struct flexiblas_blasfn cgetrs;
    struct flexiblas_blasfn cggbak;
    struct flexiblas_blasfn cggbal;
    struct flexiblas_blasfn cgges;
    struct flexiblas_blasfn cggesx;
    struct flexiblas_blasfn cggev;
    struct flexiblas_blasfn cggevx;
    struct flexiblas_blasfn cggglm;
    struct flexiblas_blasfn cgghrd;
    struct flexiblas_blasfn cgglse;
    struct flexiblas_blasfn cggqrf;
    struct flexiblas_blasfn cggrqf;
    struct flexiblas_blasfn cggsvd;
    struct flexiblas_blasfn cggsvp;
    struct flexiblas_blasfn cgtcon;
    struct flexiblas_blasfn cgtrfs;
    struct flexiblas_blasfn cgtsv;
    struct flexiblas_blasfn cgtsvx;
    struct flexiblas_blasfn cgttrf;
    struct flexiblas_blasfn cgttrs;
    struct flexiblas_blasfn cgtts2;
    struct flexiblas_blasfn chbev;
    struct flexiblas_blasfn chbevd;
    struct flexiblas_blasfn chbevx;
    struct flexiblas_blasfn chbgst;
    struct flexiblas_blasfn chbgv;
    struct flexiblas_blasfn chbgvd;
    struct flexiblas_blasfn chbgvx;
    struct flexiblas_blasfn chbtrd;
    struct flexiblas_blasfn checon;
    struct flexiblas_blasfn cheequb;
    struct flexiblas_blasfn cheev;
    struct flexiblas_blasfn cheevd;
    struct flexiblas_blasfn cheevr;
    struct flexiblas_blasfn cheevx;
    struct flexiblas_blasfn chegs2;
    struct flexiblas_blasfn chegst;
    struct flexiblas_blasfn chegv;
    struct flexiblas_blasfn chegvd;
    struct flexiblas_blasfn chegvx;
    struct flexiblas_blasfn cherfs;
    struct flexiblas_blasfn chesv;
    struct flexiblas_blasfn chesvx;
    struct flexiblas_blasfn cheswapr;
    struct flexiblas_blasfn chetd2;
    struct flexiblas_blasfn chetf2;
    struct flexiblas_blasfn chetrd;
    struct flexiblas_blasfn chetrf;
    struct flexiblas_blasfn chetri;
    struct flexiblas_blasfn chetri2;
    struct flexiblas_blasfn chetri2x;
    struct flexiblas_blasfn chetrs;
    struct flexiblas_blasfn chetrs2;
    struct flexiblas_blasfn chfrk;
    struct flexiblas_blasfn chgeqz;
    struct flexiblas_blasfn chla_transtype;
    struct flexiblas_blasfn chpcon;
    struct flexiblas_blasfn chpev;
    struct flexiblas_blasfn chpevd;
    struct flexiblas_blasfn chpevx;
    struct flexiblas_blasfn chpgst;
    struct flexiblas_blasfn chpgv;
    struct flexiblas_blasfn chpgvd;
    struct flexiblas_blasfn chpgvx;
    struct flexiblas_blasfn chprfs;
    struct flexiblas_blasfn chpsv;
    struct flexiblas_blasfn chpsvx;
    struct flexiblas_blasfn chptrd;
    struct flexiblas_blasfn chptrf;
    struct flexiblas_blasfn chptri;
    struct flexiblas_blasfn chptrs;
    struct flexiblas_blasfn chsein;
    struct flexiblas_blasfn chseqr;
    struct flexiblas_blasfn clabrd;
    struct flexiblas_blasfn clacgv;
    struct flexiblas_blasfn clacn2;
    struct flexiblas_blasfn clacon;
    struct flexiblas_blasfn clacp2;
    struct flexiblas_blasfn clacpy;
    struct flexiblas_blasfn clacrm;
    struct flexiblas_blasfn clacrt;
    struct flexiblas_blasfn cladiv;
    struct flexiblas_blasfn claed0;
    struct flexiblas_blasfn claed7;
    struct flexiblas_blasfn claed8;
    struct flexiblas_blasfn claein;
    struct flexiblas_blasfn claesy;
    struct flexiblas_blasfn claev2;
    struct flexiblas_blasfn clag2z;
    struct flexiblas_blasfn clags2;
    struct flexiblas_blasfn clagtm;
    struct flexiblas_blasfn clahef;
    struct flexiblas_blasfn clahqr;
    struct flexiblas_blasfn clahr2;
    struct flexiblas_blasfn clahrd;
    struct flexiblas_blasfn claic1;
    struct flexiblas_blasfn clals0;
    struct flexiblas_blasfn clalsa;
    struct flexiblas_blasfn clalsd;
    struct flexiblas_blasfn clangb;
    struct flexiblas_blasfn clange;
    struct flexiblas_blasfn clangt;
    struct flexiblas_blasfn clanhb;
    struct flexiblas_blasfn clanhe;
    struct flexiblas_blasfn clanhf;
    struct flexiblas_blasfn clanhp;
    struct flexiblas_blasfn clanhs;
    struct flexiblas_blasfn clanht;
    struct flexiblas_blasfn clansb;
    struct flexiblas_blasfn clansp;
    struct flexiblas_blasfn clansy;
    struct flexiblas_blasfn clantb;
    struct flexiblas_blasfn clantp;
    struct flexiblas_blasfn clantr;
    struct flexiblas_blasfn clapll;
    struct flexiblas_blasfn clapmr;
    struct flexiblas_blasfn clapmt;
    struct flexiblas_blasfn claqgb;
    struct flexiblas_blasfn claqge;
    struct flexiblas_blasfn claqhb;
    struct flexiblas_blasfn claqhe;
    struct flexiblas_blasfn claqhp;
    struct flexiblas_blasfn claqp2;
    struct flexiblas_blasfn claqps;
    struct flexiblas_blasfn claqr0;
    struct flexiblas_blasfn claqr1;
    struct flexiblas_blasfn claqr2;
    struct flexiblas_blasfn claqr3;
    struct flexiblas_blasfn claqr4;
    struct flexiblas_blasfn claqr5;
    struct flexiblas_blasfn claqsb;
    struct flexiblas_blasfn claqsp;
    struct flexiblas_blasfn claqsy;
    struct flexiblas_blasfn clar1v;
    struct flexiblas_blasfn clar2v;
    struct flexiblas_blasfn clarcm;
    struct flexiblas_blasfn clarf;
    struct flexiblas_blasfn clarfb;
    struct flexiblas_blasfn clarfg;
    struct flexiblas_blasfn clarfgp;
    struct flexiblas_blasfn clarft;
    struct flexiblas_blasfn clarfx;
    struct flexiblas_blasfn clargv;
    struct flexiblas_blasfn clarnv;
    struct flexiblas_blasfn clarrv;
    struct flexiblas_blasfn clartg;
    struct flexiblas_blasfn clartv;
    struct flexiblas_blasfn clarz;
    struct flexiblas_blasfn clarzb;
    struct flexiblas_blasfn clarzt;
    struct flexiblas_blasfn clascl;
    struct flexiblas_blasfn claset;
    struct flexiblas_blasfn clasr;
    struct flexiblas_blasfn classq;
    struct flexiblas_blasfn claswp;
    struct flexiblas_blasfn clasyf;
    struct flexiblas_blasfn clatbs;
    struct flexiblas_blasfn clatdf;
    struct flexiblas_blasfn clatps;
    struct flexiblas_blasfn clatrd;
    struct flexiblas_blasfn clatrs;
    struct flexiblas_blasfn clatrz;
    struct flexiblas_blasfn clatzm;
    struct flexiblas_blasfn clauu2;
    struct flexiblas_blasfn clauum;
    struct flexiblas_blasfn cpbcon;
    struct flexiblas_blasfn cpbequ;
    struct flexiblas_blasfn cpbrfs;
    struct flexiblas_blasfn cpbstf;
    struct flexiblas_blasfn cpbsv;
    struct flexiblas_blasfn cpbsvx;
    struct flexiblas_blasfn cpbtf2;
    struct flexiblas_blasfn cpbtrf;
    struct flexiblas_blasfn cpbtrs;
    struct flexiblas_blasfn cpftrf;
    struct flexiblas_blasfn cpftri;
    struct flexiblas_blasfn cpftrs;
    struct flexiblas_blasfn cpocon;
    struct flexiblas_blasfn cpoequ;
    struct flexiblas_blasfn cpoequb;
    struct flexiblas_blasfn cporfs;
    struct flexiblas_blasfn cposv;
    struct flexiblas_blasfn cposvx;
    struct flexiblas_blasfn cpotf2;
    struct flexiblas_blasfn cpotrf;
    struct flexiblas_blasfn cpotri;
    struct flexiblas_blasfn cpotrs;
    struct flexiblas_blasfn cppcon;
    struct flexiblas_blasfn cppequ;
    struct flexiblas_blasfn cpprfs;
    struct flexiblas_blasfn cppsv;
    struct flexiblas_blasfn cppsvx;
    struct flexiblas_blasfn cpptrf;
    struct flexiblas_blasfn cpptri;
    struct flexiblas_blasfn cpptrs;
    struct flexiblas_blasfn cpstf2;
    struct flexiblas_blasfn cpstrf;
    struct flexiblas_blasfn cptcon;
    struct flexiblas_blasfn cpteqr;
    struct flexiblas_blasfn cptrfs;
    struct flexiblas_blasfn cptsv;
    struct flexiblas_blasfn cptsvx;
    struct flexiblas_blasfn cpttrf;
    struct flexiblas_blasfn cpttrs;
    struct flexiblas_blasfn cptts2;
    struct flexiblas_blasfn crot;
    struct flexiblas_blasfn cspcon;
    struct flexiblas_blasfn cspmv;
    struct flexiblas_blasfn cspr;
    struct flexiblas_blasfn csprfs;
    struct flexiblas_blasfn cspsv;
    struct flexiblas_blasfn cspsvx;
    struct flexiblas_blasfn csptrf;
    struct flexiblas_blasfn csptri;
    struct flexiblas_blasfn csptrs;
    struct flexiblas_blasfn csrscl;
    struct flexiblas_blasfn cstedc;
    struct flexiblas_blasfn cstegr;
    struct flexiblas_blasfn cstein;
    struct flexiblas_blasfn cstemr;
    struct flexiblas_blasfn csteqr;
    struct flexiblas_blasfn csycon;
    struct flexiblas_blasfn csyconv;
    struct flexiblas_blasfn csyequb;
    struct flexiblas_blasfn csymv;
    struct flexiblas_blasfn csyr;
    struct flexiblas_blasfn csyrfs;
    struct flexiblas_blasfn csysv;
    struct flexiblas_blasfn csysvx;
    struct flexiblas_blasfn csyswapr;
    struct flexiblas_blasfn csytf2;
    struct flexiblas_blasfn csytrf;
    struct flexiblas_blasfn csytri;
    struct flexiblas_blasfn csytri2;
    struct flexiblas_blasfn csytri2x;
    struct flexiblas_blasfn csytrs;
    struct flexiblas_blasfn csytrs2;
    struct flexiblas_blasfn ctbcon;
    struct flexiblas_blasfn ctbrfs;
    struct flexiblas_blasfn ctbtrs;
    struct flexiblas_blasfn ctfsm;
    struct flexiblas_blasfn ctftri;
    struct flexiblas_blasfn ctfttp;
    struct flexiblas_blasfn ctfttr;
    struct flexiblas_blasfn ctgevc;
    struct flexiblas_blasfn ctgex2;
    struct flexiblas_blasfn ctgexc;
    struct flexiblas_blasfn ctgsen;
    struct flexiblas_blasfn ctgsja;
    struct flexiblas_blasfn ctgsna;
    struct flexiblas_blasfn ctgsy2;
    struct flexiblas_blasfn ctgsyl;
    struct flexiblas_blasfn ctpcon;
    struct flexiblas_blasfn ctprfs;
    struct flexiblas_blasfn ctptri;
    struct flexiblas_blasfn ctptrs;
    struct flexiblas_blasfn ctpttf;
    struct flexiblas_blasfn ctpttr;
    struct flexiblas_blasfn ctrcon;
    struct flexiblas_blasfn ctrevc;
    struct flexiblas_blasfn ctrexc;
    struct flexiblas_blasfn ctrrfs;
    struct flexiblas_blasfn ctrsen;
    struct flexiblas_blasfn ctrsna;
    struct flexiblas_blasfn ctrsyl;
    struct flexiblas_blasfn ctrti2;
    struct flexiblas_blasfn ctrtri;
    struct flexiblas_blasfn ctrtrs;
    struct flexiblas_blasfn ctrttf;
    struct flexiblas_blasfn ctrttp;
    struct flexiblas_blasfn ctzrqf;
    struct flexiblas_blasfn ctzrzf;
    struct flexiblas_blasfn cunbdb;
    struct flexiblas_blasfn cuncsd;
    struct flexiblas_blasfn cung2l;
    struct flexiblas_blasfn cung2r;
    struct flexiblas_blasfn cungbr;
    struct flexiblas_blasfn cunghr;
    struct flexiblas_blasfn cungl2;
    struct flexiblas_blasfn cunglq;
    struct flexiblas_blasfn cungql;
    struct flexiblas_blasfn cungqr;
    struct flexiblas_blasfn cungr2;
    struct flexiblas_blasfn cungrq;
    struct flexiblas_blasfn cungtr;
    struct flexiblas_blasfn cunm2l;
    struct flexiblas_blasfn cunm2r;
    struct flexiblas_blasfn cunmbr;
    struct flexiblas_blasfn cunmhr;
    struct flexiblas_blasfn cunml2;
    struct flexiblas_blasfn cunmlq;
    struct flexiblas_blasfn cunmql;
    struct flexiblas_blasfn cunmqr;
    struct flexiblas_blasfn cunmr2;
    struct flexiblas_blasfn cunmr3;
    struct flexiblas_blasfn cunmrq;
    struct flexiblas_blasfn cunmrz;
    struct flexiblas_blasfn cunmtr;
    struct flexiblas_blasfn cupgtr;
    struct flexiblas_blasfn cupmtr;
    struct flexiblas_blasfn dbbcsd;
    struct flexiblas_blasfn dbdsdc;
    struct flexiblas_blasfn dbdsqr;
    struct flexiblas_blasfn ddisna;
    struct flexiblas_blasfn dgbbrd;
    struct flexiblas_blasfn dgbcon;
    struct flexiblas_blasfn dgbequ;
    struct flexiblas_blasfn dgbequb;
    struct flexiblas_blasfn dgbrfs;
    struct flexiblas_blasfn dgbsv;
    struct flexiblas_blasfn dgbsvx;
    struct flexiblas_blasfn dgbtf2;
    struct flexiblas_blasfn dgbtrf;
    struct flexiblas_blasfn dgbtrs;
    struct flexiblas_blasfn dgebak;
    struct flexiblas_blasfn dgebal;
    struct flexiblas_blasfn dgebd2;
    struct flexiblas_blasfn dgebrd;
    struct flexiblas_blasfn dgecon;
    struct flexiblas_blasfn dgeequ;
    struct flexiblas_blasfn dgeequb;
    struct flexiblas_blasfn dgees;
    struct flexiblas_blasfn dgeesx;
    struct flexiblas_blasfn dgeev;
    struct flexiblas_blasfn dgeevx;
    struct flexiblas_blasfn dgegs;
    struct flexiblas_blasfn dgegv;
    struct flexiblas_blasfn dgehd2;
    struct flexiblas_blasfn dgehrd;
    struct flexiblas_blasfn dgejsv;
    struct flexiblas_blasfn dgelq2;
    struct flexiblas_blasfn dgelqf;
    struct flexiblas_blasfn dgels;
    struct flexiblas_blasfn dgelsd;
    struct flexiblas_blasfn dgelss;
    struct flexiblas_blasfn dgelsx;
    struct flexiblas_blasfn dgelsy;
    struct flexiblas_blasfn dgeql2;
    struct flexiblas_blasfn dgeqlf;
    struct flexiblas_blasfn dgeqp3;
    struct flexiblas_blasfn dgeqpf;
    struct flexiblas_blasfn dgeqr2;
    struct flexiblas_blasfn dgeqr2p;
    struct flexiblas_blasfn dgeqrf;
    struct flexiblas_blasfn dgeqrfp;
    struct flexiblas_blasfn dgerfs;
    struct flexiblas_blasfn dgerq2;
    struct flexiblas_blasfn dgerqf;
    struct flexiblas_blasfn dgesc2;
    struct flexiblas_blasfn dgesdd;
    struct flexiblas_blasfn dgesv;
    struct flexiblas_blasfn dgesvd;
    struct flexiblas_blasfn dgesvj;
    struct flexiblas_blasfn dgesvx;
    struct flexiblas_blasfn dgetc2;
    struct flexiblas_blasfn dgetf2;
    struct flexiblas_blasfn dgetrf;
    struct flexiblas_blasfn dgetri;
    struct flexiblas_blasfn dgetrs;
    struct flexiblas_blasfn dggbak;
    struct flexiblas_blasfn dggbal;
    struct flexiblas_blasfn dgges;
    struct flexiblas_blasfn dggesx;
    struct flexiblas_blasfn dggev;
    struct flexiblas_blasfn dggevx;
    struct flexiblas_blasfn dggglm;
    struct flexiblas_blasfn dgghrd;
    struct flexiblas_blasfn dgglse;
    struct flexiblas_blasfn dggqrf;
    struct flexiblas_blasfn dggrqf;
    struct flexiblas_blasfn dggsvd;
    struct flexiblas_blasfn dggsvp;
    struct flexiblas_blasfn dgsvj0;
    struct flexiblas_blasfn dgsvj1;
    struct flexiblas_blasfn dgtcon;
    struct flexiblas_blasfn dgtrfs;
    struct flexiblas_blasfn dgtsv;
    struct flexiblas_blasfn dgtsvx;
    struct flexiblas_blasfn dgttrf;
    struct flexiblas_blasfn dgttrs;
    struct flexiblas_blasfn dgtts2;
    struct flexiblas_blasfn dhgeqz;
    struct flexiblas_blasfn dhsein;
    struct flexiblas_blasfn dhseqr;
    struct flexiblas_blasfn disnan;
    struct flexiblas_blasfn dlabad;
    struct flexiblas_blasfn dlabrd;
    struct flexiblas_blasfn dlacn2;
    struct flexiblas_blasfn dlacon;
    struct flexiblas_blasfn dlacpy;
    struct flexiblas_blasfn dladiv;
    struct flexiblas_blasfn dlae2;
    struct flexiblas_blasfn dlaebz;
    struct flexiblas_blasfn dlaed0;
    struct flexiblas_blasfn dlaed1;
    struct flexiblas_blasfn dlaed2;
    struct flexiblas_blasfn dlaed3;
    struct flexiblas_blasfn dlaed4;
    struct flexiblas_blasfn dlaed5;
    struct flexiblas_blasfn dlaed6;
    struct flexiblas_blasfn dlaed7;
    struct flexiblas_blasfn dlaed8;
    struct flexiblas_blasfn dlaed9;
    struct flexiblas_blasfn dlaeda;
    struct flexiblas_blasfn dlaein;
    struct flexiblas_blasfn dlaev2;
    struct flexiblas_blasfn dlaexc;
    struct flexiblas_blasfn dlag2;
    struct flexiblas_blasfn dlag2s;
    struct flexiblas_blasfn dlags2;
    struct flexiblas_blasfn dlagtf;
    struct flexiblas_blasfn dlagtm;
    struct flexiblas_blasfn dlagts;
    struct flexiblas_blasfn dlagv2;
    struct flexiblas_blasfn dlahqr;
    struct flexiblas_blasfn dlahr2;
    struct flexiblas_blasfn dlahrd;
    struct flexiblas_blasfn dlaic1;
    struct flexiblas_blasfn dlaisnan;
    struct flexiblas_blasfn dlaln2;
    struct flexiblas_blasfn dlals0;
    struct flexiblas_blasfn dlalsa;
    struct flexiblas_blasfn dlalsd;
    struct flexiblas_blasfn dlamc3;
    struct flexiblas_blasfn dlamch;
    struct flexiblas_blasfn dlamrg;
    struct flexiblas_blasfn dlaneg;
    struct flexiblas_blasfn dlangb;
    struct flexiblas_blasfn dlange;
    struct flexiblas_blasfn dlangt;
    struct flexiblas_blasfn dlanhs;
    struct flexiblas_blasfn dlansb;
    struct flexiblas_blasfn dlansf;
    struct flexiblas_blasfn dlansp;
    struct flexiblas_blasfn dlanst;
    struct flexiblas_blasfn dlansy;
    struct flexiblas_blasfn dlantb;
    struct flexiblas_blasfn dlantp;
    struct flexiblas_blasfn dlantr;
    struct flexiblas_blasfn dlanv2;
    struct flexiblas_blasfn dlapll;
    struct flexiblas_blasfn dlapmr;
    struct flexiblas_blasfn dlapmt;
    struct flexiblas_blasfn dlapy2;
    struct flexiblas_blasfn dlapy3;
    struct flexiblas_blasfn dlaqgb;
    struct flexiblas_blasfn dlaqge;
    struct flexiblas_blasfn dlaqp2;
    struct flexiblas_blasfn dlaqps;
    struct flexiblas_blasfn dlaqr0;
    struct flexiblas_blasfn dlaqr1;
    struct flexiblas_blasfn dlaqr2;
    struct flexiblas_blasfn dlaqr3;
    struct flexiblas_blasfn dlaqr4;
    struct flexiblas_blasfn dlaqr5;
    struct flexiblas_blasfn dlaqsb;
    struct flexiblas_blasfn dlaqsp;
    struct flexiblas_blasfn dlaqsy;
    struct flexiblas_blasfn dlaqtr;
    struct flexiblas_blasfn dlar1v;
    struct flexiblas_blasfn dlar2v;
    struct flexiblas_blasfn dlarf;
    struct flexiblas_blasfn dlarfb;
    struct flexiblas_blasfn dlarfg;
    struct flexiblas_blasfn dlarfgp;
    struct flexiblas_blasfn dlarft;
    struct flexiblas_blasfn dlarfx;
    struct flexiblas_blasfn dlargv;
    struct flexiblas_blasfn dlarnv;
    struct flexiblas_blasfn dlarra;
    struct flexiblas_blasfn dlarrb;
    struct flexiblas_blasfn dlarrc;
    struct flexiblas_blasfn dlarrd;
    struct flexiblas_blasfn dlarre;
    struct flexiblas_blasfn dlarrf;
    struct flexiblas_blasfn dlarrj;
    struct flexiblas_blasfn dlarrk;
    struct flexiblas_blasfn dlarrr;
    struct flexiblas_blasfn dlarrv;
    struct flexiblas_blasfn dlartg;
    struct flexiblas_blasfn dlartgp;
    struct flexiblas_blasfn dlartgs;
    struct flexiblas_blasfn dlartv;
    struct flexiblas_blasfn dlaruv;
    struct flexiblas_blasfn dlarz;
    struct flexiblas_blasfn dlarzb;
    struct flexiblas_blasfn dlarzt;
    struct flexiblas_blasfn dlas2;
    struct flexiblas_blasfn dlascl;
    struct flexiblas_blasfn dlasd0;
    struct flexiblas_blasfn dlasd1;
    struct flexiblas_blasfn dlasd2;
    struct flexiblas_blasfn dlasd3;
    struct flexiblas_blasfn dlasd4;
    struct flexiblas_blasfn dlasd5;
    struct flexiblas_blasfn dlasd6;
    struct flexiblas_blasfn dlasd7;
    struct flexiblas_blasfn dlasd8;
    struct flexiblas_blasfn dlasda;
    struct flexiblas_blasfn dlasdq;
    struct flexiblas_blasfn dlasdt;
    struct flexiblas_blasfn dlaset;
    struct flexiblas_blasfn dlasq1;
    struct flexiblas_blasfn dlasq2;
    struct flexiblas_blasfn dlasq3;
    struct flexiblas_blasfn dlasq4;
    struct flexiblas_blasfn dlasq5;
    struct flexiblas_blasfn dlasq6;
    struct flexiblas_blasfn dlasr;
    struct flexiblas_blasfn dlasrt;
    struct flexiblas_blasfn dlassq;
    struct flexiblas_blasfn dlasv2;
    struct flexiblas_blasfn dlaswp;
    struct flexiblas_blasfn dlasy2;
    struct flexiblas_blasfn dlasyf;
    struct flexiblas_blasfn dlat2s;
    struct flexiblas_blasfn dlatbs;
    struct flexiblas_blasfn dlatdf;
    struct flexiblas_blasfn dlatps;
    struct flexiblas_blasfn dlatrd;
    struct flexiblas_blasfn dlatrs;
    struct flexiblas_blasfn dlatrz;
    struct flexiblas_blasfn dlatzm;
    struct flexiblas_blasfn dlauu2;
    struct flexiblas_blasfn dlauum;
    struct flexiblas_blasfn dopgtr;
    struct flexiblas_blasfn dopmtr;
    struct flexiblas_blasfn dorbdb;
    struct flexiblas_blasfn dorcsd;
    struct flexiblas_blasfn dorg2l;
    struct flexiblas_blasfn dorg2r;
    struct flexiblas_blasfn dorgbr;
    struct flexiblas_blasfn dorghr;
    struct flexiblas_blasfn dorgl2;
    struct flexiblas_blasfn dorglq;
    struct flexiblas_blasfn dorgql;
    struct flexiblas_blasfn dorgqr;
    struct flexiblas_blasfn dorgr2;
    struct flexiblas_blasfn dorgrq;
    struct flexiblas_blasfn dorgtr;
    struct flexiblas_blasfn dorm2l;
    struct flexiblas_blasfn dorm2r;
    struct flexiblas_blasfn dormbr;
    struct flexiblas_blasfn dormhr;
    struct flexiblas_blasfn dorml2;
    struct flexiblas_blasfn dormlq;
    struct flexiblas_blasfn dormql;
    struct flexiblas_blasfn dormqr;
    struct flexiblas_blasfn dormr2;
    struct flexiblas_blasfn dormr3;
    struct flexiblas_blasfn dormrq;
    struct flexiblas_blasfn dormrz;
    struct flexiblas_blasfn dormtr;
    struct flexiblas_blasfn dpbcon;
    struct flexiblas_blasfn dpbequ;
    struct flexiblas_blasfn dpbrfs;
    struct flexiblas_blasfn dpbstf;
    struct flexiblas_blasfn dpbsv;
    struct flexiblas_blasfn dpbsvx;
    struct flexiblas_blasfn dpbtf2;
    struct flexiblas_blasfn dpbtrf;
    struct flexiblas_blasfn dpbtrs;
    struct flexiblas_blasfn dpftrf;
    struct flexiblas_blasfn dpftri;
    struct flexiblas_blasfn dpftrs;
    struct flexiblas_blasfn dpocon;
    struct flexiblas_blasfn dpoequ;
    struct flexiblas_blasfn dpoequb;
    struct flexiblas_blasfn dporfs;
    struct flexiblas_blasfn dposv;
    struct flexiblas_blasfn dposvx;
    struct flexiblas_blasfn dpotf2;
    struct flexiblas_blasfn dpotrf;
    struct flexiblas_blasfn dpotri;
    struct flexiblas_blasfn dpotrs;
    struct flexiblas_blasfn dppcon;
    struct flexiblas_blasfn dppequ;
    struct flexiblas_blasfn dpprfs;
    struct flexiblas_blasfn dppsv;
    struct flexiblas_blasfn dppsvx;
    struct flexiblas_blasfn dpptrf;
    struct flexiblas_blasfn dpptri;
    struct flexiblas_blasfn dpptrs;
    struct flexiblas_blasfn dpstf2;
    struct flexiblas_blasfn dpstrf;
    struct flexiblas_blasfn dptcon;
    struct flexiblas_blasfn dpteqr;
    struct flexiblas_blasfn dptrfs;
    struct flexiblas_blasfn dptsv;
    struct flexiblas_blasfn dptsvx;
    struct flexiblas_blasfn dpttrf;
    struct flexiblas_blasfn dpttrs;
    struct flexiblas_blasfn dptts2;
    struct flexiblas_blasfn drscl;
    struct flexiblas_blasfn dsbev;
    struct flexiblas_blasfn dsbevd;
    struct flexiblas_blasfn dsbevx;
    struct flexiblas_blasfn dsbgst;
    struct flexiblas_blasfn dsbgv;
    struct flexiblas_blasfn dsbgvd;
    struct flexiblas_blasfn dsbgvx;
    struct flexiblas_blasfn dsbtrd;
    struct flexiblas_blasfn dsecnd;
    struct flexiblas_blasfn dsfrk;
    struct flexiblas_blasfn dsgesv;
    struct flexiblas_blasfn dspcon;
    struct flexiblas_blasfn dspev;
    struct flexiblas_blasfn dspevd;
    struct flexiblas_blasfn dspevx;
    struct flexiblas_blasfn dspgst;
    struct flexiblas_blasfn dspgv;
    struct flexiblas_blasfn dspgvd;
    struct flexiblas_blasfn dspgvx;
    struct flexiblas_blasfn dsposv;
    struct flexiblas_blasfn dsprfs;
    struct flexiblas_blasfn dspsv;
    struct flexiblas_blasfn dspsvx;
    struct flexiblas_blasfn dsptrd;
    struct flexiblas_blasfn dsptrf;
    struct flexiblas_blasfn dsptri;
    struct flexiblas_blasfn dsptrs;
    struct flexiblas_blasfn dstebz;
    struct flexiblas_blasfn dstedc;
    struct flexiblas_blasfn dstegr;
    struct flexiblas_blasfn dstein;
    struct flexiblas_blasfn dstemr;
    struct flexiblas_blasfn dsteqr;
    struct flexiblas_blasfn dsterf;
    struct flexiblas_blasfn dstev;
    struct flexiblas_blasfn dstevd;
    struct flexiblas_blasfn dstevr;
    struct flexiblas_blasfn dstevx;
    struct flexiblas_blasfn dsycon;
    struct flexiblas_blasfn dsyconv;
    struct flexiblas_blasfn dsyequb;
    struct flexiblas_blasfn dsyev;
    struct flexiblas_blasfn dsyevd;
    struct flexiblas_blasfn dsyevr;
    struct flexiblas_blasfn dsyevx;
    struct flexiblas_blasfn dsygs2;
    struct flexiblas_blasfn dsygst;
    struct flexiblas_blasfn dsygv;
    struct flexiblas_blasfn dsygvd;
    struct flexiblas_blasfn dsygvx;
    struct flexiblas_blasfn dsyrfs;
    struct flexiblas_blasfn dsysv;
    struct flexiblas_blasfn dsysvx;
    struct flexiblas_blasfn dsyswapr;
    struct flexiblas_blasfn dsytd2;
    struct flexiblas_blasfn dsytf2;
    struct flexiblas_blasfn dsytrd;
    struct flexiblas_blasfn dsytrf;
    struct flexiblas_blasfn dsytri;
    struct flexiblas_blasfn dsytri2;
    struct flexiblas_blasfn dsytri2x;
    struct flexiblas_blasfn dsytrs;
    struct flexiblas_blasfn dsytrs2;
    struct flexiblas_blasfn dtbcon;
    struct flexiblas_blasfn dtbrfs;
    struct flexiblas_blasfn dtbtrs;
    struct flexiblas_blasfn dtfsm;
    struct flexiblas_blasfn dtftri;
    struct flexiblas_blasfn dtfttp;
    struct flexiblas_blasfn dtfttr;
    struct flexiblas_blasfn dtgevc;
    struct flexiblas_blasfn dtgex2;
    struct flexiblas_blasfn dtgexc;
    struct flexiblas_blasfn dtgsen;
    struct flexiblas_blasfn dtgsja;
    struct flexiblas_blasfn dtgsna;
    struct flexiblas_blasfn dtgsy2;
    struct flexiblas_blasfn dtgsyl;
    struct flexiblas_blasfn dtpcon;
    struct flexiblas_blasfn dtprfs;
    struct flexiblas_blasfn dtptri;
    struct flexiblas_blasfn dtptrs;
    struct flexiblas_blasfn dtpttf;
    struct flexiblas_blasfn dtpttr;
    struct flexiblas_blasfn dtrcon;
    struct flexiblas_blasfn dtrevc;
    struct flexiblas_blasfn dtrexc;
    struct flexiblas_blasfn dtrrfs;
    struct flexiblas_blasfn dtrsen;
    struct flexiblas_blasfn dtrsna;
    struct flexiblas_blasfn dtrsyl;
    struct flexiblas_blasfn dtrti2;
    struct flexiblas_blasfn dtrtri;
    struct flexiblas_blasfn dtrtrs;
    struct flexiblas_blasfn dtrttf;
    struct flexiblas_blasfn dtrttp;
    struct flexiblas_blasfn dtzrqf;
    struct flexiblas_blasfn dtzrzf;
    struct flexiblas_blasfn dzsum1;
    struct flexiblas_blasfn icmax1;
    struct flexiblas_blasfn ieeeck;
    struct flexiblas_blasfn ilaclc;
    struct flexiblas_blasfn ilaclr;
    struct flexiblas_blasfn iladiag;
    struct flexiblas_blasfn iladlc;
    struct flexiblas_blasfn iladlr;
    struct flexiblas_blasfn ilaenv;
    struct flexiblas_blasfn ilaprec;
    struct flexiblas_blasfn ilaslc;
    struct flexiblas_blasfn ilaslr;
    struct flexiblas_blasfn ilatrans;
    struct flexiblas_blasfn ilauplo;
    struct flexiblas_blasfn ilazlc;
    struct flexiblas_blasfn ilazlr;
    struct flexiblas_blasfn iparmq;
    struct flexiblas_blasfn izmax1;
    struct flexiblas_blasfn sbbcsd;
    struct flexiblas_blasfn sbdsdc;
    struct flexiblas_blasfn sbdsqr;
    struct flexiblas_blasfn scsum1;
    struct flexiblas_blasfn sdisna;
    struct flexiblas_blasfn second;
    struct flexiblas_blasfn sgbbrd;
    struct flexiblas_blasfn sgbcon;
    struct flexiblas_blasfn sgbequ;
    struct flexiblas_blasfn sgbequb;
    struct flexiblas_blasfn sgbrfs;
    struct flexiblas_blasfn sgbsv;
    struct flexiblas_blasfn sgbsvx;
    struct flexiblas_blasfn sgbtf2;
    struct flexiblas_blasfn sgbtrf;
    struct flexiblas_blasfn sgbtrs;
    struct flexiblas_blasfn sgebak;
    struct flexiblas_blasfn sgebal;
    struct flexiblas_blasfn sgebd2;
    struct flexiblas_blasfn sgebrd;
    struct flexiblas_blasfn sgecon;
    struct flexiblas_blasfn sgeequ;
    struct flexiblas_blasfn sgeequb;
    struct flexiblas_blasfn sgees;
    struct flexiblas_blasfn sgeesx;
    struct flexiblas_blasfn sgeev;
    struct flexiblas_blasfn sgeevx;
    struct flexiblas_blasfn sgegs;
    struct flexiblas_blasfn sgegv;
    struct flexiblas_blasfn sgehd2;
    struct flexiblas_blasfn sgehrd;
    struct flexiblas_blasfn sgejsv;
    struct flexiblas_blasfn sgelq2;
    struct flexiblas_blasfn sgelqf;
    struct flexiblas_blasfn sgels;
    struct flexiblas_blasfn sgelsd;
    struct flexiblas_blasfn sgelss;
    struct flexiblas_blasfn sgelsx;
    struct flexiblas_blasfn sgelsy;
    struct flexiblas_blasfn sgeql2;
    struct flexiblas_blasfn sgeqlf;
    struct flexiblas_blasfn sgeqp3;
    struct flexiblas_blasfn sgeqpf;
    struct flexiblas_blasfn sgeqr2;
    struct flexiblas_blasfn sgeqr2p;
    struct flexiblas_blasfn sgeqrf;
    struct flexiblas_blasfn sgeqrfp;
    struct flexiblas_blasfn sgerfs;
    struct flexiblas_blasfn sgerq2;
    struct flexiblas_blasfn sgerqf;
    struct flexiblas_blasfn sgesc2;
    struct flexiblas_blasfn sgesdd;
    struct flexiblas_blasfn sgesv;
    struct flexiblas_blasfn sgesvd;
    struct flexiblas_blasfn sgesvj;
    struct flexiblas_blasfn sgesvx;
    struct flexiblas_blasfn sgetc2;
    struct flexiblas_blasfn sgetf2;
    struct flexiblas_blasfn sgetrf;
    struct flexiblas_blasfn sgetri;
    struct flexiblas_blasfn sgetrs;
    struct flexiblas_blasfn sggbak;
    struct flexiblas_blasfn sggbal;
    struct flexiblas_blasfn sgges;
    struct flexiblas_blasfn sggesx;
    struct flexiblas_blasfn sggev;
    struct flexiblas_blasfn sggevx;
    struct flexiblas_blasfn sggglm;
    struct flexiblas_blasfn sgghrd;
    struct flexiblas_blasfn sgglse;
    struct flexiblas_blasfn sggqrf;
    struct flexiblas_blasfn sggrqf;
    struct flexiblas_blasfn sggsvd;
    struct flexiblas_blasfn sggsvp;
    struct flexiblas_blasfn sgsvj0;
    struct flexiblas_blasfn sgsvj1;
    struct flexiblas_blasfn sgtcon;
    struct flexiblas_blasfn sgtrfs;
    struct flexiblas_blasfn sgtsv;
    struct flexiblas_blasfn sgtsvx;
    struct flexiblas_blasfn sgttrf;
    struct flexiblas_blasfn sgttrs;
    struct flexiblas_blasfn sgtts2;
    struct flexiblas_blasfn shgeqz;
    struct flexiblas_blasfn shsein;
    struct flexiblas_blasfn shseqr;
    struct flexiblas_blasfn sisnan;
    struct flexiblas_blasfn slabad;
    struct flexiblas_blasfn slabrd;
    struct flexiblas_blasfn slacn2;
    struct flexiblas_blasfn slacon;
    struct flexiblas_blasfn slacpy;
    struct flexiblas_blasfn sladiv;
    struct flexiblas_blasfn slae2;
    struct flexiblas_blasfn slaebz;
    struct flexiblas_blasfn slaed0;
    struct flexiblas_blasfn slaed1;
    struct flexiblas_blasfn slaed2;
    struct flexiblas_blasfn slaed3;
    struct flexiblas_blasfn slaed4;
    struct flexiblas_blasfn slaed5;
    struct flexiblas_blasfn slaed6;
    struct flexiblas_blasfn slaed7;
    struct flexiblas_blasfn slaed8;
    struct flexiblas_blasfn slaed9;
    struct flexiblas_blasfn slaeda;
    struct flexiblas_blasfn slaein;
    struct flexiblas_blasfn slaev2;
    struct flexiblas_blasfn slaexc;
    struct flexiblas_blasfn slag2;
    struct flexiblas_blasfn slag2d;
    struct flexiblas_blasfn slags2;
    struct flexiblas_blasfn slagtf;
    struct flexiblas_blasfn slagtm;
    struct flexiblas_blasfn slagts;
    struct flexiblas_blasfn slagv2;
    struct flexiblas_blasfn slahqr;
    struct flexiblas_blasfn slahr2;
    struct flexiblas_blasfn slahrd;
    struct flexiblas_blasfn slaic1;
    struct flexiblas_blasfn slaisnan;
    struct flexiblas_blasfn slaln2;
    struct flexiblas_blasfn slals0;
    struct flexiblas_blasfn slalsa;
    struct flexiblas_blasfn slalsd;
    struct flexiblas_blasfn slamc3;
    struct flexiblas_blasfn slamch;
    struct flexiblas_blasfn slamrg;
    struct flexiblas_blasfn slaneg;
    struct flexiblas_blasfn slangb;
    struct flexiblas_blasfn slange;
    struct flexiblas_blasfn slangt;
    struct flexiblas_blasfn slanhs;
    struct flexiblas_blasfn slansb;
    struct flexiblas_blasfn slansf;
    struct flexiblas_blasfn slansp;
    struct flexiblas_blasfn slanst;
    struct flexiblas_blasfn slansy;
    struct flexiblas_blasfn slantb;
    struct flexiblas_blasfn slantp;
    struct flexiblas_blasfn slantr;
    struct flexiblas_blasfn slanv2;
    struct flexiblas_blasfn slapll;
    struct flexiblas_blasfn slapmr;
    struct flexiblas_blasfn slapmt;
    struct flexiblas_blasfn slapy2;
    struct flexiblas_blasfn slapy3;
    struct flexiblas_blasfn slaqgb;
    struct flexiblas_blasfn slaqge;
    struct flexiblas_blasfn slaqp2;
    struct flexiblas_blasfn slaqps;
    struct flexiblas_blasfn slaqr0;
    struct flexiblas_blasfn slaqr1;
    struct flexiblas_blasfn slaqr2;
    struct flexiblas_blasfn slaqr3;
    struct flexiblas_blasfn slaqr4;
    struct flexiblas_blasfn slaqr5;
    struct flexiblas_blasfn slaqsb;
    struct flexiblas_blasfn slaqsp;
    struct flexiblas_blasfn slaqsy;
    struct flexiblas_blasfn slaqtr;
    struct flexiblas_blasfn slar1v;
    struct flexiblas_blasfn slar2v;
    struct flexiblas_blasfn slarf;
    struct flexiblas_blasfn slarfb;
    struct flexiblas_blasfn slarfg;
    struct flexiblas_blasfn slarfgp;
    struct flexiblas_blasfn slarft;
    struct flexiblas_blasfn slarfx;
    struct flexiblas_blasfn slargv;
    struct flexiblas_blasfn slarnv;
    struct flexiblas_blasfn slarra;
    struct flexiblas_blasfn slarrb;
    struct flexiblas_blasfn slarrc;
    struct flexiblas_blasfn slarrd;
    struct flexiblas_blasfn slarre;
    struct flexiblas_blasfn slarrf;
    struct flexiblas_blasfn slarrj;
    struct flexiblas_blasfn slarrk;
    struct flexiblas_blasfn slarrr;
    struct flexiblas_blasfn slarrv;
    struct flexiblas_blasfn slartg;
    struct flexiblas_blasfn slartgp;
    struct flexiblas_blasfn slartgs;
    struct flexiblas_blasfn slartv;
    struct flexiblas_blasfn slaruv;
    struct flexiblas_blasfn slarz;
    struct flexiblas_blasfn slarzb;
    struct flexiblas_blasfn slarzt;
    struct flexiblas_blasfn slas2;
    struct flexiblas_blasfn slascl;
    struct flexiblas_blasfn slasd0;
    struct flexiblas_blasfn slasd1;
    struct flexiblas_blasfn slasd2;
    struct flexiblas_blasfn slasd3;
    struct flexiblas_blasfn slasd4;
    struct flexiblas_blasfn slasd5;
    struct flexiblas_blasfn slasd6;
    struct flexiblas_blasfn slasd7;
    struct flexiblas_blasfn slasd8;
    struct flexiblas_blasfn slasda;
    struct flexiblas_blasfn slasdq;
    struct flexiblas_blasfn slasdt;
    struct flexiblas_blasfn slaset;
    struct flexiblas_blasfn slasq1;
    struct flexiblas_blasfn slasq2;
    struct flexiblas_blasfn slasq3;
    struct flexiblas_blasfn slasq4;
    struct flexiblas_blasfn slasq5;
    struct flexiblas_blasfn slasq6;
    struct flexiblas_blasfn slasr;
    struct flexiblas_blasfn slasrt;
    struct flexiblas_blasfn slassq;
    struct flexiblas_blasfn slasv2;
    struct flexiblas_blasfn slaswp;
    struct flexiblas_blasfn slasy2;
    struct flexiblas_blasfn slasyf;
    struct flexiblas_blasfn slatbs;
    struct flexiblas_blasfn slatdf;
    struct flexiblas_blasfn slatps;
    struct flexiblas_blasfn slatrd;
    struct flexiblas_blasfn slatrs;
    struct flexiblas_blasfn slatrz;
    struct flexiblas_blasfn slatzm;
    struct flexiblas_blasfn slauu2;
    struct flexiblas_blasfn slauum;
    struct flexiblas_blasfn sopgtr;
    struct flexiblas_blasfn sopmtr;
    struct flexiblas_blasfn sorbdb;
    struct flexiblas_blasfn sorcsd;
    struct flexiblas_blasfn sorg2l;
    struct flexiblas_blasfn sorg2r;
    struct flexiblas_blasfn sorgbr;
    struct flexiblas_blasfn sorghr;
    struct flexiblas_blasfn sorgl2;
    struct flexiblas_blasfn sorglq;
    struct flexiblas_blasfn sorgql;
    struct flexiblas_blasfn sorgqr;
    struct flexiblas_blasfn sorgr2;
    struct flexiblas_blasfn sorgrq;
    struct flexiblas_blasfn sorgtr;
    struct flexiblas_blasfn sorm2l;
    struct flexiblas_blasfn sorm2r;
    struct flexiblas_blasfn sormbr;
    struct flexiblas_blasfn sormhr;
    struct flexiblas_blasfn sorml2;
    struct flexiblas_blasfn sormlq;
    struct flexiblas_blasfn sormql;
    struct flexiblas_blasfn sormqr;
    struct flexiblas_blasfn sormr2;
    struct flexiblas_blasfn sormr3;
    struct flexiblas_blasfn sormrq;
    struct flexiblas_blasfn sormrz;
    struct flexiblas_blasfn sormtr;
    struct flexiblas_blasfn spbcon;
    struct flexiblas_blasfn spbequ;
    struct flexiblas_blasfn spbrfs;
    struct flexiblas_blasfn spbstf;
    struct flexiblas_blasfn spbsv;
    struct flexiblas_blasfn spbsvx;
    struct flexiblas_blasfn spbtf2;
    struct flexiblas_blasfn spbtrf;
    struct flexiblas_blasfn spbtrs;
    struct flexiblas_blasfn spftrf;
    struct flexiblas_blasfn spftri;
    struct flexiblas_blasfn spftrs;
    struct flexiblas_blasfn spocon;
    struct flexiblas_blasfn spoequ;
    struct flexiblas_blasfn spoequb;
    struct flexiblas_blasfn sporfs;
    struct flexiblas_blasfn sposv;
    struct flexiblas_blasfn sposvx;
    struct flexiblas_blasfn spotf2;
    struct flexiblas_blasfn spotrf;
    struct flexiblas_blasfn spotri;
    struct flexiblas_blasfn spotrs;
    struct flexiblas_blasfn sppcon;
    struct flexiblas_blasfn sppequ;
    struct flexiblas_blasfn spprfs;
    struct flexiblas_blasfn sppsv;
    struct flexiblas_blasfn sppsvx;
    struct flexiblas_blasfn spptrf;
    struct flexiblas_blasfn spptri;
    struct flexiblas_blasfn spptrs;
    struct flexiblas_blasfn spstf2;
    struct flexiblas_blasfn spstrf;
    struct flexiblas_blasfn sptcon;
    struct flexiblas_blasfn spteqr;
    struct flexiblas_blasfn sptrfs;
    struct flexiblas_blasfn sptsv;
    struct flexiblas_blasfn sptsvx;
    struct flexiblas_blasfn spttrf;
    struct flexiblas_blasfn spttrs;
    struct flexiblas_blasfn sptts2;
    struct flexiblas_blasfn srscl;
    struct flexiblas_blasfn ssbev;
    struct flexiblas_blasfn ssbevd;
    struct flexiblas_blasfn ssbevx;
    struct flexiblas_blasfn ssbgst;
    struct flexiblas_blasfn ssbgv;
    struct flexiblas_blasfn ssbgvd;
    struct flexiblas_blasfn ssbgvx;
    struct flexiblas_blasfn ssbtrd;
    struct flexiblas_blasfn ssfrk;
    struct flexiblas_blasfn sspcon;
    struct flexiblas_blasfn sspev;
    struct flexiblas_blasfn sspevd;
    struct flexiblas_blasfn sspevx;
    struct flexiblas_blasfn sspgst;
    struct flexiblas_blasfn sspgv;
    struct flexiblas_blasfn sspgvd;
    struct flexiblas_blasfn sspgvx;
    struct flexiblas_blasfn ssprfs;
    struct flexiblas_blasfn sspsv;
    struct flexiblas_blasfn sspsvx;
    struct flexiblas_blasfn ssptrd;
    struct flexiblas_blasfn ssptrf;
    struct flexiblas_blasfn ssptri;
    struct flexiblas_blasfn ssptrs;
    struct flexiblas_blasfn sstebz;
    struct flexiblas_blasfn sstedc;
    struct flexiblas_blasfn sstegr;
    struct flexiblas_blasfn sstein;
    struct flexiblas_blasfn sstemr;
    struct flexiblas_blasfn ssteqr;
    struct flexiblas_blasfn ssterf;
    struct flexiblas_blasfn sstev;
    struct flexiblas_blasfn sstevd;
    struct flexiblas_blasfn sstevr;
    struct flexiblas_blasfn sstevx;
    struct flexiblas_blasfn ssycon;
    struct flexiblas_blasfn ssyconv;
    struct flexiblas_blasfn ssyequb;
    struct flexiblas_blasfn ssyev;
    struct flexiblas_blasfn ssyevd;
    struct flexiblas_blasfn ssyevr;
    struct flexiblas_blasfn ssyevx;
    struct flexiblas_blasfn ssygs2;
    struct flexiblas_blasfn ssygst;
    struct flexiblas_blasfn ssygv;
    struct flexiblas_blasfn ssygvd;
    struct flexiblas_blasfn ssygvx;
    struct flexiblas_blasfn ssyrfs;
    struct flexiblas_blasfn ssysv;
    struct flexiblas_blasfn ssysvx;
    struct flexiblas_blasfn ssyswapr;
    struct flexiblas_blasfn ssytd2;
    struct flexiblas_blasfn ssytf2;
    struct flexiblas_blasfn ssytrd;
    struct flexiblas_blasfn ssytrf;
    struct flexiblas_blasfn ssytri;
    struct flexiblas_blasfn ssytri2;
    struct flexiblas_blasfn ssytri2x;
    struct flexiblas_blasfn ssytrs;
    struct flexiblas_blasfn ssytrs2;
    struct flexiblas_blasfn stbcon;
    struct flexiblas_blasfn stbrfs;
    struct flexiblas_blasfn stbtrs;
    struct flexiblas_blasfn stfsm;
    struct flexiblas_blasfn stftri;
    struct flexiblas_blasfn stfttp;
    struct flexiblas_blasfn stfttr;
    struct flexiblas_blasfn stgevc;
    struct flexiblas_blasfn stgex2;
    struct flexiblas_blasfn stgexc;
    struct flexiblas_blasfn stgsen;
    struct flexiblas_blasfn stgsja;
    struct flexiblas_blasfn stgsna;
    struct flexiblas_blasfn stgsy2;
    struct flexiblas_blasfn stgsyl;
    struct flexiblas_blasfn stpcon;
    struct flexiblas_blasfn stprfs;
    struct flexiblas_blasfn stptri;
    struct flexiblas_blasfn stptrs;
    struct flexiblas_blasfn stpttf;
    struct flexiblas_blasfn stpttr;
    struct flexiblas_blasfn strcon;
    struct flexiblas_blasfn strevc;
    struct flexiblas_blasfn strexc;
    struct flexiblas_blasfn strrfs;
    struct flexiblas_blasfn strsen;
    struct flexiblas_blasfn strsna;
    struct flexiblas_blasfn strsyl;
    struct flexiblas_blasfn strti2;
    struct flexiblas_blasfn strtri;
    struct flexiblas_blasfn strtrs;
    struct flexiblas_blasfn strttf;
    struct flexiblas_blasfn strttp;
    struct flexiblas_blasfn stzrqf;
    struct flexiblas_blasfn stzrzf;
    struct flexiblas_blasfn xerbla_array;
    struct flexiblas_blasfn zbbcsd;
    struct flexiblas_blasfn zbdsqr;
    struct flexiblas_blasfn zcgesv;
    struct flexiblas_blasfn zcposv;
    struct flexiblas_blasfn zdrscl;
    struct flexiblas_blasfn zgbbrd;
    struct flexiblas_blasfn zgbcon;
    struct flexiblas_blasfn zgbequ;
    struct flexiblas_blasfn zgbequb;
    struct flexiblas_blasfn zgbrfs;
    struct flexiblas_blasfn zgbsv;
    struct flexiblas_blasfn zgbsvx;
    struct flexiblas_blasfn zgbtf2;
    struct flexiblas_blasfn zgbtrf;
    struct flexiblas_blasfn zgbtrs;
    struct flexiblas_blasfn zgebak;
    struct flexiblas_blasfn zgebal;
    struct flexiblas_blasfn zgebd2;
    struct flexiblas_blasfn zgebrd;
    struct flexiblas_blasfn zgecon;
    struct flexiblas_blasfn zgeequ;
    struct flexiblas_blasfn zgeequb;
    struct flexiblas_blasfn zgees;
    struct flexiblas_blasfn zgeesx;
    struct flexiblas_blasfn zgeev;
    struct flexiblas_blasfn zgeevx;
    struct flexiblas_blasfn zgegs;
    struct flexiblas_blasfn zgegv;
    struct flexiblas_blasfn zgehd2;
    struct flexiblas_blasfn zgehrd;
    struct flexiblas_blasfn zgelq2;
    struct flexiblas_blasfn zgelqf;
    struct flexiblas_blasfn zgels;
    struct flexiblas_blasfn zgelsd;
    struct flexiblas_blasfn zgelss;
    struct flexiblas_blasfn zgelsx;
    struct flexiblas_blasfn zgelsy;
    struct flexiblas_blasfn zgeql2;
    struct flexiblas_blasfn zgeqlf;
    struct flexiblas_blasfn zgeqp3;
    struct flexiblas_blasfn zgeqpf;
    struct flexiblas_blasfn zgeqr2;
    struct flexiblas_blasfn zgeqr2p;
    struct flexiblas_blasfn zgeqrf;
    struct flexiblas_blasfn zgeqrfp;
    struct flexiblas_blasfn zgerfs;
    struct flexiblas_blasfn zgerq2;
    struct flexiblas_blasfn zgerqf;
    struct flexiblas_blasfn zgesc2;
    struct flexiblas_blasfn zgesdd;
    struct flexiblas_blasfn zgesv;
    struct flexiblas_blasfn zgesvd;
    struct flexiblas_blasfn zgesvx;
    struct flexiblas_blasfn zgetc2;
    struct flexiblas_blasfn zgetf2;
    struct flexiblas_blasfn zgetrf;
    struct flexiblas_blasfn zgetri;
    struct flexiblas_blasfn zgetrs;
    struct flexiblas_blasfn zggbak;
    struct flexiblas_blasfn zggbal;
    struct flexiblas_blasfn zgges;
    struct flexiblas_blasfn zggesx;
    struct flexiblas_blasfn zggev;
    struct flexiblas_blasfn zggevx;
    struct flexiblas_blasfn zggglm;
    struct flexiblas_blasfn zgghrd;
    struct flexiblas_blasfn zgglse;
    struct flexiblas_blasfn zggqrf;
    struct flexiblas_blasfn zggrqf;
    struct flexiblas_blasfn zggsvd;
    struct flexiblas_blasfn zggsvp;
    struct flexiblas_blasfn zgtcon;
    struct flexiblas_blasfn zgtrfs;
    struct flexiblas_blasfn zgtsv;
    struct flexiblas_blasfn zgtsvx;
    struct flexiblas_blasfn zgttrf;
    struct flexiblas_blasfn zgttrs;
    struct flexiblas_blasfn zgtts2;
    struct flexiblas_blasfn zhbev;
    struct flexiblas_blasfn zhbevd;
    struct flexiblas_blasfn zhbevx;
    struct flexiblas_blasfn zhbgst;
    struct flexiblas_blasfn zhbgv;
    struct flexiblas_blasfn zhbgvd;
    struct flexiblas_blasfn zhbgvx;
    struct flexiblas_blasfn zhbtrd;
    struct flexiblas_blasfn zhecon;
    struct flexiblas_blasfn zheequb;
    struct flexiblas_blasfn zheev;
    struct flexiblas_blasfn zheevd;
    struct flexiblas_blasfn zheevr;
    struct flexiblas_blasfn zheevx;
    struct flexiblas_blasfn zhegs2;
    struct flexiblas_blasfn zhegst;
    struct flexiblas_blasfn zhegv;
    struct flexiblas_blasfn zhegvd;
    struct flexiblas_blasfn zhegvx;
    struct flexiblas_blasfn zherfs;
    struct flexiblas_blasfn zhesv;
    struct flexiblas_blasfn zhesvx;
    struct flexiblas_blasfn zheswapr;
    struct flexiblas_blasfn zhetd2;
    struct flexiblas_blasfn zhetf2;
    struct flexiblas_blasfn zhetrd;
    struct flexiblas_blasfn zhetrf;
    struct flexiblas_blasfn zhetri;
    struct flexiblas_blasfn zhetri2;
    struct flexiblas_blasfn zhetri2x;
    struct flexiblas_blasfn zhetrs;
    struct flexiblas_blasfn zhetrs2;
    struct flexiblas_blasfn zhfrk;
    struct flexiblas_blasfn zhgeqz;
    struct flexiblas_blasfn zhpcon;
    struct flexiblas_blasfn zhpev;
    struct flexiblas_blasfn zhpevd;
    struct flexiblas_blasfn zhpevx;
    struct flexiblas_blasfn zhpgst;
    struct flexiblas_blasfn zhpgv;
    struct flexiblas_blasfn zhpgvd;
    struct flexiblas_blasfn zhpgvx;
    struct flexiblas_blasfn zhprfs;
    struct flexiblas_blasfn zhpsv;
    struct flexiblas_blasfn zhpsvx;
    struct flexiblas_blasfn zhptrd;
    struct flexiblas_blasfn zhptrf;
    struct flexiblas_blasfn zhptri;
    struct flexiblas_blasfn zhptrs;
    struct flexiblas_blasfn zhsein;
    struct flexiblas_blasfn zhseqr;
    struct flexiblas_blasfn zlabrd;
    struct flexiblas_blasfn zlacgv;
    struct flexiblas_blasfn zlacn2;
    struct flexiblas_blasfn zlacon;
    struct flexiblas_blasfn zlacp2;
    struct flexiblas_blasfn zlacpy;
    struct flexiblas_blasfn zlacrm;
    struct flexiblas_blasfn zlacrt;
    struct flexiblas_blasfn zladiv;
    struct flexiblas_blasfn zlaed0;
    struct flexiblas_blasfn zlaed7;
    struct flexiblas_blasfn zlaed8;
    struct flexiblas_blasfn zlaein;
    struct flexiblas_blasfn zlaesy;
    struct flexiblas_blasfn zlaev2;
    struct flexiblas_blasfn zlag2c;
    struct flexiblas_blasfn zlags2;
    struct flexiblas_blasfn zlagtm;
    struct flexiblas_blasfn zlahef;
    struct flexiblas_blasfn zlahqr;
    struct flexiblas_blasfn zlahr2;
    struct flexiblas_blasfn zlahrd;
    struct flexiblas_blasfn zlaic1;
    struct flexiblas_blasfn zlals0;
    struct flexiblas_blasfn zlalsa;
    struct flexiblas_blasfn zlalsd;
    struct flexiblas_blasfn zlangb;
    struct flexiblas_blasfn zlange;
    struct flexiblas_blasfn zlangt;
    struct flexiblas_blasfn zlanhb;
    struct flexiblas_blasfn zlanhe;
    struct flexiblas_blasfn zlanhf;
    struct flexiblas_blasfn zlanhp;
    struct flexiblas_blasfn zlanhs;
    struct flexiblas_blasfn zlanht;
    struct flexiblas_blasfn zlansb;
    struct flexiblas_blasfn zlansp;
    struct flexiblas_blasfn zlansy;
    struct flexiblas_blasfn zlantb;
    struct flexiblas_blasfn zlantp;
    struct flexiblas_blasfn zlantr;
    struct flexiblas_blasfn zlapll;
    struct flexiblas_blasfn zlapmr;
    struct flexiblas_blasfn zlapmt;
    struct flexiblas_blasfn zlaqgb;
    struct flexiblas_blasfn zlaqge;
    struct flexiblas_blasfn zlaqhb;
    struct flexiblas_blasfn zlaqhe;
    struct flexiblas_blasfn zlaqhp;
    struct flexiblas_blasfn zlaqp2;
    struct flexiblas_blasfn zlaqps;
    struct flexiblas_blasfn zlaqr0;
    struct flexiblas_blasfn zlaqr1;
    struct flexiblas_blasfn zlaqr2;
    struct flexiblas_blasfn zlaqr3;
    struct flexiblas_blasfn zlaqr4;
    struct flexiblas_blasfn zlaqr5;
    struct flexiblas_blasfn zlaqsb;
    struct flexiblas_blasfn zlaqsp;
    struct flexiblas_blasfn zlaqsy;
    struct flexiblas_blasfn zlar1v;
    struct flexiblas_blasfn zlar2v;
    struct flexiblas_blasfn zlarcm;
    struct flexiblas_blasfn zlarf;
    struct flexiblas_blasfn zlarfb;
    struct flexiblas_blasfn zlarfg;
    struct flexiblas_blasfn zlarfgp;
    struct flexiblas_blasfn zlarft;
    struct flexiblas_blasfn zlarfx;
    struct flexiblas_blasfn zlargv;
    struct flexiblas_blasfn zlarnv;
    struct flexiblas_blasfn zlarrv;
    struct flexiblas_blasfn zlartg;
    struct flexiblas_blasfn zlartv;
    struct flexiblas_blasfn zlarz;
    struct flexiblas_blasfn zlarzb;
    struct flexiblas_blasfn zlarzt;
    struct flexiblas_blasfn zlascl;
    struct flexiblas_blasfn zlaset;
    struct flexiblas_blasfn zlasr;
    struct flexiblas_blasfn zlassq;
    struct flexiblas_blasfn zlaswp;
    struct flexiblas_blasfn zlasyf;
    struct flexiblas_blasfn zlat2c;
    struct flexiblas_blasfn zlatbs;
    struct flexiblas_blasfn zlatdf;
    struct flexiblas_blasfn zlatps;
    struct flexiblas_blasfn zlatrd;
    struct flexiblas_blasfn zlatrs;
    struct flexiblas_blasfn zlatrz;
    struct flexiblas_blasfn zlatzm;
    struct flexiblas_blasfn zlauu2;
    struct flexiblas_blasfn zlauum;
    struct flexiblas_blasfn zpbcon;
    struct flexiblas_blasfn zpbequ;
    struct flexiblas_blasfn zpbrfs;
    struct flexiblas_blasfn zpbstf;
    struct flexiblas_blasfn zpbsv;
    struct flexiblas_blasfn zpbsvx;
    struct flexiblas_blasfn zpbtf2;
    struct flexiblas_blasfn zpbtrf;
    struct flexiblas_blasfn zpbtrs;
    struct flexiblas_blasfn zpftrf;
    struct flexiblas_blasfn zpftri;
    struct flexiblas_blasfn zpftrs;
    struct flexiblas_blasfn zpocon;
    struct flexiblas_blasfn zpoequ;
    struct flexiblas_blasfn zpoequb;
    struct flexiblas_blasfn zporfs;
    struct flexiblas_blasfn zposv;
    struct flexiblas_blasfn zposvx;
    struct flexiblas_blasfn zpotf2;
    struct flexiblas_blasfn zpotrf;
    struct flexiblas_blasfn zpotri;
    struct flexiblas_blasfn zpotrs;
    struct flexiblas_blasfn zppcon;
    struct flexiblas_blasfn zppequ;
    struct flexiblas_blasfn zpprfs;
    struct flexiblas_blasfn zppsv;
    struct flexiblas_blasfn zppsvx;
    struct flexiblas_blasfn zpptrf;
    struct flexiblas_blasfn zpptri;
    struct flexiblas_blasfn zpptrs;
    struct flexiblas_blasfn zpstf2;
    struct flexiblas_blasfn zpstrf;
    struct flexiblas_blasfn zptcon;
    struct flexiblas_blasfn zpteqr;
    struct flexiblas_blasfn zptrfs;
    struct flexiblas_blasfn zptsv;
    struct flexiblas_blasfn zptsvx;
    struct flexiblas_blasfn zpttrf;
    struct flexiblas_blasfn zpttrs;
    struct flexiblas_blasfn zptts2;
    struct flexiblas_blasfn zrot;
    struct flexiblas_blasfn zspcon;
    struct flexiblas_blasfn zspmv;
    struct flexiblas_blasfn zspr;
    struct flexiblas_blasfn zsprfs;
    struct flexiblas_blasfn zspsv;
    struct flexiblas_blasfn zspsvx;
    struct flexiblas_blasfn zsptrf;
    struct flexiblas_blasfn zsptri;
    struct flexiblas_blasfn zsptrs;
    struct flexiblas_blasfn zstedc;
    struct flexiblas_blasfn zstegr;
    struct flexiblas_blasfn zstein;
    struct flexiblas_blasfn zstemr;
    struct flexiblas_blasfn zsteqr;
    struct flexiblas_blasfn zsycon;
    struct flexiblas_blasfn zsyconv;
    struct flexiblas_blasfn zsyequb;
    struct flexiblas_blasfn zsymv;
    struct flexiblas_blasfn zsyr;
    struct flexiblas_blasfn zsyrfs;
    struct flexiblas_blasfn zsysv;
    struct flexiblas_blasfn zsysvx;
    struct flexiblas_blasfn zsyswapr;
    struct flexiblas_blasfn zsytf2;
    struct flexiblas_blasfn zsytrf;
    struct flexiblas_blasfn zsytri;
    struct flexiblas_blasfn zsytri2;
    struct flexiblas_blasfn zsytri2x;
    struct flexiblas_blasfn zsytrs;
    struct flexiblas_blasfn zsytrs2;
    struct flexiblas_blasfn ztbcon;
    struct flexiblas_blasfn ztbrfs;
    struct flexiblas_blasfn ztbtrs;
    struct flexiblas_blasfn ztfsm;
    struct flexiblas_blasfn ztftri;
    struct flexiblas_blasfn ztfttp;
    struct flexiblas_blasfn ztfttr;
    struct flexiblas_blasfn ztgevc;
    struct flexiblas_blasfn ztgex2;
    struct flexiblas_blasfn ztgexc;
    struct flexiblas_blasfn ztgsen;
    struct flexiblas_blasfn ztgsja;
    struct flexiblas_blasfn ztgsna;
    struct flexiblas_blasfn ztgsy2;
    struct flexiblas_blasfn ztgsyl;
    struct flexiblas_blasfn ztpcon;
    struct flexiblas_blasfn ztprfs;
    struct flexiblas_blasfn ztptri;
    struct flexiblas_blasfn ztptrs;
    struct flexiblas_blasfn ztpttf;
    struct flexiblas_blasfn ztpttr;
    struct flexiblas_blasfn ztrcon;
    struct flexiblas_blasfn ztrevc;
    struct flexiblas_blasfn ztrexc;
    struct flexiblas_blasfn ztrrfs;
    struct flexiblas_blasfn ztrsen;
    struct flexiblas_blasfn ztrsna;
    struct flexiblas_blasfn ztrsyl;
    struct flexiblas_blasfn ztrti2;
    struct flexiblas_blasfn ztrtri;
    struct flexiblas_blasfn ztrtrs;
    struct flexiblas_blasfn ztrttf;
    struct flexiblas_blasfn ztrttp;
    struct flexiblas_blasfn ztzrqf;
    struct flexiblas_blasfn ztzrzf;
    struct flexiblas_blasfn zunbdb;
    struct flexiblas_blasfn zuncsd;
    struct flexiblas_blasfn zung2l;
    struct flexiblas_blasfn zung2r;
    struct flexiblas_blasfn zungbr;
    struct flexiblas_blasfn zunghr;
    struct flexiblas_blasfn zungl2;
    struct flexiblas_blasfn zunglq;
    struct flexiblas_blasfn zungql;
    struct flexiblas_blasfn zungqr;
    struct flexiblas_blasfn zungr2;
    struct flexiblas_blasfn zungrq;
    struct flexiblas_blasfn zungtr;
    struct flexiblas_blasfn zunm2l;
    struct flexiblas_blasfn zunm2r;
    struct flexiblas_blasfn zunmbr;
    struct flexiblas_blasfn zunmhr;
    struct flexiblas_blasfn zunml2;
    struct flexiblas_blasfn zunmlq;
    struct flexiblas_blasfn zunmql;
    struct flexiblas_blasfn zunmqr;
    struct flexiblas_blasfn zunmr2;
    struct flexiblas_blasfn zunmr3;
    struct flexiblas_blasfn zunmrq;
    struct flexiblas_blasfn zunmrz;
    struct flexiblas_blasfn zunmtr;
    struct flexiblas_blasfn zupgtr;
    struct flexiblas_blasfn zupmtr;
} flexiblas_lapack_backend_t; 

#ifdef __cplusplus
}
#endif
#endif
