/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Linking FlexiBLAS statically or dynamically with other modules is making a combined
 * work based on FlexiBLAS. Thus, the terms and conditions of the GNU General
 * Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of FlexiBLAS give you permission
 * to combine FlexiBLAS program with free software programs or libraries that are
 * released under the GNU LGPL and with independent modules that communicate with
 * FlexiBLAS solely through the BLAS/LAPACK interface as provided by the
 * BLAS/LAPACK reference implementation. You may copy and distribute such a system
 * following the terms of the GNU GPL for FlexiBLAS and the licenses of the other
 * code concerned, provided that you include the source code of that other code
 * when and as the GNU GPL requires distribution of source code and provided that
 * you do not modify the BLAS/LAPACK interface.
 *
 * Note that people who make modified versions of FlexiBLAS are not obligated to
 * grant this special exception for their modified versions; it is their choice
 * whether to do so. The GNU General Public License gives permission to release a
 * modified version without this exception; this exception also makes it possible
 * to release a modified version which carries forward this exception. If you
 * modify the BLAS/LAPACK interface, this exception does not apply to your
 * modified version of FlexiBLAS, and you must remove this exception when you
 * distribute your modified version.
 *
 * This exception is an additional permission under section 7 of the GNU General
 * Public License, version 3 (“GPLv3”)
 *
 *
 * Copyright (C) Martin Koehler, 2013-2023
 */
        
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <complex.h>

#include "flexiblas_fortran_mangle.h"

#include "flexiblas.h"


#if __GNUC__ > 7
typedef size_t fortran_charlen_t;
#else
typedef int fortran_charlen_t;
#endif

#ifdef INTEGER8
#define blasint int64_t
#else
#define blasint int
#endif


HIDDEN int __flexiblas_load_flapack_fallback ( flexiblas_backend_t *handle, int *loaded, int *failed )  {
	int _ifailed = *failed;
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cbbcsd,cbbcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cbdsqr,cbdsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbbrd,cgbbrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbcon,cgbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbequ,cgbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbequb,cgbequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbrfs,cgbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbsv,cgbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbsvx,cgbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbtf2,cgbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbtrf,cgbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgbtrs,cgbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgebak,cgebak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgebal,cgebal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgebd2,cgebd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgebrd,cgebrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgecon,cgecon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeequ,cgeequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeequb,cgeequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgees,cgees);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeesx,cgeesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeev,cgeev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeevx,cgeevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgegs,cgegs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgegv,cgegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgehd2,cgehd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgehrd,cgehrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgejsv,cgejsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelq,cgelq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelq2,cgelq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelqf,cgelqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelqt,cgelqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelqt3,cgelqt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgels,cgels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelsd,cgelsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelss,cgelss);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelsx,cgelsx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgelsy,cgelsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgemlq,cgemlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgemlqt,cgemlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgemqr,cgemqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgemqrt,cgemqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeql2,cgeql2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqlf,cgeqlf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqp3,cgeqp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqpf,cgeqpf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqr,cgeqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqr2,cgeqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqr2p,cgeqr2p);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqrf,cgeqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqrfp,cgeqrfp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqrt,cgeqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqrt2,cgeqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgeqrt3,cgeqrt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgerfs,cgerfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgerq2,cgerq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgerqf,cgerqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesc2,cgesc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesdd,cgesdd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesv,cgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesvd,cgesvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesvdq,cgesvdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesvdx,cgesvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesvj,cgesvj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgesvx,cgesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetc2,cgetc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetf2,cgetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetrf,cgetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetrf2,cgetrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetri,cgetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetrs,cgetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetsls,cgetsls);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgetsqrhrt,cgetsqrhrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggbak,cggbak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggbal,cggbal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgges,cgges);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgges3,cgges3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggesx,cggesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggev,cggev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggev3,cggev3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggevx,cggevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggglm,cggglm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgghd3,cgghd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgghrd,cgghrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgglse,cgglse);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggqrf,cggqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggrqf,cggrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggsvd,cggsvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggsvd3,cggsvd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggsvp,cggsvp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cggsvp3,cggsvp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgsvj0,cgsvj0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgsvj1,cgsvj1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgtcon,cgtcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgtrfs,cgtrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgtsv,cgtsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgtsvx,cgtsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgttrf,cgttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgttrs,cgttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cgtts2,cgtts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chb2st_kernels,chb2st_kernels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbev,chbev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbev_2stage,chbev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbevd,chbevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbevd_2stage,chbevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbevx,chbevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbevx_2stage,chbevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbgst,chbgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbgv,chbgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbgvd,chbgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbgvx,chbgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chbtrd,chbtrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.checon,checon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.checon_3,checon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.checon_rook,checon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheequb,cheequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheev,cheev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheev_2stage,cheev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevd,cheevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevd_2stage,cheevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevr,cheevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevr_2stage,cheevr_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevx,cheevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheevx_2stage,cheevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegs2,chegs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegst,chegst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegv,chegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegv_2stage,chegv_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegvd,chegvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chegvx,chegvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cherfs,cherfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesv,chesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesv_aa,chesv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesv_aa_2stage,chesv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesv_rk,chesv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesv_rook,chesv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chesvx,chesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cheswapr,cheswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetd2,chetd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetf2,chetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetf2_rk,chetf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetf2_rook,chetf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrd,chetrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrd_2stage,chetrd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrd_hb2st,chetrd_hb2st);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrd_he2hb,chetrd_he2hb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrf,chetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrf_aa,chetrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrf_aa_2stage,chetrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrf_rk,chetrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrf_rook,chetrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri,chetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri2,chetri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri2x,chetri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri_3,chetri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri_3x,chetri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetri_rook,chetri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs,chetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs2,chetrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs_3,chetrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs_aa,chetrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs_aa_2stage,chetrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chetrs_rook,chetrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chfrk,chfrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chgeqz,chgeqz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chla_transtype,chla_transtype);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpcon,chpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpev,chpev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpevd,chpevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpevx,chpevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpgst,chpgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpgv,chpgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpgvd,chpgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpgvx,chpgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chprfs,chprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpsv,chpsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chpsvx,chpsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chptrd,chptrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chptrf,chptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chptri,chptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chptrs,chptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chsein,chsein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.chseqr,chseqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clabrd,clabrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacgv,clacgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacn2,clacn2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacon,clacon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacp2,clacp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacpy,clacpy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacrm,clacrm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clacrt,clacrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cladiv,cladiv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claed0,claed0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claed7,claed7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claed8,claed8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claein,claein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claesy,claesy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claev2,claev2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clag2z,clag2z);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clags2,clags2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clagtm,clagtm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahef,clahef);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahef_aa,clahef_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahef_rk,clahef_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahef_rook,clahef_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahqr,clahqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahr2,clahr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clahrd,clahrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claic1,claic1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clals0,clals0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clalsa,clalsa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clalsd,clalsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clamswlq,clamswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clamtsqr,clamtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clangb,clangb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clange,clange);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clangt,clangt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanhb,clanhb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanhe,clanhe);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanhf,clanhf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanhp,clanhp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanhs,clanhs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clanht,clanht);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clansb,clansb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clansp,clansp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clansy,clansy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clantb,clantb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clantp,clantp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clantr,clantr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clapll,clapll);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clapmr,clapmr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clapmt,clapmt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqgb,claqgb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqge,claqge);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqhb,claqhb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqhe,claqhe);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqhp,claqhp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqp2,claqp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqps,claqps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr0,claqr0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr1,claqr1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr2,claqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr3,claqr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr4,claqr4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqr5,claqr5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqsb,claqsb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqsp,claqsp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqsy,claqsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqz0,claqz0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqz1,claqz1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqz2,claqz2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claqz3,claqz3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clar1v,clar1v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clar2v,clar2v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarcm,clarcm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarf,clarf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfb,clarfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfb_gett,clarfb_gett);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfg,clarfg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfgp,clarfgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarft,clarft);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfx,clarfx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarfy,clarfy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clargv,clargv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarnv,clarnv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarrv,clarrv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clartg,clartg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clartv,clartv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarz,clarz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarzb,clarzb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clarzt,clarzt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clascl,clascl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claset,claset);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clasr,clasr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.classq,classq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claswlq,claswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claswp,claswp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clasyf,clasyf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clasyf_aa,clasyf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clasyf_rk,clasyf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clasyf_rook,clasyf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatbs,clatbs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatdf,clatdf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatps,clatps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatrd,clatrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatrs,clatrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatrz,clatrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatsqr,clatsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clatzm,clatzm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claunhr_col_getrfnp,claunhr_col_getrfnp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.claunhr_col_getrfnp2,claunhr_col_getrfnp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clauu2,clauu2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.clauum,clauum);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbcon,cpbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbequ,cpbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbrfs,cpbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbstf,cpbstf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbsv,cpbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbsvx,cpbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbtf2,cpbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbtrf,cpbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpbtrs,cpbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpftrf,cpftrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpftri,cpftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpftrs,cpftrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpocon,cpocon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpoequ,cpoequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpoequb,cpoequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cporfs,cporfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cposv,cposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cposvx,cposvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpotf2,cpotf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpotrf,cpotrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpotrf2,cpotrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpotri,cpotri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpotrs,cpotrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cppcon,cppcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cppequ,cppequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpprfs,cpprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cppsv,cppsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cppsvx,cppsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpptrf,cpptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpptri,cpptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpptrs,cpptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpstf2,cpstf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpstrf,cpstrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cptcon,cptcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpteqr,cpteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cptrfs,cptrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cptsv,cptsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cptsvx,cptsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpttrf,cpttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cpttrs,cpttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cptts2,cptts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.crot,crot);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cspcon,cspcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cspmv,cspmv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cspr,cspr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csprfs,csprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cspsv,cspsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cspsvx,cspsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csptrf,csptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csptri,csptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csptrs,csptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csrscl,csrscl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cstedc,cstedc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cstegr,cstegr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cstein,cstein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cstemr,cstemr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csteqr,csteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csycon,csycon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csycon_3,csycon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csycon_rook,csycon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyconv,csyconv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyconvf,csyconvf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyconvf_rook,csyconvf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyequb,csyequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csymv,csymv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyr,csyr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyrfs,csyrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysv,csysv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysv_aa,csysv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysv_aa_2stage,csysv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysv_rk,csysv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysv_rook,csysv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csysvx,csysvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csyswapr,csyswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytf2,csytf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytf2_rk,csytf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytf2_rook,csytf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrf,csytrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrf_aa,csytrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrf_aa_2stage,csytrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrf_rk,csytrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrf_rook,csytrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri,csytri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri2,csytri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri2x,csytri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri_3,csytri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri_3x,csytri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytri_rook,csytri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs,csytrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs2,csytrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs_3,csytrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs_aa,csytrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs_aa_2stage,csytrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.csytrs_rook,csytrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctbcon,ctbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctbrfs,ctbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctbtrs,ctbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctfsm,ctfsm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctftri,ctftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctfttp,ctfttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctfttr,ctfttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgevc,ctgevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgex2,ctgex2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgexc,ctgexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgsen,ctgsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgsja,ctgsja);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgsna,ctgsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgsy2,ctgsy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctgsyl,ctgsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpcon,ctpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctplqt,ctplqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctplqt2,ctplqt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpmlqt,ctpmlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpmqrt,ctpmqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpqrt,ctpqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpqrt2,ctpqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctprfb,ctprfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctprfs,ctprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctptri,ctptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctptrs,ctptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpttf,ctpttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctpttr,ctpttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrcon,ctrcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrevc,ctrevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrevc3,ctrevc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrexc,ctrexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrrfs,ctrrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrsen,ctrsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrsna,ctrsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrsyl,ctrsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrti2,ctrti2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrtri,ctrtri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrtrs,ctrtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrttf,ctrttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctrttp,ctrttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctzrqf,ctzrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ctzrzf,ctzrzf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb,cunbdb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb1,cunbdb1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb2,cunbdb2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb3,cunbdb3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb4,cunbdb4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb5,cunbdb5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunbdb6,cunbdb6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cuncsd,cuncsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cuncsd2by1,cuncsd2by1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cung2l,cung2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cung2r,cung2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungbr,cungbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunghr,cunghr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungl2,cungl2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunglq,cunglq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungql,cungql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungqr,cungqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungr2,cungr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungrq,cungrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungtr,cungtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungtsqr,cungtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cungtsqr_row,cungtsqr_row);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunhr_col,cunhr_col);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunm22,cunm22);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunm2l,cunm2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunm2r,cunm2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmbr,cunmbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmhr,cunmhr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunml2,cunml2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmlq,cunmlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmql,cunmql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmqr,cunmqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmr2,cunmr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmr3,cunmr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmrq,cunmrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmrz,cunmrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cunmtr,cunmtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cupgtr,cupgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.cupmtr,cupmtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dbbcsd,dbbcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dbdsdc,dbdsdc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dbdsqr,dbdsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dbdsvdx,dbdsvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ddisna,ddisna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbbrd,dgbbrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbcon,dgbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbequ,dgbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbequb,dgbequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbrfs,dgbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbsv,dgbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbsvx,dgbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbtf2,dgbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbtrf,dgbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgbtrs,dgbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgebak,dgebak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgebal,dgebal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgebd2,dgebd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgebrd,dgebrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgecon,dgecon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeequ,dgeequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeequb,dgeequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgees,dgees);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeesx,dgeesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeev,dgeev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeevx,dgeevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgegs,dgegs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgegv,dgegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgehd2,dgehd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgehrd,dgehrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgejsv,dgejsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelq,dgelq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelq2,dgelq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelqf,dgelqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelqt,dgelqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelqt3,dgelqt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgels,dgels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelsd,dgelsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelss,dgelss);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelsx,dgelsx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgelsy,dgelsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgemlq,dgemlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgemlqt,dgemlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgemqr,dgemqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgemqrt,dgemqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeql2,dgeql2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqlf,dgeqlf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqp3,dgeqp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqpf,dgeqpf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqr,dgeqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqr2,dgeqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqr2p,dgeqr2p);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqrf,dgeqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqrfp,dgeqrfp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqrt,dgeqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqrt2,dgeqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgeqrt3,dgeqrt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgerfs,dgerfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgerq2,dgerq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgerqf,dgerqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesc2,dgesc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesdd,dgesdd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesv,dgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesvd,dgesvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesvdq,dgesvdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesvdx,dgesvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesvj,dgesvj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgesvx,dgesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetc2,dgetc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetf2,dgetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetrf,dgetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetrf2,dgetrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetri,dgetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetrs,dgetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetsls,dgetsls);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgetsqrhrt,dgetsqrhrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggbak,dggbak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggbal,dggbal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgges,dgges);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgges3,dgges3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggesx,dggesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggev,dggev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggev3,dggev3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggevx,dggevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggglm,dggglm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgghd3,dgghd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgghrd,dgghrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgglse,dgglse);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggqrf,dggqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggrqf,dggrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggsvd,dggsvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggsvd3,dggsvd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggsvp,dggsvp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dggsvp3,dggsvp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgsvj0,dgsvj0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgsvj1,dgsvj1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgtcon,dgtcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgtrfs,dgtrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgtsv,dgtsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgtsvx,dgtsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgttrf,dgttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgttrs,dgttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dgtts2,dgtts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dhgeqz,dhgeqz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dhsein,dhsein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dhseqr,dhseqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.disnan,disnan);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlabad,dlabad);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlabrd,dlabrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlacn2,dlacn2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlacon,dlacon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlacpy,dlacpy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dladiv,dladiv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dladiv1,dladiv1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dladiv2,dladiv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlae2,dlae2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaebz,dlaebz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed0,dlaed0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed1,dlaed1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed2,dlaed2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed3,dlaed3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed4,dlaed4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed5,dlaed5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed6,dlaed6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed7,dlaed7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed8,dlaed8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaed9,dlaed9);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaeda,dlaeda);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaein,dlaein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaev2,dlaev2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaexc,dlaexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlag2,dlag2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlag2s,dlag2s);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlags2,dlags2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlagtf,dlagtf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlagtm,dlagtm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlagts,dlagts);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlagv2,dlagv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlahqr,dlahqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlahr2,dlahr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlahrd,dlahrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaic1,dlaic1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaisnan,dlaisnan);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaln2,dlaln2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlals0,dlals0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlalsa,dlalsa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlalsd,dlalsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlamc3,dlamc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlamch,dlamch);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlamrg,dlamrg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlamswlq,dlamswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlamtsqr,dlamtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaneg,dlaneg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlangb,dlangb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlange,dlange);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlangt,dlangt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlanhs,dlanhs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlansb,dlansb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlansf,dlansf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlansp,dlansp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlanst,dlanst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlansy,dlansy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlantb,dlantb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlantp,dlantp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlantr,dlantr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlanv2,dlanv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaorhr_col_getrfnp,dlaorhr_col_getrfnp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaorhr_col_getrfnp2,dlaorhr_col_getrfnp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlapll,dlapll);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlapmr,dlapmr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlapmt,dlapmt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlapy2,dlapy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlapy3,dlapy3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqgb,dlaqgb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqge,dlaqge);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqp2,dlaqp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqps,dlaqps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr0,dlaqr0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr1,dlaqr1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr2,dlaqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr3,dlaqr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr4,dlaqr4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqr5,dlaqr5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqsb,dlaqsb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqsp,dlaqsp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqsy,dlaqsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqtr,dlaqtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqz0,dlaqz0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqz1,dlaqz1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqz2,dlaqz2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqz3,dlaqz3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaqz4,dlaqz4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlar1v,dlar1v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlar2v,dlar2v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarf,dlarf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfb,dlarfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfb_gett,dlarfb_gett);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfg,dlarfg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfgp,dlarfgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarft,dlarft);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfx,dlarfx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarfy,dlarfy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlargv,dlargv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarnv,dlarnv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarra,dlarra);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrb,dlarrb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrc,dlarrc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrd,dlarrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarre,dlarre);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrf,dlarrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrj,dlarrj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrk,dlarrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrr,dlarrr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarrv,dlarrv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlartg,dlartg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlartgp,dlartgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlartgs,dlartgs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlartv,dlartv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaruv,dlaruv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarz,dlarz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarzb,dlarzb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlarzt,dlarzt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlas2,dlas2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlascl,dlascl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd0,dlasd0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd1,dlasd1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd2,dlasd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd3,dlasd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd4,dlasd4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd5,dlasd5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd6,dlasd6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd7,dlasd7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasd8,dlasd8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasda,dlasda);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasdq,dlasdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasdt,dlasdt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaset,dlaset);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq1,dlasq1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq2,dlasq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq3,dlasq3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq4,dlasq4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq5,dlasq5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasq6,dlasq6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasr,dlasr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasrt,dlasrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlassq,dlassq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasv2,dlasv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaswlq,dlaswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlaswp,dlaswp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasy2,dlasy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasyf,dlasyf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasyf_aa,dlasyf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasyf_rk,dlasyf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlasyf_rook,dlasyf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlat2s,dlat2s);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatbs,dlatbs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatdf,dlatdf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatps,dlatps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatrd,dlatrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatrs,dlatrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatrz,dlatrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatsqr,dlatsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlatzm,dlatzm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlauu2,dlauu2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dlauum,dlauum);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dopgtr,dopgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dopmtr,dopmtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb,dorbdb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb1,dorbdb1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb2,dorbdb2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb3,dorbdb3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb4,dorbdb4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb5,dorbdb5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorbdb6,dorbdb6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorcsd,dorcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorcsd2by1,dorcsd2by1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorg2l,dorg2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorg2r,dorg2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgbr,dorgbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorghr,dorghr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgl2,dorgl2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorglq,dorglq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgql,dorgql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgqr,dorgqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgr2,dorgr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgrq,dorgrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgtr,dorgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgtsqr,dorgtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorgtsqr_row,dorgtsqr_row);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorhr_col,dorhr_col);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorm22,dorm22);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorm2l,dorm2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorm2r,dorm2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormbr,dormbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormhr,dormhr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dorml2,dorml2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormlq,dormlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormql,dormql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormqr,dormqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormr2,dormr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormr3,dormr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormrq,dormrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormrz,dormrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dormtr,dormtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbcon,dpbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbequ,dpbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbrfs,dpbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbstf,dpbstf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbsv,dpbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbsvx,dpbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbtf2,dpbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbtrf,dpbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpbtrs,dpbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpftrf,dpftrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpftri,dpftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpftrs,dpftrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpocon,dpocon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpoequ,dpoequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpoequb,dpoequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dporfs,dporfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dposv,dposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dposvx,dposvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpotf2,dpotf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpotrf,dpotrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpotrf2,dpotrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpotri,dpotri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpotrs,dpotrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dppcon,dppcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dppequ,dppequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpprfs,dpprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dppsv,dppsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dppsvx,dppsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpptrf,dpptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpptri,dpptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpptrs,dpptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpstf2,dpstf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpstrf,dpstrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dptcon,dptcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpteqr,dpteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dptrfs,dptrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dptsv,dptsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dptsvx,dptsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpttrf,dpttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dpttrs,dpttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dptts2,dptts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.droundup_lwork,droundup_lwork);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.drscl,drscl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsb2st_kernels,dsb2st_kernels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbev,dsbev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbev_2stage,dsbev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbevd,dsbevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbevd_2stage,dsbevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbevx,dsbevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbevx_2stage,dsbevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbgst,dsbgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbgv,dsbgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbgvd,dsbgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbgvx,dsbgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsbtrd,dsbtrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsecnd,dsecnd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsfrk,dsfrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsgesv,dsgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspcon,dspcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspev,dspev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspevd,dspevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspevx,dspevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspgst,dspgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspgv,dspgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspgvd,dspgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspgvx,dspgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsposv,dsposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsprfs,dsprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspsv,dspsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dspsvx,dspsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsptrd,dsptrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsptrf,dsptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsptri,dsptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsptrs,dsptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstebz,dstebz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstedc,dstedc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstegr,dstegr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstein,dstein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstemr,dstemr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsteqr,dsteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsterf,dsterf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstev,dstev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstevd,dstevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstevr,dstevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dstevx,dstevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsycon,dsycon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsycon_3,dsycon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsycon_rook,dsycon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyconv,dsyconv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyconvf,dsyconvf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyconvf_rook,dsyconvf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyequb,dsyequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyev,dsyev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyev_2stage,dsyev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevd,dsyevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevd_2stage,dsyevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevr,dsyevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevr_2stage,dsyevr_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevx,dsyevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyevx_2stage,dsyevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygs2,dsygs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygst,dsygst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygv,dsygv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygv_2stage,dsygv_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygvd,dsygvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsygvx,dsygvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyrfs,dsyrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysv,dsysv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysv_aa,dsysv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysv_aa_2stage,dsysv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysv_rk,dsysv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysv_rook,dsysv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsysvx,dsysvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsyswapr,dsyswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytd2,dsytd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytf2,dsytf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytf2_rk,dsytf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytf2_rook,dsytf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrd,dsytrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrd_2stage,dsytrd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrd_sb2st,dsytrd_sb2st);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrd_sy2sb,dsytrd_sy2sb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrf,dsytrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrf_aa,dsytrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrf_aa_2stage,dsytrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrf_rk,dsytrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrf_rook,dsytrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri,dsytri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri2,dsytri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri2x,dsytri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri_3,dsytri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri_3x,dsytri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytri_rook,dsytri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs,dsytrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs2,dsytrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs_3,dsytrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs_aa,dsytrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs_aa_2stage,dsytrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dsytrs_rook,dsytrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtbcon,dtbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtbrfs,dtbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtbtrs,dtbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtfsm,dtfsm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtftri,dtftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtfttp,dtfttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtfttr,dtfttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgevc,dtgevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgex2,dtgex2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgexc,dtgexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgsen,dtgsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgsja,dtgsja);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgsna,dtgsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgsy2,dtgsy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtgsyl,dtgsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpcon,dtpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtplqt,dtplqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtplqt2,dtplqt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpmlqt,dtpmlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpmqrt,dtpmqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpqrt,dtpqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpqrt2,dtpqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtprfb,dtprfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtprfs,dtprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtptri,dtptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtptrs,dtptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpttf,dtpttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtpttr,dtpttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrcon,dtrcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrevc,dtrevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrevc3,dtrevc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrexc,dtrexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrrfs,dtrrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrsen,dtrsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrsna,dtrsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrsyl,dtrsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrti2,dtrti2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrtri,dtrtri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrtrs,dtrtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrttf,dtrttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtrttp,dtrttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtzrqf,dtzrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dtzrzf,dtzrzf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.dzsum1,dzsum1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.icmax1,icmax1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ieeeck,ieeeck);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaclc,ilaclc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaclr,ilaclr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.iladiag,iladiag);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.iladlc,iladlc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.iladlr,iladlr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaenv,ilaenv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaenv2stage,ilaenv2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaprec,ilaprec);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaslc,ilaslc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilaslr,ilaslr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilatrans,ilatrans);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilauplo,ilauplo);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilazlc,ilazlc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ilazlr,ilazlr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.iparam2stage,iparam2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.iparmq,iparmq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.izmax1,izmax1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sbbcsd,sbbcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sbdsdc,sbdsdc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sbdsqr,sbdsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sbdsvdx,sbdsvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.scsum1,scsum1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sdisna,sdisna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.second,second);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbbrd,sgbbrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbcon,sgbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbequ,sgbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbequb,sgbequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbrfs,sgbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbsv,sgbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbsvx,sgbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbtf2,sgbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbtrf,sgbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgbtrs,sgbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgebak,sgebak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgebal,sgebal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgebd2,sgebd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgebrd,sgebrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgecon,sgecon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeequ,sgeequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeequb,sgeequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgees,sgees);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeesx,sgeesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeev,sgeev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeevx,sgeevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgegs,sgegs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgegv,sgegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgehd2,sgehd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgehrd,sgehrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgejsv,sgejsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelq,sgelq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelq2,sgelq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelqf,sgelqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelqt,sgelqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelqt3,sgelqt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgels,sgels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelsd,sgelsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelss,sgelss);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelsx,sgelsx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgelsy,sgelsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgemlq,sgemlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgemlqt,sgemlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgemqr,sgemqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgemqrt,sgemqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeql2,sgeql2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqlf,sgeqlf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqp3,sgeqp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqpf,sgeqpf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqr,sgeqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqr2,sgeqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqr2p,sgeqr2p);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqrf,sgeqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqrfp,sgeqrfp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqrt,sgeqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqrt2,sgeqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgeqrt3,sgeqrt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgerfs,sgerfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgerq2,sgerq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgerqf,sgerqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesc2,sgesc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesdd,sgesdd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesv,sgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesvd,sgesvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesvdq,sgesvdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesvdx,sgesvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesvj,sgesvj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgesvx,sgesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetc2,sgetc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetf2,sgetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetrf,sgetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetrf2,sgetrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetri,sgetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetrs,sgetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetsls,sgetsls);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgetsqrhrt,sgetsqrhrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggbak,sggbak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggbal,sggbal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgges,sgges);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgges3,sgges3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggesx,sggesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggev,sggev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggev3,sggev3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggevx,sggevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggglm,sggglm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgghd3,sgghd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgghrd,sgghrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgglse,sgglse);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggqrf,sggqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggrqf,sggrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggsvd,sggsvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggsvd3,sggsvd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggsvp,sggsvp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sggsvp3,sggsvp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgsvj0,sgsvj0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgsvj1,sgsvj1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgtcon,sgtcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgtrfs,sgtrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgtsv,sgtsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgtsvx,sgtsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgttrf,sgttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgttrs,sgttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sgtts2,sgtts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.shgeqz,shgeqz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.shsein,shsein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.shseqr,shseqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sisnan,sisnan);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slabad,slabad);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slabrd,slabrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slacn2,slacn2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slacon,slacon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slacpy,slacpy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sladiv,sladiv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sladiv1,sladiv1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sladiv2,sladiv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slae2,slae2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaebz,slaebz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed0,slaed0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed1,slaed1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed2,slaed2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed3,slaed3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed4,slaed4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed5,slaed5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed6,slaed6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed7,slaed7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed8,slaed8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaed9,slaed9);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaeda,slaeda);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaein,slaein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaev2,slaev2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaexc,slaexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slag2,slag2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slag2d,slag2d);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slags2,slags2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slagtf,slagtf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slagtm,slagtm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slagts,slagts);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slagv2,slagv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slahqr,slahqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slahr2,slahr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slahrd,slahrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaic1,slaic1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaisnan,slaisnan);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaln2,slaln2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slals0,slals0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slalsa,slalsa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slalsd,slalsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slamc3,slamc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slamch,slamch);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slamrg,slamrg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slamswlq,slamswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slamtsqr,slamtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaneg,slaneg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slangb,slangb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slange,slange);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slangt,slangt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slanhs,slanhs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slansb,slansb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slansf,slansf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slansp,slansp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slanst,slanst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slansy,slansy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slantb,slantb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slantp,slantp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slantr,slantr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slanv2,slanv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaorhr_col_getrfnp,slaorhr_col_getrfnp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaorhr_col_getrfnp2,slaorhr_col_getrfnp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slapll,slapll);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slapmr,slapmr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slapmt,slapmt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slapy2,slapy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slapy3,slapy3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqgb,slaqgb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqge,slaqge);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqp2,slaqp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqps,slaqps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr0,slaqr0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr1,slaqr1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr2,slaqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr3,slaqr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr4,slaqr4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqr5,slaqr5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqsb,slaqsb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqsp,slaqsp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqsy,slaqsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqtr,slaqtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqz0,slaqz0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqz1,slaqz1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqz2,slaqz2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqz3,slaqz3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaqz4,slaqz4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slar1v,slar1v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slar2v,slar2v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarf,slarf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfb,slarfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfb_gett,slarfb_gett);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfg,slarfg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfgp,slarfgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarft,slarft);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfx,slarfx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarfy,slarfy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slargv,slargv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarnv,slarnv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarra,slarra);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrb,slarrb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrc,slarrc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrd,slarrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarre,slarre);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrf,slarrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrj,slarrj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrk,slarrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrr,slarrr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarrv,slarrv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slartg,slartg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slartgp,slartgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slartgs,slartgs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slartv,slartv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaruv,slaruv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarz,slarz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarzb,slarzb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slarzt,slarzt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slas2,slas2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slascl,slascl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd0,slasd0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd1,slasd1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd2,slasd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd3,slasd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd4,slasd4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd5,slasd5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd6,slasd6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd7,slasd7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasd8,slasd8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasda,slasda);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasdq,slasdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasdt,slasdt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaset,slaset);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq1,slasq1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq2,slasq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq3,slasq3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq4,slasq4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq5,slasq5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasq6,slasq6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasr,slasr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasrt,slasrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slassq,slassq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasv2,slasv2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaswlq,slaswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slaswp,slaswp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasy2,slasy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasyf,slasyf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasyf_aa,slasyf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasyf_rk,slasyf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slasyf_rook,slasyf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatbs,slatbs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatdf,slatdf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatps,slatps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatrd,slatrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatrs,slatrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatrz,slatrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatsqr,slatsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slatzm,slatzm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slauu2,slauu2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.slauum,slauum);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sopgtr,sopgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sopmtr,sopmtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb,sorbdb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb1,sorbdb1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb2,sorbdb2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb3,sorbdb3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb4,sorbdb4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb5,sorbdb5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorbdb6,sorbdb6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorcsd,sorcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorcsd2by1,sorcsd2by1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorg2l,sorg2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorg2r,sorg2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgbr,sorgbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorghr,sorghr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgl2,sorgl2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorglq,sorglq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgql,sorgql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgqr,sorgqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgr2,sorgr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgrq,sorgrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgtr,sorgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgtsqr,sorgtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorgtsqr_row,sorgtsqr_row);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorhr_col,sorhr_col);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorm22,sorm22);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorm2l,sorm2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorm2r,sorm2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormbr,sormbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormhr,sormhr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sorml2,sorml2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormlq,sormlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormql,sormql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormqr,sormqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormr2,sormr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormr3,sormr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormrq,sormrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormrz,sormrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sormtr,sormtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbcon,spbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbequ,spbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbrfs,spbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbstf,spbstf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbsv,spbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbsvx,spbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbtf2,spbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbtrf,spbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spbtrs,spbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spftrf,spftrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spftri,spftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spftrs,spftrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spocon,spocon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spoequ,spoequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spoequb,spoequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sporfs,sporfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sposv,sposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sposvx,sposvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spotf2,spotf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spotrf,spotrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spotrf2,spotrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spotri,spotri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spotrs,spotrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sppcon,sppcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sppequ,sppequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spprfs,spprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sppsv,sppsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sppsvx,sppsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spptrf,spptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spptri,spptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spptrs,spptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spstf2,spstf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spstrf,spstrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sptcon,sptcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spteqr,spteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sptrfs,sptrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sptsv,sptsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sptsvx,sptsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spttrf,spttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.spttrs,spttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sptts2,sptts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sroundup_lwork,sroundup_lwork);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.srscl,srscl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssb2st_kernels,ssb2st_kernels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbev,ssbev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbev_2stage,ssbev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbevd,ssbevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbevd_2stage,ssbevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbevx,ssbevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbevx_2stage,ssbevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbgst,ssbgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbgv,ssbgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbgvd,ssbgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbgvx,ssbgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssbtrd,ssbtrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssfrk,ssfrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspcon,sspcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspev,sspev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspevd,sspevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspevx,sspevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspgst,sspgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspgv,sspgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspgvd,sspgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspgvx,sspgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssprfs,ssprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspsv,sspsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sspsvx,sspsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssptrd,ssptrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssptrf,ssptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssptri,ssptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssptrs,ssptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstebz,sstebz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstedc,sstedc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstegr,sstegr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstein,sstein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstemr,sstemr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssteqr,ssteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssterf,ssterf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstev,sstev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstevd,sstevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstevr,sstevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.sstevx,sstevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssycon,ssycon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssycon_3,ssycon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssycon_rook,ssycon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyconv,ssyconv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyconvf,ssyconvf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyconvf_rook,ssyconvf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyequb,ssyequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyev,ssyev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyev_2stage,ssyev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevd,ssyevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevd_2stage,ssyevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevr,ssyevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevr_2stage,ssyevr_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevx,ssyevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyevx_2stage,ssyevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygs2,ssygs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygst,ssygst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygv,ssygv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygv_2stage,ssygv_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygvd,ssygvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssygvx,ssygvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyrfs,ssyrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysv,ssysv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysv_aa,ssysv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysv_aa_2stage,ssysv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysv_rk,ssysv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysv_rook,ssysv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssysvx,ssysvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssyswapr,ssyswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytd2,ssytd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytf2,ssytf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytf2_rk,ssytf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytf2_rook,ssytf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrd,ssytrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrd_2stage,ssytrd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrd_sb2st,ssytrd_sb2st);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrd_sy2sb,ssytrd_sy2sb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrf,ssytrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrf_aa,ssytrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrf_aa_2stage,ssytrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrf_rk,ssytrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrf_rook,ssytrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri,ssytri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri2,ssytri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri2x,ssytri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri_3,ssytri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri_3x,ssytri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytri_rook,ssytri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs,ssytrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs2,ssytrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs_3,ssytrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs_aa,ssytrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs_aa_2stage,ssytrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ssytrs_rook,ssytrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stbcon,stbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stbrfs,stbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stbtrs,stbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stfsm,stfsm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stftri,stftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stfttp,stfttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stfttr,stfttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgevc,stgevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgex2,stgex2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgexc,stgexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgsen,stgsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgsja,stgsja);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgsna,stgsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgsy2,stgsy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stgsyl,stgsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpcon,stpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stplqt,stplqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stplqt2,stplqt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpmlqt,stpmlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpmqrt,stpmqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpqrt,stpqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpqrt2,stpqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stprfb,stprfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stprfs,stprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stptri,stptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stptrs,stptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpttf,stpttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stpttr,stpttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strcon,strcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strevc,strevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strevc3,strevc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strexc,strexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strrfs,strrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strsen,strsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strsna,strsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strsyl,strsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strti2,strti2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strtri,strtri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strtrs,strtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strttf,strttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.strttp,strttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stzrqf,stzrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.stzrzf,stzrzf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.xerbla_array,xerbla_array);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zbbcsd,zbbcsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zbdsqr,zbdsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zcgesv,zcgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zcposv,zcposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zdrscl,zdrscl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbbrd,zgbbrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbcon,zgbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbequ,zgbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbequb,zgbequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbrfs,zgbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbsv,zgbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbsvx,zgbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbtf2,zgbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbtrf,zgbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgbtrs,zgbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgebak,zgebak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgebal,zgebal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgebd2,zgebd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgebrd,zgebrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgecon,zgecon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeequ,zgeequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeequb,zgeequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgees,zgees);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeesx,zgeesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeev,zgeev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeevx,zgeevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgegs,zgegs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgegv,zgegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgehd2,zgehd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgehrd,zgehrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgejsv,zgejsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelq,zgelq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelq2,zgelq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelqf,zgelqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelqt,zgelqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelqt3,zgelqt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgels,zgels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelsd,zgelsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelss,zgelss);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelsx,zgelsx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgelsy,zgelsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgemlq,zgemlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgemlqt,zgemlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgemqr,zgemqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgemqrt,zgemqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeql2,zgeql2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqlf,zgeqlf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqp3,zgeqp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqpf,zgeqpf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqr,zgeqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqr2,zgeqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqr2p,zgeqr2p);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqrf,zgeqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqrfp,zgeqrfp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqrt,zgeqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqrt2,zgeqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgeqrt3,zgeqrt3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgerfs,zgerfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgerq2,zgerq2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgerqf,zgerqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesc2,zgesc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesdd,zgesdd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesv,zgesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesvd,zgesvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesvdq,zgesvdq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesvdx,zgesvdx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesvj,zgesvj);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgesvx,zgesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetc2,zgetc2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetf2,zgetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetrf,zgetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetrf2,zgetrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetri,zgetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetrs,zgetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetsls,zgetsls);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgetsqrhrt,zgetsqrhrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggbak,zggbak);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggbal,zggbal);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgges,zgges);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgges3,zgges3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggesx,zggesx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggev,zggev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggev3,zggev3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggevx,zggevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggglm,zggglm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgghd3,zgghd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgghrd,zgghrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgglse,zgglse);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggqrf,zggqrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggrqf,zggrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggsvd,zggsvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggsvd3,zggsvd3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggsvp,zggsvp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zggsvp3,zggsvp3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgsvj0,zgsvj0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgsvj1,zgsvj1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgtcon,zgtcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgtrfs,zgtrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgtsv,zgtsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgtsvx,zgtsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgttrf,zgttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgttrs,zgttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zgtts2,zgtts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhb2st_kernels,zhb2st_kernels);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbev,zhbev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbev_2stage,zhbev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbevd,zhbevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbevd_2stage,zhbevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbevx,zhbevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbevx_2stage,zhbevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbgst,zhbgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbgv,zhbgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbgvd,zhbgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbgvx,zhbgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhbtrd,zhbtrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhecon,zhecon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhecon_3,zhecon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhecon_rook,zhecon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheequb,zheequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheev,zheev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheev_2stage,zheev_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevd,zheevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevd_2stage,zheevd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevr,zheevr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevr_2stage,zheevr_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevx,zheevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheevx_2stage,zheevx_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegs2,zhegs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegst,zhegst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegv,zhegv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegv_2stage,zhegv_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegvd,zhegvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhegvx,zhegvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zherfs,zherfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesv,zhesv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesv_aa,zhesv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesv_aa_2stage,zhesv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesv_rk,zhesv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesv_rook,zhesv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhesvx,zhesvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zheswapr,zheswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetd2,zhetd2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetf2,zhetf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetf2_rk,zhetf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetf2_rook,zhetf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrd,zhetrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrd_2stage,zhetrd_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrd_hb2st,zhetrd_hb2st);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrd_he2hb,zhetrd_he2hb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrf,zhetrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrf_aa,zhetrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrf_aa_2stage,zhetrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrf_rk,zhetrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrf_rook,zhetrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri,zhetri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri2,zhetri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri2x,zhetri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri_3,zhetri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri_3x,zhetri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetri_rook,zhetri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs,zhetrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs2,zhetrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs_3,zhetrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs_aa,zhetrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs_aa_2stage,zhetrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhetrs_rook,zhetrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhfrk,zhfrk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhgeqz,zhgeqz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpcon,zhpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpev,zhpev);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpevd,zhpevd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpevx,zhpevx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpgst,zhpgst);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpgv,zhpgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpgvd,zhpgvd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpgvx,zhpgvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhprfs,zhprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpsv,zhpsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhpsvx,zhpsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhptrd,zhptrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhptrf,zhptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhptri,zhptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhptrs,zhptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhsein,zhsein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zhseqr,zhseqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlabrd,zlabrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacgv,zlacgv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacn2,zlacn2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacon,zlacon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacp2,zlacp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacpy,zlacpy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacrm,zlacrm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlacrt,zlacrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zladiv,zladiv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaed0,zlaed0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaed7,zlaed7);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaed8,zlaed8);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaein,zlaein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaesy,zlaesy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaev2,zlaev2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlag2c,zlag2c);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlags2,zlags2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlagtm,zlagtm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahef,zlahef);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahef_aa,zlahef_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahef_rk,zlahef_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahef_rook,zlahef_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahqr,zlahqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahr2,zlahr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlahrd,zlahrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaic1,zlaic1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlals0,zlals0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlalsa,zlalsa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlalsd,zlalsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlamswlq,zlamswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlamtsqr,zlamtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlangb,zlangb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlange,zlange);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlangt,zlangt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanhb,zlanhb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanhe,zlanhe);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanhf,zlanhf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanhp,zlanhp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanhs,zlanhs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlanht,zlanht);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlansb,zlansb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlansp,zlansp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlansy,zlansy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlantb,zlantb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlantp,zlantp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlantr,zlantr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlapll,zlapll);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlapmr,zlapmr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlapmt,zlapmt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqgb,zlaqgb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqge,zlaqge);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqhb,zlaqhb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqhe,zlaqhe);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqhp,zlaqhp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqp2,zlaqp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqps,zlaqps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr0,zlaqr0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr1,zlaqr1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr2,zlaqr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr3,zlaqr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr4,zlaqr4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqr5,zlaqr5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqsb,zlaqsb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqsp,zlaqsp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqsy,zlaqsy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqz0,zlaqz0);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqz1,zlaqz1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqz2,zlaqz2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaqz3,zlaqz3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlar1v,zlar1v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlar2v,zlar2v);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarcm,zlarcm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarf,zlarf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfb,zlarfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfb_gett,zlarfb_gett);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfg,zlarfg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfgp,zlarfgp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarft,zlarft);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfx,zlarfx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarfy,zlarfy);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlargv,zlargv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarnv,zlarnv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarrv,zlarrv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlartg,zlartg);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlartv,zlartv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarz,zlarz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarzb,zlarzb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlarzt,zlarzt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlascl,zlascl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaset,zlaset);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlasr,zlasr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlassq,zlassq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaswlq,zlaswlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaswp,zlaswp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlasyf,zlasyf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlasyf_aa,zlasyf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlasyf_rk,zlasyf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlasyf_rook,zlasyf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlat2c,zlat2c);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatbs,zlatbs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatdf,zlatdf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatps,zlatps);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatrd,zlatrd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatrs,zlatrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatrz,zlatrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatsqr,zlatsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlatzm,zlatzm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaunhr_col_getrfnp,zlaunhr_col_getrfnp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlaunhr_col_getrfnp2,zlaunhr_col_getrfnp2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlauu2,zlauu2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zlauum,zlauum);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbcon,zpbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbequ,zpbequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbrfs,zpbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbstf,zpbstf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbsv,zpbsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbsvx,zpbsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbtf2,zpbtf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbtrf,zpbtrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpbtrs,zpbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpftrf,zpftrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpftri,zpftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpftrs,zpftrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpocon,zpocon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpoequ,zpoequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpoequb,zpoequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zporfs,zporfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zposv,zposv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zposvx,zposvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpotf2,zpotf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpotrf,zpotrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpotrf2,zpotrf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpotri,zpotri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpotrs,zpotrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zppcon,zppcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zppequ,zppequ);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpprfs,zpprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zppsv,zppsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zppsvx,zppsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpptrf,zpptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpptri,zpptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpptrs,zpptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpstf2,zpstf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpstrf,zpstrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zptcon,zptcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpteqr,zpteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zptrfs,zptrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zptsv,zptsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zptsvx,zptsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpttrf,zpttrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zpttrs,zpttrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zptts2,zptts2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zrot,zrot);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zspcon,zspcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zspmv,zspmv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zspr,zspr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsprfs,zsprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zspsv,zspsv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zspsvx,zspsvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsptrf,zsptrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsptri,zsptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsptrs,zsptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zstedc,zstedc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zstegr,zstegr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zstein,zstein);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zstemr,zstemr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsteqr,zsteqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsycon,zsycon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsycon_3,zsycon_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsycon_rook,zsycon_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyconv,zsyconv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyconvf,zsyconvf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyconvf_rook,zsyconvf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyequb,zsyequb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsymv,zsymv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyr,zsyr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyrfs,zsyrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysv,zsysv);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysv_aa,zsysv_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysv_aa_2stage,zsysv_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysv_rk,zsysv_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysv_rook,zsysv_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsysvx,zsysvx);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsyswapr,zsyswapr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytf2,zsytf2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytf2_rk,zsytf2_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytf2_rook,zsytf2_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrf,zsytrf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrf_aa,zsytrf_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrf_aa_2stage,zsytrf_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrf_rk,zsytrf_rk);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrf_rook,zsytrf_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri,zsytri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri2,zsytri2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri2x,zsytri2x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri_3,zsytri_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri_3x,zsytri_3x);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytri_rook,zsytri_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs,zsytrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs2,zsytrs2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs_3,zsytrs_3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs_aa,zsytrs_aa);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs_aa_2stage,zsytrs_aa_2stage);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zsytrs_rook,zsytrs_rook);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztbcon,ztbcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztbrfs,ztbrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztbtrs,ztbtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztfsm,ztfsm);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztftri,ztftri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztfttp,ztfttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztfttr,ztfttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgevc,ztgevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgex2,ztgex2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgexc,ztgexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgsen,ztgsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgsja,ztgsja);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgsna,ztgsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgsy2,ztgsy2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztgsyl,ztgsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpcon,ztpcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztplqt,ztplqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztplqt2,ztplqt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpmlqt,ztpmlqt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpmqrt,ztpmqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpqrt,ztpqrt);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpqrt2,ztpqrt2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztprfb,ztprfb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztprfs,ztprfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztptri,ztptri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztptrs,ztptrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpttf,ztpttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztpttr,ztpttr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrcon,ztrcon);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrevc,ztrevc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrevc3,ztrevc3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrexc,ztrexc);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrrfs,ztrrfs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrsen,ztrsen);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrsna,ztrsna);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrsyl,ztrsyl);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrti2,ztrti2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrtri,ztrtri);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrtrs,ztrtrs);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrttf,ztrttf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztrttp,ztrttp);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztzrqf,ztzrqf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.ztzrzf,ztzrzf);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb,zunbdb);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb1,zunbdb1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb2,zunbdb2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb3,zunbdb3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb4,zunbdb4);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb5,zunbdb5);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunbdb6,zunbdb6);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zuncsd,zuncsd);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zuncsd2by1,zuncsd2by1);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zung2l,zung2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zung2r,zung2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungbr,zungbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunghr,zunghr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungl2,zungl2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunglq,zunglq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungql,zungql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungqr,zungqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungr2,zungr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungrq,zungrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungtr,zungtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungtsqr,zungtsqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zungtsqr_row,zungtsqr_row);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunhr_col,zunhr_col);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunm22,zunm22);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunm2l,zunm2l);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunm2r,zunm2r);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmbr,zunmbr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmhr,zunmhr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunml2,zunml2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmlq,zunmlq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmql,zunmql);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmqr,zunmqr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmr2,zunmr2);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmr3,zunmr3);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmrq,zunmrq);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmrz,zunmrz);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zunmtr,zunmtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zupgtr,zupgtr);
	LOAD_FLAPACK_NOFALLBACK(handle,lapack.zupmtr,zupmtr);
	if (_ifailed != (*failed))
		return 1;
	else
		 return 0;
}

