/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Linking FlexiBLAS statically or dynamically with other modules is making a
 * combined work based on FlexiBLAS. Thus, the terms and conditions of the GNU
 * General Public License cover the whole combination.
 *
 * As a special exception, the copyright holders of FlexiBLAS give you permission
 * to combine FlexiBLAS program with free software programs or libraries that are
 * released under the GNU LGPL and with independent modules that communicate with
 * FlexiBLAS solely through the BLAS/LAPACK interface as provided by the
 * BLAS/LAPACK reference implementation. You may copy and distribute such a system
 * following the terms of the GNU GPL for FlexiBLAS and the licenses of the other
 * code concerned, provided that you include the source code of that other code
 * when and as the GNU GPL requires distribution of source code and provided that
 * you do not modify the BLAS/LAPACK interface.
 *
 * Note that people who make modified versions of FlexiBLAS are not obligated to
 * grant this special exception for their modified versions; it is their choice
 * whether to do so. The GNU General Public License gives permission to release a
 * modified version without this exception; this exception also makes it possible
 * to release a modified version which carries forward this exception. If you
 * modify the BLAS/LAPACK interface, this exception does not apply to your
 * modified version of FlexiBLAS, and you must remove this exception when you
 * distribute your modified version.
 *
 * This exception is an additional permission under section 7 of the GNU General
 * Public License, version 3 (“GPLv3”)
 *
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Copyright (C) Martin Koehler, 2013-2023
 */



#ifndef PROFILE_HOOK_H

#define PROFILE_HOOK_H

#include "cscutils/table.h"

#ifdef INTEGER8
#define     ENV_FLEXIBLAS_PROFILE_FILE "FLEXIBLAS64_PROFILE_FILE"
#else
#define     ENV_FLEXIBLAS_PROFILE_FILE "FLEXIBLAS_PROFILE_FILE"
#endif


#ifdef __cplusplus
extern "C" {
#endif

    extern int __profile_verbose;

    // Helper for debug printing
    #define	DPRINTF( level, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_info( "flexiblas", __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"
    #define	DPRINTFP( level, prefix, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_info( prefix, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"

    #define	DPRINTF_WARN( level, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_warning( "flexiblas", __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"
    #define	DPRINTFP_WARN( level, prefix, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_warning( prefix, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"

#ifdef DEBUG
    #define	DPRINTF_ERROR( level, ... )	    do { if ( __profile_verbose >= (level)) {flexiblas_print_error("flexiblas", __FILE__,__LINE__, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"
    #define	DPRINTFP_ERROR( level, prefix, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_error(prefix, __FILE__,__LINE__, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"
#else
    #define	DPRINTF_ERROR( level, ... )	    do { if ( __profile_verbose >= (level)) {flexiblas_print_error("flexiblas", NULL,0, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"
    #define	DPRINTFP_ERROR( level, prefix, ... )	do { if ( __profile_verbose >= (level)) {flexiblas_print_error(prefix, NULL,0, __VA_ARGS__); } } while(0) // ... represents the "text" and optionally the "args"

#endif


    #define ADD_BLAS_ENTRY(name) do { csc_table_new_row(tab); \
    csc_table_set_entry(tab, col_name,  #name); \
    csc_table_set_entry(tab, col_calls, data->name.calls[0]); \
    csc_table_set_entry(tab, col_time,  data->name.timings[0]); } while( 0 );

    void profile_lapack_add(csc_table_t *tab, int col_name, int col_calls, int col_time);

    typedef struct _profile_data_t {
        double timings[2];
        unsigned long calls[2];
    } profile_data_t;

    typedef struct _blas_calls_t {
        /*  BLAS  */
        profile_data_t caxpy;
        profile_data_t ccopy;
        profile_data_t cdotc;
        profile_data_t cdotu;
        profile_data_t cgbmv;
        profile_data_t cgemm;
        profile_data_t cgemv;
        profile_data_t cgerc;
        profile_data_t cgeru;
        profile_data_t chbmv;
        profile_data_t chemm;
        profile_data_t chemv;
        profile_data_t cher;
        profile_data_t cher2;
        profile_data_t cher2k;
        profile_data_t cherk;
        profile_data_t chpmv;
        profile_data_t chpr;
        profile_data_t chpr2;
        profile_data_t crotg;
        profile_data_t cscal;
        profile_data_t csrot;
        profile_data_t csscal;
        profile_data_t cswap;
        profile_data_t csymm;
        profile_data_t csyr2k;
        profile_data_t csyrk;
        profile_data_t ctbmv;
        profile_data_t ctbsv;
        profile_data_t ctpmv;
        profile_data_t ctpsv;
        profile_data_t ctrmm;
        profile_data_t ctrmv;
        profile_data_t ctrsm;
        profile_data_t ctrsv;
        profile_data_t dasum;
        profile_data_t daxpy;
        profile_data_t dcopy;
        profile_data_t ddot;
        profile_data_t dgbmv;
        profile_data_t dgemm;
        profile_data_t dgemv;
        profile_data_t dger;
        profile_data_t dnrm2;
        profile_data_t drot;
        profile_data_t drotg;
        profile_data_t drotm;
        profile_data_t drotmg;
        profile_data_t dsbmv;
        profile_data_t dscal;
        profile_data_t dsdot;
        profile_data_t dspmv;
        profile_data_t dspr;
        profile_data_t dspr2;
        profile_data_t dswap;
        profile_data_t dsymm;
        profile_data_t dsymv;
        profile_data_t dsyr;
        profile_data_t dsyr2;
        profile_data_t dsyr2k;
        profile_data_t dsyrk;
        profile_data_t dtbmv;
        profile_data_t dtbsv;
        profile_data_t dtpmv;
        profile_data_t dtpsv;
        profile_data_t dtrmm;
        profile_data_t dtrmv;
        profile_data_t dtrsm;
        profile_data_t dtrsv;
        profile_data_t dzasum;
        profile_data_t dznrm2;
        profile_data_t icamax;
        profile_data_t idamax;
        profile_data_t isamax;
        profile_data_t izamax;
        profile_data_t sasum;
        profile_data_t saxpy;
        profile_data_t scasum;
        profile_data_t scnrm2;
        profile_data_t scopy;
        profile_data_t sdot;
        profile_data_t sdsdot;
        profile_data_t sgbmv;
        profile_data_t sgemm;
        profile_data_t sgemv;
        profile_data_t sger;
        profile_data_t snrm2;
        profile_data_t srot;
        profile_data_t srotg;
        profile_data_t srotm;
        profile_data_t srotmg;
        profile_data_t ssbmv;
        profile_data_t sscal;
        profile_data_t sspmv;
        profile_data_t sspr;
        profile_data_t sspr2;
        profile_data_t sswap;
        profile_data_t ssymm;
        profile_data_t ssymv;
        profile_data_t ssyr;
        profile_data_t ssyr2;
        profile_data_t ssyr2k;
        profile_data_t ssyrk;
        profile_data_t stbmv;
        profile_data_t stbsv;
        profile_data_t stpmv;
        profile_data_t stpsv;
        profile_data_t strmm;
        profile_data_t strmv;
        profile_data_t strsm;
        profile_data_t strsv;
        profile_data_t zaxpy;
        profile_data_t zcopy;
        profile_data_t zdotc;
        profile_data_t zdotu;
        profile_data_t zdrot;
        profile_data_t zdscal;
        profile_data_t zgbmv;
        profile_data_t zgemm;
        profile_data_t zgemv;
        profile_data_t zgerc;
        profile_data_t zgeru;
        profile_data_t zhbmv;
        profile_data_t zhemm;
        profile_data_t zhemv;
        profile_data_t zher;
        profile_data_t zher2;
        profile_data_t zher2k;
        profile_data_t zherk;
        profile_data_t zhpmv;
        profile_data_t zhpr;
        profile_data_t zhpr2;
        profile_data_t zrotg;
        profile_data_t zscal;
        profile_data_t zswap;
        profile_data_t zsymm;
        profile_data_t zsyr2k;
        profile_data_t zsyrk;
        profile_data_t ztbmv;
        profile_data_t ztbsv;
        profile_data_t ztpmv;
        profile_data_t ztpsv;
        profile_data_t ztrmm;
        profile_data_t ztrmv;
        profile_data_t ztrsm;
        profile_data_t ztrsv;
        profile_data_t dcabs1;
        profile_data_t scabs1;
        profile_data_t cdotc_sub;
        profile_data_t cdotu_sub;
        profile_data_t zdotc_sub;
        profile_data_t zdotu_sub;
        /* EXT BLAS  */
        profile_data_t caxpby;
        profile_data_t daxpby;
        profile_data_t zaxpby;
        profile_data_t saxpby;
        profile_data_t comatcopy;
        profile_data_t zomatcopy;
        profile_data_t domatcopy;
        profile_data_t somatcopy;
        profile_data_t cimatcopy;
        profile_data_t zimatcopy;
        profile_data_t dimatcopy;
        profile_data_t simatcopy;
        profile_data_t cgeadd;
        profile_data_t dgeadd;
        profile_data_t sgeadd;
        profile_data_t zgeadd;

        profile_data_t dlamc3;
        profile_data_t slamc3;

        /* Lapack 3.9  */
        profile_data_t cbbcsd;
        profile_data_t cbdsqr;
        profile_data_t cgbbrd;
        profile_data_t cgbcon;
        profile_data_t cgbequ;
        profile_data_t cgbequb;
        profile_data_t cgbrfs;
        profile_data_t cgbsv;
        profile_data_t cgbsvx;
        profile_data_t cgbtf2;
        profile_data_t cgbtrf;
        profile_data_t cgbtrs;
        profile_data_t cgebak;
        profile_data_t cgebal;
        profile_data_t cgebd2;
        profile_data_t cgebrd;
        profile_data_t cgecon;
        profile_data_t cgeequ;
        profile_data_t cgeequb;
        profile_data_t cgees;
        profile_data_t cgeesx;
        profile_data_t cgeev;
        profile_data_t cgeevx;
        profile_data_t cgegs;
        profile_data_t cgegv;
        profile_data_t cgehd2;
        profile_data_t cgehrd;
        profile_data_t cgejsv;
        profile_data_t cgelq;
        profile_data_t cgelq2;
        profile_data_t cgelqf;
        profile_data_t cgelqt;
        profile_data_t cgelqt3;
        profile_data_t cgels;
        profile_data_t cgelsd;
        profile_data_t cgelss;
        profile_data_t cgelsx;
        profile_data_t cgelsy;
        profile_data_t cgemlq;
        profile_data_t cgemlqt;
        profile_data_t cgemqr;
        profile_data_t cgemqrt;
        profile_data_t cgeql2;
        profile_data_t cgeqlf;
        profile_data_t cgeqp3;
        profile_data_t cgeqpf;
        profile_data_t cgeqr;
        profile_data_t cgeqr2;
        profile_data_t cgeqr2p;
        profile_data_t cgeqrf;
        profile_data_t cgeqrfp;
        profile_data_t cgeqrt;
        profile_data_t cgeqrt2;
        profile_data_t cgeqrt3;
        profile_data_t cgerfs;
        profile_data_t cgerq2;
        profile_data_t cgerqf;
        profile_data_t cgesc2;
        profile_data_t cgesdd;
        profile_data_t cgesv;
        profile_data_t cgesvd;
        profile_data_t cgesvdq;
        profile_data_t cgesvdx;
        profile_data_t cgesvj;
        profile_data_t cgesvx;
        profile_data_t cgetc2;
        profile_data_t cgetf2;
        profile_data_t cgetrf;
        profile_data_t cgetrf2;
        profile_data_t cgetri;
        profile_data_t cgetrs;
        profile_data_t cgetsls;
        profile_data_t cggbak;
        profile_data_t cggbal;
        profile_data_t cgges;
        profile_data_t cgges3;
        profile_data_t cggesx;
        profile_data_t cggev;
        profile_data_t cggev3;
        profile_data_t cggevx;
        profile_data_t cggglm;
        profile_data_t cgghd3;
        profile_data_t cgghrd;
        profile_data_t cgglse;
        profile_data_t cggqrf;
        profile_data_t cggrqf;
        profile_data_t cggsvd;
        profile_data_t cggsvd3;
        profile_data_t cggsvp;
        profile_data_t cggsvp3;
        profile_data_t cgsvj0;
        profile_data_t cgsvj1;
        profile_data_t cgtcon;
        profile_data_t cgtrfs;
        profile_data_t cgtsv;
        profile_data_t cgtsvx;
        profile_data_t cgttrf;
        profile_data_t cgttrs;
        profile_data_t cgtts2;
        profile_data_t chb2st_kernels;
        profile_data_t chbev;
        profile_data_t chbev_2stage;
        profile_data_t chbevd;
        profile_data_t chbevd_2stage;
        profile_data_t chbevx;
        profile_data_t chbevx_2stage;
        profile_data_t chbgst;
        profile_data_t chbgv;
        profile_data_t chbgvd;
        profile_data_t chbgvx;
        profile_data_t chbtrd;
        profile_data_t checon;
        profile_data_t checon_3;
        profile_data_t checon_rook;
        profile_data_t cheequb;
        profile_data_t cheev;
        profile_data_t cheev_2stage;
        profile_data_t cheevd;
        profile_data_t cheevd_2stage;
        profile_data_t cheevr;
        profile_data_t cheevr_2stage;
        profile_data_t cheevx;
        profile_data_t cheevx_2stage;
        profile_data_t chegs2;
        profile_data_t chegst;
        profile_data_t chegv;
        profile_data_t chegv_2stage;
        profile_data_t chegvd;
        profile_data_t chegvx;
        profile_data_t cherfs;
        profile_data_t chesv;
        profile_data_t chesv_aa;
        profile_data_t chesv_aa_2stage;
        profile_data_t chesv_rk;
        profile_data_t chesv_rook;
        profile_data_t chesvx;
        profile_data_t cheswapr;
        profile_data_t chetd2;
        profile_data_t chetf2;
        profile_data_t chetf2_rk;
        profile_data_t chetf2_rook;
        profile_data_t chetrd;
        profile_data_t chetrd_2stage;
        profile_data_t chetrd_hb2st;
        profile_data_t chetrd_he2hb;
        profile_data_t chetrf;
        profile_data_t chetrf_aa;
        profile_data_t chetrf_aa_2stage;
        profile_data_t chetrf_rk;
        profile_data_t chetrf_rook;
        profile_data_t chetri;
        profile_data_t chetri2;
        profile_data_t chetri2x;
        profile_data_t chetri_3;
        profile_data_t chetri_3x;
        profile_data_t chetri_rook;
        profile_data_t chetrs;
        profile_data_t chetrs2;
        profile_data_t chetrs_3;
        profile_data_t chetrs_aa;
        profile_data_t chetrs_aa_2stage;
        profile_data_t chetrs_rook;
        profile_data_t chfrk;
        profile_data_t chgeqz;
        profile_data_t chla_transtype;
        profile_data_t chpcon;
        profile_data_t chpev;
        profile_data_t chpevd;
        profile_data_t chpevx;
        profile_data_t chpgst;
        profile_data_t chpgv;
        profile_data_t chpgvd;
        profile_data_t chpgvx;
        profile_data_t chprfs;
        profile_data_t chpsv;
        profile_data_t chpsvx;
        profile_data_t chptrd;
        profile_data_t chptrf;
        profile_data_t chptri;
        profile_data_t chptrs;
        profile_data_t chsein;
        profile_data_t chseqr;
        profile_data_t clabrd;
        profile_data_t clacgv;
        profile_data_t clacn2;
        profile_data_t clacon;
        profile_data_t clacp2;
        profile_data_t clacpy;
        profile_data_t clacrm;
        profile_data_t clacrt;
        profile_data_t cladiv;
        profile_data_t claed0;
        profile_data_t claed7;
        profile_data_t claed8;
        profile_data_t claein;
        profile_data_t claesy;
        profile_data_t claev2;
        profile_data_t clag2z;
        profile_data_t clags2;
        profile_data_t clagtm;
        profile_data_t clahef;
        profile_data_t clahef_aa;
        profile_data_t clahef_rk;
        profile_data_t clahef_rook;
        profile_data_t clahqr;
        profile_data_t clahr2;
        profile_data_t clahrd;
        profile_data_t claic1;
        profile_data_t clals0;
        profile_data_t clalsa;
        profile_data_t clalsd;
        profile_data_t clamswlq;
        profile_data_t clamtsqr;
        profile_data_t clangb;
        profile_data_t clange;
        profile_data_t clangt;
        profile_data_t clanhb;
        profile_data_t clanhe;
        profile_data_t clanhf;
        profile_data_t clanhp;
        profile_data_t clanhs;
        profile_data_t clanht;
        profile_data_t clansb;
        profile_data_t clansp;
        profile_data_t clansy;
        profile_data_t clantb;
        profile_data_t clantp;
        profile_data_t clantr;
        profile_data_t clapll;
        profile_data_t clapmr;
        profile_data_t clapmt;
        profile_data_t claqgb;
        profile_data_t claqge;
        profile_data_t claqhb;
        profile_data_t claqhe;
        profile_data_t claqhp;
        profile_data_t claqp2;
        profile_data_t claqps;
        profile_data_t claqr0;
        profile_data_t claqr1;
        profile_data_t claqr2;
        profile_data_t claqr3;
        profile_data_t claqr4;
        profile_data_t claqr5;
        profile_data_t claqsb;
        profile_data_t claqsp;
        profile_data_t claqsy;
        profile_data_t clar1v;
        profile_data_t clar2v;
        profile_data_t clarcm;
        profile_data_t clarf;
        profile_data_t clarfb;
        profile_data_t clarfg;
        profile_data_t clarfgp;
        profile_data_t clarft;
        profile_data_t clarfx;
        profile_data_t clarfy;
        profile_data_t clargv;
        profile_data_t clarnv;
        profile_data_t clarrv;
        profile_data_t clartg;
        profile_data_t clartv;
        profile_data_t clarz;
        profile_data_t clarzb;
        profile_data_t clarzt;
        profile_data_t clascl;
        profile_data_t claset;
        profile_data_t clasr;
        profile_data_t classq;
        profile_data_t claswlq;
        profile_data_t claswp;
        profile_data_t clasyf;
        profile_data_t clasyf_aa;
        profile_data_t clasyf_rk;
        profile_data_t clasyf_rook;
        profile_data_t clatbs;
        profile_data_t clatdf;
        profile_data_t clatps;
        profile_data_t clatrd;
        profile_data_t clatrs;
        profile_data_t clatrz;
        profile_data_t clatsqr;
        profile_data_t clatzm;
        profile_data_t claunhr_col_getrfnp;
        profile_data_t claunhr_col_getrfnp2;
        profile_data_t clauu2;
        profile_data_t clauum;
        profile_data_t cpbcon;
        profile_data_t cpbequ;
        profile_data_t cpbrfs;
        profile_data_t cpbstf;
        profile_data_t cpbsv;
        profile_data_t cpbsvx;
        profile_data_t cpbtf2;
        profile_data_t cpbtrf;
        profile_data_t cpbtrs;
        profile_data_t cpftrf;
        profile_data_t cpftri;
        profile_data_t cpftrs;
        profile_data_t cpocon;
        profile_data_t cpoequ;
        profile_data_t cpoequb;
        profile_data_t cporfs;
        profile_data_t cposv;
        profile_data_t cposvx;
        profile_data_t cpotf2;
        profile_data_t cpotrf;
        profile_data_t cpotrf2;
        profile_data_t cpotri;
        profile_data_t cpotrs;
        profile_data_t cppcon;
        profile_data_t cppequ;
        profile_data_t cpprfs;
        profile_data_t cppsv;
        profile_data_t cppsvx;
        profile_data_t cpptrf;
        profile_data_t cpptri;
        profile_data_t cpptrs;
        profile_data_t cpstf2;
        profile_data_t cpstrf;
        profile_data_t cptcon;
        profile_data_t cpteqr;
        profile_data_t cptrfs;
        profile_data_t cptsv;
        profile_data_t cptsvx;
        profile_data_t cpttrf;
        profile_data_t cpttrs;
        profile_data_t cptts2;
        profile_data_t crot;
        profile_data_t cspcon;
        profile_data_t cspmv;
        profile_data_t cspr;
        profile_data_t csprfs;
        profile_data_t cspsv;
        profile_data_t cspsvx;
        profile_data_t csptrf;
        profile_data_t csptri;
        profile_data_t csptrs;
        profile_data_t csrscl;
        profile_data_t cstedc;
        profile_data_t cstegr;
        profile_data_t cstein;
        profile_data_t cstemr;
        profile_data_t csteqr;
        profile_data_t csycon;
        profile_data_t csycon_3;
        profile_data_t csycon_rook;
        profile_data_t csyconv;
        profile_data_t csyconvf;
        profile_data_t csyconvf_rook;
        profile_data_t csyequb;
        profile_data_t csymv;
        profile_data_t csyr;
        profile_data_t csyrfs;
        profile_data_t csysv;
        profile_data_t csysv_aa;
        profile_data_t csysv_aa_2stage;
        profile_data_t csysv_rk;
        profile_data_t csysv_rook;
        profile_data_t csysvx;
        profile_data_t csyswapr;
        profile_data_t csytf2;
        profile_data_t csytf2_rk;
        profile_data_t csytf2_rook;
        profile_data_t csytrf;
        profile_data_t csytrf_aa;
        profile_data_t csytrf_aa_2stage;
        profile_data_t csytrf_rk;
        profile_data_t csytrf_rook;
        profile_data_t csytri;
        profile_data_t csytri2;
        profile_data_t csytri2x;
        profile_data_t csytri_3;
        profile_data_t csytri_3x;
        profile_data_t csytri_rook;
        profile_data_t csytrs;
        profile_data_t csytrs2;
        profile_data_t csytrs_3;
        profile_data_t csytrs_aa;
        profile_data_t csytrs_aa_2stage;
        profile_data_t csytrs_rook;
        profile_data_t ctbcon;
        profile_data_t ctbrfs;
        profile_data_t ctbtrs;
        profile_data_t ctfsm;
        profile_data_t ctftri;
        profile_data_t ctfttp;
        profile_data_t ctfttr;
        profile_data_t ctgevc;
        profile_data_t ctgex2;
        profile_data_t ctgexc;
        profile_data_t ctgsen;
        profile_data_t ctgsja;
        profile_data_t ctgsna;
        profile_data_t ctgsy2;
        profile_data_t ctgsyl;
        profile_data_t ctpcon;
        profile_data_t ctplqt;
        profile_data_t ctplqt2;
        profile_data_t ctpmlqt;
        profile_data_t ctpmqrt;
        profile_data_t ctpqrt;
        profile_data_t ctpqrt2;
        profile_data_t ctprfb;
        profile_data_t ctprfs;
        profile_data_t ctptri;
        profile_data_t ctptrs;
        profile_data_t ctpttf;
        profile_data_t ctpttr;
        profile_data_t ctrcon;
        profile_data_t ctrevc;
        profile_data_t ctrevc3;
        profile_data_t ctrexc;
        profile_data_t ctrrfs;
        profile_data_t ctrsen;
        profile_data_t ctrsna;
        profile_data_t ctrsyl;
        profile_data_t ctrti2;
        profile_data_t ctrtri;
        profile_data_t ctrtrs;
        profile_data_t ctrttf;
        profile_data_t ctrttp;
        profile_data_t ctzrqf;
        profile_data_t ctzrzf;
        profile_data_t cunbdb;
        profile_data_t cunbdb1;
        profile_data_t cunbdb2;
        profile_data_t cunbdb3;
        profile_data_t cunbdb4;
        profile_data_t cunbdb5;
        profile_data_t cunbdb6;
        profile_data_t cuncsd;
        profile_data_t cuncsd2by1;
        profile_data_t cung2l;
        profile_data_t cung2r;
        profile_data_t cungbr;
        profile_data_t cunghr;
        profile_data_t cungl2;
        profile_data_t cunglq;
        profile_data_t cungql;
        profile_data_t cungqr;
        profile_data_t cungr2;
        profile_data_t cungrq;
        profile_data_t cungtr;
        profile_data_t cungtsqr;
        profile_data_t cunhr_col;
        profile_data_t cunm22;
        profile_data_t cunm2l;
        profile_data_t cunm2r;
        profile_data_t cunmbr;
        profile_data_t cunmhr;
        profile_data_t cunml2;
        profile_data_t cunmlq;
        profile_data_t cunmql;
        profile_data_t cunmqr;
        profile_data_t cunmr2;
        profile_data_t cunmr3;
        profile_data_t cunmrq;
        profile_data_t cunmrz;
        profile_data_t cunmtr;
        profile_data_t cupgtr;
        profile_data_t cupmtr;
        profile_data_t dbbcsd;
        profile_data_t dbdsdc;
        profile_data_t dbdsqr;
        profile_data_t dbdsvdx;
        profile_data_t dcombssq;
        profile_data_t ddisna;
        profile_data_t dgbbrd;
        profile_data_t dgbcon;
        profile_data_t dgbequ;
        profile_data_t dgbequb;
        profile_data_t dgbrfs;
        profile_data_t dgbsv;
        profile_data_t dgbsvx;
        profile_data_t dgbtf2;
        profile_data_t dgbtrf;
        profile_data_t dgbtrs;
        profile_data_t dgebak;
        profile_data_t dgebal;
        profile_data_t dgebd2;
        profile_data_t dgebrd;
        profile_data_t dgecon;
        profile_data_t dgeequ;
        profile_data_t dgeequb;
        profile_data_t dgees;
        profile_data_t dgeesx;
        profile_data_t dgeev;
        profile_data_t dgeevx;
        profile_data_t dgegs;
        profile_data_t dgegv;
        profile_data_t dgehd2;
        profile_data_t dgehrd;
        profile_data_t dgejsv;
        profile_data_t dgelq;
        profile_data_t dgelq2;
        profile_data_t dgelqf;
        profile_data_t dgelqt;
        profile_data_t dgelqt3;
        profile_data_t dgels;
        profile_data_t dgelsd;
        profile_data_t dgelss;
        profile_data_t dgelsx;
        profile_data_t dgelsy;
        profile_data_t dgemlq;
        profile_data_t dgemlqt;
        profile_data_t dgemqr;
        profile_data_t dgemqrt;
        profile_data_t dgeql2;
        profile_data_t dgeqlf;
        profile_data_t dgeqp3;
        profile_data_t dgeqpf;
        profile_data_t dgeqr;
        profile_data_t dgeqr2;
        profile_data_t dgeqr2p;
        profile_data_t dgeqrf;
        profile_data_t dgeqrfp;
        profile_data_t dgeqrt;
        profile_data_t dgeqrt2;
        profile_data_t dgeqrt3;
        profile_data_t dgerfs;
        profile_data_t dgerq2;
        profile_data_t dgerqf;
        profile_data_t dgesc2;
        profile_data_t dgesdd;
        profile_data_t dgesv;
        profile_data_t dgesvd;
        profile_data_t dgesvdq;
        profile_data_t dgesvdx;
        profile_data_t dgesvj;
        profile_data_t dgesvx;
        profile_data_t dgetc2;
        profile_data_t dgetf2;
        profile_data_t dgetrf;
        profile_data_t dgetrf2;
        profile_data_t dgetri;
        profile_data_t dgetrs;
        profile_data_t dgetsls;
        profile_data_t dggbak;
        profile_data_t dggbal;
        profile_data_t dgges;
        profile_data_t dgges3;
        profile_data_t dggesx;
        profile_data_t dggev;
        profile_data_t dggev3;
        profile_data_t dggevx;
        profile_data_t dggglm;
        profile_data_t dgghd3;
        profile_data_t dgghrd;
        profile_data_t dgglse;
        profile_data_t dggqrf;
        profile_data_t dggrqf;
        profile_data_t dggsvd;
        profile_data_t dggsvd3;
        profile_data_t dggsvp;
        profile_data_t dggsvp3;
        profile_data_t dgsvj0;
        profile_data_t dgsvj1;
        profile_data_t dgtcon;
        profile_data_t dgtrfs;
        profile_data_t dgtsv;
        profile_data_t dgtsvx;
        profile_data_t dgttrf;
        profile_data_t dgttrs;
        profile_data_t dgtts2;
        profile_data_t dhgeqz;
        profile_data_t dhsein;
        profile_data_t dhseqr;
        profile_data_t disnan;
        profile_data_t dlabad;
        profile_data_t dlabrd;
        profile_data_t dlacn2;
        profile_data_t dlacon;
        profile_data_t dlacpy;
        profile_data_t dladiv;
        profile_data_t dladiv1;
        profile_data_t dladiv2;
        profile_data_t dlae2;
        profile_data_t dlaebz;
        profile_data_t dlaed0;
        profile_data_t dlaed1;
        profile_data_t dlaed2;
        profile_data_t dlaed3;
        profile_data_t dlaed4;
        profile_data_t dlaed5;
        profile_data_t dlaed6;
        profile_data_t dlaed7;
        profile_data_t dlaed8;
        profile_data_t dlaed9;
        profile_data_t dlaeda;
        profile_data_t dlaein;
        profile_data_t dlaev2;
        profile_data_t dlaexc;
        profile_data_t dlag2;
        profile_data_t dlag2s;
        profile_data_t dlags2;
        profile_data_t dlagtf;
        profile_data_t dlagtm;
        profile_data_t dlagts;
        profile_data_t dlagv2;
        profile_data_t dlahqr;
        profile_data_t dlahr2;
        profile_data_t dlahrd;
        profile_data_t dlaic1;
        profile_data_t dlaisnan;
        profile_data_t dlaln2;
        profile_data_t dlals0;
        profile_data_t dlalsa;
        profile_data_t dlalsd;
        profile_data_t dlamch;
        profile_data_t dlamrg;
        profile_data_t dlamswlq;
        profile_data_t dlamtsqr;
        profile_data_t dlaneg;
        profile_data_t dlangb;
        profile_data_t dlange;
        profile_data_t dlangt;
        profile_data_t dlanhs;
        profile_data_t dlansb;
        profile_data_t dlansf;
        profile_data_t dlansp;
        profile_data_t dlanst;
        profile_data_t dlansy;
        profile_data_t dlantb;
        profile_data_t dlantp;
        profile_data_t dlantr;
        profile_data_t dlanv2;
        profile_data_t dlaorhr_col_getrfnp;
        profile_data_t dlaorhr_col_getrfnp2;
        profile_data_t dlapll;
        profile_data_t dlapmr;
        profile_data_t dlapmt;
        profile_data_t dlapy2;
        profile_data_t dlapy3;
        profile_data_t dlaqgb;
        profile_data_t dlaqge;
        profile_data_t dlaqp2;
        profile_data_t dlaqps;
        profile_data_t dlaqr0;
        profile_data_t dlaqr1;
        profile_data_t dlaqr2;
        profile_data_t dlaqr3;
        profile_data_t dlaqr4;
        profile_data_t dlaqr5;
        profile_data_t dlaqsb;
        profile_data_t dlaqsp;
        profile_data_t dlaqsy;
        profile_data_t dlaqtr;
        profile_data_t dlar1v;
        profile_data_t dlar2v;
        profile_data_t dlarf;
        profile_data_t dlarfb;
        profile_data_t dlarfg;
        profile_data_t dlarfgp;
        profile_data_t dlarft;
        profile_data_t dlarfx;
        profile_data_t dlarfy;
        profile_data_t dlargv;
        profile_data_t dlarnv;
        profile_data_t dlarra;
        profile_data_t dlarrb;
        profile_data_t dlarrc;
        profile_data_t dlarrd;
        profile_data_t dlarre;
        profile_data_t dlarrf;
        profile_data_t dlarrj;
        profile_data_t dlarrk;
        profile_data_t dlarrr;
        profile_data_t dlarrv;
        profile_data_t dlartg;
        profile_data_t dlartgp;
        profile_data_t dlartgs;
        profile_data_t dlartv;
        profile_data_t dlaruv;
        profile_data_t dlarz;
        profile_data_t dlarzb;
        profile_data_t dlarzt;
        profile_data_t dlas2;
        profile_data_t dlascl;
        profile_data_t dlasd0;
        profile_data_t dlasd1;
        profile_data_t dlasd2;
        profile_data_t dlasd3;
        profile_data_t dlasd4;
        profile_data_t dlasd5;
        profile_data_t dlasd6;
        profile_data_t dlasd7;
        profile_data_t dlasd8;
        profile_data_t dlasda;
        profile_data_t dlasdq;
        profile_data_t dlasdt;
        profile_data_t dlaset;
        profile_data_t dlasq1;
        profile_data_t dlasq2;
        profile_data_t dlasq3;
        profile_data_t dlasq4;
        profile_data_t dlasq5;
        profile_data_t dlasq6;
        profile_data_t dlasr;
        profile_data_t dlasrt;
        profile_data_t dlassq;
        profile_data_t dlasv2;
        profile_data_t dlaswlq;
        profile_data_t dlaswp;
        profile_data_t dlasy2;
        profile_data_t dlasyf;
        profile_data_t dlasyf_aa;
        profile_data_t dlasyf_rk;
        profile_data_t dlasyf_rook;
        profile_data_t dlat2s;
        profile_data_t dlatbs;
        profile_data_t dlatdf;
        profile_data_t dlatps;
        profile_data_t dlatrd;
        profile_data_t dlatrs;
        profile_data_t dlatrz;
        profile_data_t dlatsqr;
        profile_data_t dlatzm;
        profile_data_t dlauu2;
        profile_data_t dlauum;
        profile_data_t dopgtr;
        profile_data_t dopmtr;
        profile_data_t dorbdb;
        profile_data_t dorbdb1;
        profile_data_t dorbdb2;
        profile_data_t dorbdb3;
        profile_data_t dorbdb4;
        profile_data_t dorbdb5;
        profile_data_t dorbdb6;
        profile_data_t dorcsd;
        profile_data_t dorcsd2by1;
        profile_data_t dorg2l;
        profile_data_t dorg2r;
        profile_data_t dorgbr;
        profile_data_t dorghr;
        profile_data_t dorgl2;
        profile_data_t dorglq;
        profile_data_t dorgql;
        profile_data_t dorgqr;
        profile_data_t dorgr2;
        profile_data_t dorgrq;
        profile_data_t dorgtr;
        profile_data_t dorgtsqr;
        profile_data_t dorhr_col;
        profile_data_t dorm22;
        profile_data_t dorm2l;
        profile_data_t dorm2r;
        profile_data_t dormbr;
        profile_data_t dormhr;
        profile_data_t dorml2;
        profile_data_t dormlq;
        profile_data_t dormql;
        profile_data_t dormqr;
        profile_data_t dormr2;
        profile_data_t dormr3;
        profile_data_t dormrq;
        profile_data_t dormrz;
        profile_data_t dormtr;
        profile_data_t dpbcon;
        profile_data_t dpbequ;
        profile_data_t dpbrfs;
        profile_data_t dpbstf;
        profile_data_t dpbsv;
        profile_data_t dpbsvx;
        profile_data_t dpbtf2;
        profile_data_t dpbtrf;
        profile_data_t dpbtrs;
        profile_data_t dpftrf;
        profile_data_t dpftri;
        profile_data_t dpftrs;
        profile_data_t dpocon;
        profile_data_t dpoequ;
        profile_data_t dpoequb;
        profile_data_t dporfs;
        profile_data_t dposv;
        profile_data_t dposvx;
        profile_data_t dpotf2;
        profile_data_t dpotrf;
        profile_data_t dpotrf2;
        profile_data_t dpotri;
        profile_data_t dpotrs;
        profile_data_t dppcon;
        profile_data_t dppequ;
        profile_data_t dpprfs;
        profile_data_t dppsv;
        profile_data_t dppsvx;
        profile_data_t dpptrf;
        profile_data_t dpptri;
        profile_data_t dpptrs;
        profile_data_t dpstf2;
        profile_data_t dpstrf;
        profile_data_t dptcon;
        profile_data_t dpteqr;
        profile_data_t dptrfs;
        profile_data_t dptsv;
        profile_data_t dptsvx;
        profile_data_t dpttrf;
        profile_data_t dpttrs;
        profile_data_t dptts2;
        profile_data_t drscl;
        profile_data_t dsb2st_kernels;
        profile_data_t dsbev;
        profile_data_t dsbev_2stage;
        profile_data_t dsbevd;
        profile_data_t dsbevd_2stage;
        profile_data_t dsbevx;
        profile_data_t dsbevx_2stage;
        profile_data_t dsbgst;
        profile_data_t dsbgv;
        profile_data_t dsbgvd;
        profile_data_t dsbgvx;
        profile_data_t dsbtrd;
        profile_data_t dsecnd;
        profile_data_t dsfrk;
        profile_data_t dsgesv;
        profile_data_t dspcon;
        profile_data_t dspev;
        profile_data_t dspevd;
        profile_data_t dspevx;
        profile_data_t dspgst;
        profile_data_t dspgv;
        profile_data_t dspgvd;
        profile_data_t dspgvx;
        profile_data_t dsposv;
        profile_data_t dsprfs;
        profile_data_t dspsv;
        profile_data_t dspsvx;
        profile_data_t dsptrd;
        profile_data_t dsptrf;
        profile_data_t dsptri;
        profile_data_t dsptrs;
        profile_data_t dstebz;
        profile_data_t dstedc;
        profile_data_t dstegr;
        profile_data_t dstein;
        profile_data_t dstemr;
        profile_data_t dsteqr;
        profile_data_t dsterf;
        profile_data_t dstev;
        profile_data_t dstevd;
        profile_data_t dstevr;
        profile_data_t dstevx;
        profile_data_t dsycon;
        profile_data_t dsycon_3;
        profile_data_t dsycon_rook;
        profile_data_t dsyconv;
        profile_data_t dsyconvf;
        profile_data_t dsyconvf_rook;
        profile_data_t dsyequb;
        profile_data_t dsyev;
        profile_data_t dsyev_2stage;
        profile_data_t dsyevd;
        profile_data_t dsyevd_2stage;
        profile_data_t dsyevr;
        profile_data_t dsyevr_2stage;
        profile_data_t dsyevx;
        profile_data_t dsyevx_2stage;
        profile_data_t dsygs2;
        profile_data_t dsygst;
        profile_data_t dsygv;
        profile_data_t dsygv_2stage;
        profile_data_t dsygvd;
        profile_data_t dsygvx;
        profile_data_t dsyrfs;
        profile_data_t dsysv;
        profile_data_t dsysv_aa;
        profile_data_t dsysv_aa_2stage;
        profile_data_t dsysv_rk;
        profile_data_t dsysv_rook;
        profile_data_t dsysvx;
        profile_data_t dsyswapr;
        profile_data_t dsytd2;
        profile_data_t dsytf2;
        profile_data_t dsytf2_rk;
        profile_data_t dsytf2_rook;
        profile_data_t dsytrd;
        profile_data_t dsytrd_2stage;
        profile_data_t dsytrd_sb2st;
        profile_data_t dsytrd_sy2sb;
        profile_data_t dsytrf;
        profile_data_t dsytrf_aa;
        profile_data_t dsytrf_aa_2stage;
        profile_data_t dsytrf_rk;
        profile_data_t dsytrf_rook;
        profile_data_t dsytri;
        profile_data_t dsytri2;
        profile_data_t dsytri2x;
        profile_data_t dsytri_3;
        profile_data_t dsytri_3x;
        profile_data_t dsytri_rook;
        profile_data_t dsytrs;
        profile_data_t dsytrs2;
        profile_data_t dsytrs_3;
        profile_data_t dsytrs_aa;
        profile_data_t dsytrs_aa_2stage;
        profile_data_t dsytrs_rook;
        profile_data_t dtbcon;
        profile_data_t dtbrfs;
        profile_data_t dtbtrs;
        profile_data_t dtfsm;
        profile_data_t dtftri;
        profile_data_t dtfttp;
        profile_data_t dtfttr;
        profile_data_t dtgevc;
        profile_data_t dtgex2;
        profile_data_t dtgexc;
        profile_data_t dtgsen;
        profile_data_t dtgsja;
        profile_data_t dtgsna;
        profile_data_t dtgsy2;
        profile_data_t dtgsyl;
        profile_data_t dtpcon;
        profile_data_t dtplqt;
        profile_data_t dtplqt2;
        profile_data_t dtpmlqt;
        profile_data_t dtpmqrt;
        profile_data_t dtpqrt;
        profile_data_t dtpqrt2;
        profile_data_t dtprfb;
        profile_data_t dtprfs;
        profile_data_t dtptri;
        profile_data_t dtptrs;
        profile_data_t dtpttf;
        profile_data_t dtpttr;
        profile_data_t dtrcon;
        profile_data_t dtrevc;
        profile_data_t dtrevc3;
        profile_data_t dtrexc;
        profile_data_t dtrrfs;
        profile_data_t dtrsen;
        profile_data_t dtrsna;
        profile_data_t dtrsyl;
        profile_data_t dtrti2;
        profile_data_t dtrtri;
        profile_data_t dtrtrs;
        profile_data_t dtrttf;
        profile_data_t dtrttp;
        profile_data_t dtzrqf;
        profile_data_t dtzrzf;
        profile_data_t dzsum1;
        profile_data_t icmax1;
        profile_data_t ieeeck;
        profile_data_t ilaclc;
        profile_data_t ilaclr;
        profile_data_t iladiag;
        profile_data_t iladlc;
        profile_data_t iladlr;
        profile_data_t ilaenv;
        profile_data_t ilaenv2stage;
        profile_data_t ilaprec;
        profile_data_t ilaslc;
        profile_data_t ilaslr;
        profile_data_t ilatrans;
        profile_data_t ilauplo;
        profile_data_t ilazlc;
        profile_data_t ilazlr;
        profile_data_t iparam2stage;
        profile_data_t iparmq;
        profile_data_t izmax1;
        profile_data_t sbbcsd;
        profile_data_t sbdsdc;
        profile_data_t sbdsqr;
        profile_data_t sbdsvdx;
        profile_data_t scombssq;
        profile_data_t scsum1;
        profile_data_t sdisna;
        profile_data_t second;
        profile_data_t sgbbrd;
        profile_data_t sgbcon;
        profile_data_t sgbequ;
        profile_data_t sgbequb;
        profile_data_t sgbrfs;
        profile_data_t sgbsv;
        profile_data_t sgbsvx;
        profile_data_t sgbtf2;
        profile_data_t sgbtrf;
        profile_data_t sgbtrs;
        profile_data_t sgebak;
        profile_data_t sgebal;
        profile_data_t sgebd2;
        profile_data_t sgebrd;
        profile_data_t sgecon;
        profile_data_t sgeequ;
        profile_data_t sgeequb;
        profile_data_t sgees;
        profile_data_t sgeesx;
        profile_data_t sgeev;
        profile_data_t sgeevx;
        profile_data_t sgegs;
        profile_data_t sgegv;
        profile_data_t sgehd2;
        profile_data_t sgehrd;
        profile_data_t sgejsv;
        profile_data_t sgelq;
        profile_data_t sgelq2;
        profile_data_t sgelqf;
        profile_data_t sgelqt;
        profile_data_t sgelqt3;
        profile_data_t sgels;
        profile_data_t sgelsd;
        profile_data_t sgelss;
        profile_data_t sgelsx;
        profile_data_t sgelsy;
        profile_data_t sgemlq;
        profile_data_t sgemlqt;
        profile_data_t sgemqr;
        profile_data_t sgemqrt;
        profile_data_t sgeql2;
        profile_data_t sgeqlf;
        profile_data_t sgeqp3;
        profile_data_t sgeqpf;
        profile_data_t sgeqr;
        profile_data_t sgeqr2;
        profile_data_t sgeqr2p;
        profile_data_t sgeqrf;
        profile_data_t sgeqrfp;
        profile_data_t sgeqrt;
        profile_data_t sgeqrt2;
        profile_data_t sgeqrt3;
        profile_data_t sgerfs;
        profile_data_t sgerq2;
        profile_data_t sgerqf;
        profile_data_t sgesc2;
        profile_data_t sgesdd;
        profile_data_t sgesv;
        profile_data_t sgesvd;
        profile_data_t sgesvdq;
        profile_data_t sgesvdx;
        profile_data_t sgesvj;
        profile_data_t sgesvx;
        profile_data_t sgetc2;
        profile_data_t sgetf2;
        profile_data_t sgetrf;
        profile_data_t sgetrf2;
        profile_data_t sgetri;
        profile_data_t sgetrs;
        profile_data_t sgetsls;
        profile_data_t sggbak;
        profile_data_t sggbal;
        profile_data_t sgges;
        profile_data_t sgges3;
        profile_data_t sggesx;
        profile_data_t sggev;
        profile_data_t sggev3;
        profile_data_t sggevx;
        profile_data_t sggglm;
        profile_data_t sgghd3;
        profile_data_t sgghrd;
        profile_data_t sgglse;
        profile_data_t sggqrf;
        profile_data_t sggrqf;
        profile_data_t sggsvd;
        profile_data_t sggsvd3;
        profile_data_t sggsvp;
        profile_data_t sggsvp3;
        profile_data_t sgsvj0;
        profile_data_t sgsvj1;
        profile_data_t sgtcon;
        profile_data_t sgtrfs;
        profile_data_t sgtsv;
        profile_data_t sgtsvx;
        profile_data_t sgttrf;
        profile_data_t sgttrs;
        profile_data_t sgtts2;
        profile_data_t shgeqz;
        profile_data_t shsein;
        profile_data_t shseqr;
        profile_data_t sisnan;
        profile_data_t slabad;
        profile_data_t slabrd;
        profile_data_t slacn2;
        profile_data_t slacon;
        profile_data_t slacpy;
        profile_data_t sladiv;
        profile_data_t sladiv1;
        profile_data_t sladiv2;
        profile_data_t slae2;
        profile_data_t slaebz;
        profile_data_t slaed0;
        profile_data_t slaed1;
        profile_data_t slaed2;
        profile_data_t slaed3;
        profile_data_t slaed4;
        profile_data_t slaed5;
        profile_data_t slaed6;
        profile_data_t slaed7;
        profile_data_t slaed8;
        profile_data_t slaed9;
        profile_data_t slaeda;
        profile_data_t slaein;
        profile_data_t slaev2;
        profile_data_t slaexc;
        profile_data_t slag2;
        profile_data_t slag2d;
        profile_data_t slags2;
        profile_data_t slagtf;
        profile_data_t slagtm;
        profile_data_t slagts;
        profile_data_t slagv2;
        profile_data_t slahqr;
        profile_data_t slahr2;
        profile_data_t slahrd;
        profile_data_t slaic1;
        profile_data_t slaisnan;
        profile_data_t slaln2;
        profile_data_t slals0;
        profile_data_t slalsa;
        profile_data_t slalsd;
        profile_data_t slamch;
        profile_data_t slamrg;
        profile_data_t slamswlq;
        profile_data_t slamtsqr;
        profile_data_t slaneg;
        profile_data_t slangb;
        profile_data_t slange;
        profile_data_t slangt;
        profile_data_t slanhs;
        profile_data_t slansb;
        profile_data_t slansf;
        profile_data_t slansp;
        profile_data_t slanst;
        profile_data_t slansy;
        profile_data_t slantb;
        profile_data_t slantp;
        profile_data_t slantr;
        profile_data_t slanv2;
        profile_data_t slaorhr_col_getrfnp;
        profile_data_t slaorhr_col_getrfnp2;
        profile_data_t slapll;
        profile_data_t slapmr;
        profile_data_t slapmt;
        profile_data_t slapy2;
        profile_data_t slapy3;
        profile_data_t slaqgb;
        profile_data_t slaqge;
        profile_data_t slaqp2;
        profile_data_t slaqps;
        profile_data_t slaqr0;
        profile_data_t slaqr1;
        profile_data_t slaqr2;
        profile_data_t slaqr3;
        profile_data_t slaqr4;
        profile_data_t slaqr5;
        profile_data_t slaqsb;
        profile_data_t slaqsp;
        profile_data_t slaqsy;
        profile_data_t slaqtr;
        profile_data_t slar1v;
        profile_data_t slar2v;
        profile_data_t slarf;
        profile_data_t slarfb;
        profile_data_t slarfg;
        profile_data_t slarfgp;
        profile_data_t slarft;
        profile_data_t slarfx;
        profile_data_t slarfy;
        profile_data_t slargv;
        profile_data_t slarnv;
        profile_data_t slarra;
        profile_data_t slarrb;
        profile_data_t slarrc;
        profile_data_t slarrd;
        profile_data_t slarre;
        profile_data_t slarrf;
        profile_data_t slarrj;
        profile_data_t slarrk;
        profile_data_t slarrr;
        profile_data_t slarrv;
        profile_data_t slartg;
        profile_data_t slartgp;
        profile_data_t slartgs;
        profile_data_t slartv;
        profile_data_t slaruv;
        profile_data_t slarz;
        profile_data_t slarzb;
        profile_data_t slarzt;
        profile_data_t slas2;
        profile_data_t slascl;
        profile_data_t slasd0;
        profile_data_t slasd1;
        profile_data_t slasd2;
        profile_data_t slasd3;
        profile_data_t slasd4;
        profile_data_t slasd5;
        profile_data_t slasd6;
        profile_data_t slasd7;
        profile_data_t slasd8;
        profile_data_t slasda;
        profile_data_t slasdq;
        profile_data_t slasdt;
        profile_data_t slaset;
        profile_data_t slasq1;
        profile_data_t slasq2;
        profile_data_t slasq3;
        profile_data_t slasq4;
        profile_data_t slasq5;
        profile_data_t slasq6;
        profile_data_t slasr;
        profile_data_t slasrt;
        profile_data_t slassq;
        profile_data_t slasv2;
        profile_data_t slaswlq;
        profile_data_t slaswp;
        profile_data_t slasy2;
        profile_data_t slasyf;
        profile_data_t slasyf_aa;
        profile_data_t slasyf_rk;
        profile_data_t slasyf_rook;
        profile_data_t slatbs;
        profile_data_t slatdf;
        profile_data_t slatps;
        profile_data_t slatrd;
        profile_data_t slatrs;
        profile_data_t slatrz;
        profile_data_t slatsqr;
        profile_data_t slatzm;
        profile_data_t slauu2;
        profile_data_t slauum;
        profile_data_t sopgtr;
        profile_data_t sopmtr;
        profile_data_t sorbdb;
        profile_data_t sorbdb1;
        profile_data_t sorbdb2;
        profile_data_t sorbdb3;
        profile_data_t sorbdb4;
        profile_data_t sorbdb5;
        profile_data_t sorbdb6;
        profile_data_t sorcsd;
        profile_data_t sorcsd2by1;
        profile_data_t sorg2l;
        profile_data_t sorg2r;
        profile_data_t sorgbr;
        profile_data_t sorghr;
        profile_data_t sorgl2;
        profile_data_t sorglq;
        profile_data_t sorgql;
        profile_data_t sorgqr;
        profile_data_t sorgr2;
        profile_data_t sorgrq;
        profile_data_t sorgtr;
        profile_data_t sorgtsqr;
        profile_data_t sorhr_col;
        profile_data_t sorm22;
        profile_data_t sorm2l;
        profile_data_t sorm2r;
        profile_data_t sormbr;
        profile_data_t sormhr;
        profile_data_t sorml2;
        profile_data_t sormlq;
        profile_data_t sormql;
        profile_data_t sormqr;
        profile_data_t sormr2;
        profile_data_t sormr3;
        profile_data_t sormrq;
        profile_data_t sormrz;
        profile_data_t sormtr;
        profile_data_t spbcon;
        profile_data_t spbequ;
        profile_data_t spbrfs;
        profile_data_t spbstf;
        profile_data_t spbsv;
        profile_data_t spbsvx;
        profile_data_t spbtf2;
        profile_data_t spbtrf;
        profile_data_t spbtrs;
        profile_data_t spftrf;
        profile_data_t spftri;
        profile_data_t spftrs;
        profile_data_t spocon;
        profile_data_t spoequ;
        profile_data_t spoequb;
        profile_data_t sporfs;
        profile_data_t sposv;
        profile_data_t sposvx;
        profile_data_t spotf2;
        profile_data_t spotrf;
        profile_data_t spotrf2;
        profile_data_t spotri;
        profile_data_t spotrs;
        profile_data_t sppcon;
        profile_data_t sppequ;
        profile_data_t spprfs;
        profile_data_t sppsv;
        profile_data_t sppsvx;
        profile_data_t spptrf;
        profile_data_t spptri;
        profile_data_t spptrs;
        profile_data_t spstf2;
        profile_data_t spstrf;
        profile_data_t sptcon;
        profile_data_t spteqr;
        profile_data_t sptrfs;
        profile_data_t sptsv;
        profile_data_t sptsvx;
        profile_data_t spttrf;
        profile_data_t spttrs;
        profile_data_t sptts2;
        profile_data_t srscl;
        profile_data_t ssb2st_kernels;
        profile_data_t ssbev;
        profile_data_t ssbev_2stage;
        profile_data_t ssbevd;
        profile_data_t ssbevd_2stage;
        profile_data_t ssbevx;
        profile_data_t ssbevx_2stage;
        profile_data_t ssbgst;
        profile_data_t ssbgv;
        profile_data_t ssbgvd;
        profile_data_t ssbgvx;
        profile_data_t ssbtrd;
        profile_data_t ssfrk;
        profile_data_t sspcon;
        profile_data_t sspev;
        profile_data_t sspevd;
        profile_data_t sspevx;
        profile_data_t sspgst;
        profile_data_t sspgv;
        profile_data_t sspgvd;
        profile_data_t sspgvx;
        profile_data_t ssprfs;
        profile_data_t sspsv;
        profile_data_t sspsvx;
        profile_data_t ssptrd;
        profile_data_t ssptrf;
        profile_data_t ssptri;
        profile_data_t ssptrs;
        profile_data_t sstebz;
        profile_data_t sstedc;
        profile_data_t sstegr;
        profile_data_t sstein;
        profile_data_t sstemr;
        profile_data_t ssteqr;
        profile_data_t ssterf;
        profile_data_t sstev;
        profile_data_t sstevd;
        profile_data_t sstevr;
        profile_data_t sstevx;
        profile_data_t ssycon;
        profile_data_t ssycon_3;
        profile_data_t ssycon_rook;
        profile_data_t ssyconv;
        profile_data_t ssyconvf;
        profile_data_t ssyconvf_rook;
        profile_data_t ssyequb;
        profile_data_t ssyev;
        profile_data_t ssyev_2stage;
        profile_data_t ssyevd;
        profile_data_t ssyevd_2stage;
        profile_data_t ssyevr;
        profile_data_t ssyevr_2stage;
        profile_data_t ssyevx;
        profile_data_t ssyevx_2stage;
        profile_data_t ssygs2;
        profile_data_t ssygst;
        profile_data_t ssygv;
        profile_data_t ssygv_2stage;
        profile_data_t ssygvd;
        profile_data_t ssygvx;
        profile_data_t ssyrfs;
        profile_data_t ssysv;
        profile_data_t ssysv_aa;
        profile_data_t ssysv_aa_2stage;
        profile_data_t ssysv_rk;
        profile_data_t ssysv_rook;
        profile_data_t ssysvx;
        profile_data_t ssyswapr;
        profile_data_t ssytd2;
        profile_data_t ssytf2;
        profile_data_t ssytf2_rk;
        profile_data_t ssytf2_rook;
        profile_data_t ssytrd;
        profile_data_t ssytrd_2stage;
        profile_data_t ssytrd_sb2st;
        profile_data_t ssytrd_sy2sb;
        profile_data_t ssytrf;
        profile_data_t ssytrf_aa;
        profile_data_t ssytrf_aa_2stage;
        profile_data_t ssytrf_rk;
        profile_data_t ssytrf_rook;
        profile_data_t ssytri;
        profile_data_t ssytri2;
        profile_data_t ssytri2x;
        profile_data_t ssytri_3;
        profile_data_t ssytri_3x;
        profile_data_t ssytri_rook;
        profile_data_t ssytrs;
        profile_data_t ssytrs2;
        profile_data_t ssytrs_3;
        profile_data_t ssytrs_aa;
        profile_data_t ssytrs_aa_2stage;
        profile_data_t ssytrs_rook;
        profile_data_t stbcon;
        profile_data_t stbrfs;
        profile_data_t stbtrs;
        profile_data_t stfsm;
        profile_data_t stftri;
        profile_data_t stfttp;
        profile_data_t stfttr;
        profile_data_t stgevc;
        profile_data_t stgex2;
        profile_data_t stgexc;
        profile_data_t stgsen;
        profile_data_t stgsja;
        profile_data_t stgsna;
        profile_data_t stgsy2;
        profile_data_t stgsyl;
        profile_data_t stpcon;
        profile_data_t stplqt;
        profile_data_t stplqt2;
        profile_data_t stpmlqt;
        profile_data_t stpmqrt;
        profile_data_t stpqrt;
        profile_data_t stpqrt2;
        profile_data_t stprfb;
        profile_data_t stprfs;
        profile_data_t stptri;
        profile_data_t stptrs;
        profile_data_t stpttf;
        profile_data_t stpttr;
        profile_data_t strcon;
        profile_data_t strevc;
        profile_data_t strevc3;
        profile_data_t strexc;
        profile_data_t strrfs;
        profile_data_t strsen;
        profile_data_t strsna;
        profile_data_t strsyl;
        profile_data_t strti2;
        profile_data_t strtri;
        profile_data_t strtrs;
        profile_data_t strttf;
        profile_data_t strttp;
        profile_data_t stzrqf;
        profile_data_t stzrzf;
        profile_data_t xerbla_array;
        profile_data_t zbbcsd;
        profile_data_t zbdsqr;
        profile_data_t zcgesv;
        profile_data_t zcposv;
        profile_data_t zdrscl;
        profile_data_t zgbbrd;
        profile_data_t zgbcon;
        profile_data_t zgbequ;
        profile_data_t zgbequb;
        profile_data_t zgbrfs;
        profile_data_t zgbsv;
        profile_data_t zgbsvx;
        profile_data_t zgbtf2;
        profile_data_t zgbtrf;
        profile_data_t zgbtrs;
        profile_data_t zgebak;
        profile_data_t zgebal;
        profile_data_t zgebd2;
        profile_data_t zgebrd;
        profile_data_t zgecon;
        profile_data_t zgeequ;
        profile_data_t zgeequb;
        profile_data_t zgees;
        profile_data_t zgeesx;
        profile_data_t zgeev;
        profile_data_t zgeevx;
        profile_data_t zgegs;
        profile_data_t zgegv;
        profile_data_t zgehd2;
        profile_data_t zgehrd;
        profile_data_t zgejsv;
        profile_data_t zgelq;
        profile_data_t zgelq2;
        profile_data_t zgelqf;
        profile_data_t zgelqt;
        profile_data_t zgelqt3;
        profile_data_t zgels;
        profile_data_t zgelsd;
        profile_data_t zgelss;
        profile_data_t zgelsx;
        profile_data_t zgelsy;
        profile_data_t zgemlq;
        profile_data_t zgemlqt;
        profile_data_t zgemqr;
        profile_data_t zgemqrt;
        profile_data_t zgeql2;
        profile_data_t zgeqlf;
        profile_data_t zgeqp3;
        profile_data_t zgeqpf;
        profile_data_t zgeqr;
        profile_data_t zgeqr2;
        profile_data_t zgeqr2p;
        profile_data_t zgeqrf;
        profile_data_t zgeqrfp;
        profile_data_t zgeqrt;
        profile_data_t zgeqrt2;
        profile_data_t zgeqrt3;
        profile_data_t zgerfs;
        profile_data_t zgerq2;
        profile_data_t zgerqf;
        profile_data_t zgesc2;
        profile_data_t zgesdd;
        profile_data_t zgesv;
        profile_data_t zgesvd;
        profile_data_t zgesvdq;
        profile_data_t zgesvdx;
        profile_data_t zgesvj;
        profile_data_t zgesvx;
        profile_data_t zgetc2;
        profile_data_t zgetf2;
        profile_data_t zgetrf;
        profile_data_t zgetrf2;
        profile_data_t zgetri;
        profile_data_t zgetrs;
        profile_data_t zgetsls;
        profile_data_t zggbak;
        profile_data_t zggbal;
        profile_data_t zgges;
        profile_data_t zgges3;
        profile_data_t zggesx;
        profile_data_t zggev;
        profile_data_t zggev3;
        profile_data_t zggevx;
        profile_data_t zggglm;
        profile_data_t zgghd3;
        profile_data_t zgghrd;
        profile_data_t zgglse;
        profile_data_t zggqrf;
        profile_data_t zggrqf;
        profile_data_t zggsvd;
        profile_data_t zggsvd3;
        profile_data_t zggsvp;
        profile_data_t zggsvp3;
        profile_data_t zgsvj0;
        profile_data_t zgsvj1;
        profile_data_t zgtcon;
        profile_data_t zgtrfs;
        profile_data_t zgtsv;
        profile_data_t zgtsvx;
        profile_data_t zgttrf;
        profile_data_t zgttrs;
        profile_data_t zgtts2;
        profile_data_t zhb2st_kernels;
        profile_data_t zhbev;
        profile_data_t zhbev_2stage;
        profile_data_t zhbevd;
        profile_data_t zhbevd_2stage;
        profile_data_t zhbevx;
        profile_data_t zhbevx_2stage;
        profile_data_t zhbgst;
        profile_data_t zhbgv;
        profile_data_t zhbgvd;
        profile_data_t zhbgvx;
        profile_data_t zhbtrd;
        profile_data_t zhecon;
        profile_data_t zhecon_3;
        profile_data_t zhecon_rook;
        profile_data_t zheequb;
        profile_data_t zheev;
        profile_data_t zheev_2stage;
        profile_data_t zheevd;
        profile_data_t zheevd_2stage;
        profile_data_t zheevr;
        profile_data_t zheevr_2stage;
        profile_data_t zheevx;
        profile_data_t zheevx_2stage;
        profile_data_t zhegs2;
        profile_data_t zhegst;
        profile_data_t zhegv;
        profile_data_t zhegv_2stage;
        profile_data_t zhegvd;
        profile_data_t zhegvx;
        profile_data_t zherfs;
        profile_data_t zhesv;
        profile_data_t zhesv_aa;
        profile_data_t zhesv_aa_2stage;
        profile_data_t zhesv_rk;
        profile_data_t zhesv_rook;
        profile_data_t zhesvx;
        profile_data_t zheswapr;
        profile_data_t zhetd2;
        profile_data_t zhetf2;
        profile_data_t zhetf2_rk;
        profile_data_t zhetf2_rook;
        profile_data_t zhetrd;
        profile_data_t zhetrd_2stage;
        profile_data_t zhetrd_hb2st;
        profile_data_t zhetrd_he2hb;
        profile_data_t zhetrf;
        profile_data_t zhetrf_aa;
        profile_data_t zhetrf_aa_2stage;
        profile_data_t zhetrf_rk;
        profile_data_t zhetrf_rook;
        profile_data_t zhetri;
        profile_data_t zhetri2;
        profile_data_t zhetri2x;
        profile_data_t zhetri_3;
        profile_data_t zhetri_3x;
        profile_data_t zhetri_rook;
        profile_data_t zhetrs;
        profile_data_t zhetrs2;
        profile_data_t zhetrs_3;
        profile_data_t zhetrs_aa;
        profile_data_t zhetrs_aa_2stage;
        profile_data_t zhetrs_rook;
        profile_data_t zhfrk;
        profile_data_t zhgeqz;
        profile_data_t zhpcon;
        profile_data_t zhpev;
        profile_data_t zhpevd;
        profile_data_t zhpevx;
        profile_data_t zhpgst;
        profile_data_t zhpgv;
        profile_data_t zhpgvd;
        profile_data_t zhpgvx;
        profile_data_t zhprfs;
        profile_data_t zhpsv;
        profile_data_t zhpsvx;
        profile_data_t zhptrd;
        profile_data_t zhptrf;
        profile_data_t zhptri;
        profile_data_t zhptrs;
        profile_data_t zhsein;
        profile_data_t zhseqr;
        profile_data_t zlabrd;
        profile_data_t zlacgv;
        profile_data_t zlacn2;
        profile_data_t zlacon;
        profile_data_t zlacp2;
        profile_data_t zlacpy;
        profile_data_t zlacrm;
        profile_data_t zlacrt;
        profile_data_t zladiv;
        profile_data_t zlaed0;
        profile_data_t zlaed7;
        profile_data_t zlaed8;
        profile_data_t zlaein;
        profile_data_t zlaesy;
        profile_data_t zlaev2;
        profile_data_t zlag2c;
        profile_data_t zlags2;
        profile_data_t zlagtm;
        profile_data_t zlahef;
        profile_data_t zlahef_aa;
        profile_data_t zlahef_rk;
        profile_data_t zlahef_rook;
        profile_data_t zlahqr;
        profile_data_t zlahr2;
        profile_data_t zlahrd;
        profile_data_t zlaic1;
        profile_data_t zlals0;
        profile_data_t zlalsa;
        profile_data_t zlalsd;
        profile_data_t zlamswlq;
        profile_data_t zlamtsqr;
        profile_data_t zlangb;
        profile_data_t zlange;
        profile_data_t zlangt;
        profile_data_t zlanhb;
        profile_data_t zlanhe;
        profile_data_t zlanhf;
        profile_data_t zlanhp;
        profile_data_t zlanhs;
        profile_data_t zlanht;
        profile_data_t zlansb;
        profile_data_t zlansp;
        profile_data_t zlansy;
        profile_data_t zlantb;
        profile_data_t zlantp;
        profile_data_t zlantr;
        profile_data_t zlapll;
        profile_data_t zlapmr;
        profile_data_t zlapmt;
        profile_data_t zlaqgb;
        profile_data_t zlaqge;
        profile_data_t zlaqhb;
        profile_data_t zlaqhe;
        profile_data_t zlaqhp;
        profile_data_t zlaqp2;
        profile_data_t zlaqps;
        profile_data_t zlaqr0;
        profile_data_t zlaqr1;
        profile_data_t zlaqr2;
        profile_data_t zlaqr3;
        profile_data_t zlaqr4;
        profile_data_t zlaqr5;
        profile_data_t zlaqsb;
        profile_data_t zlaqsp;
        profile_data_t zlaqsy;
        profile_data_t zlar1v;
        profile_data_t zlar2v;
        profile_data_t zlarcm;
        profile_data_t zlarf;
        profile_data_t zlarfb;
        profile_data_t zlarfg;
        profile_data_t zlarfgp;
        profile_data_t zlarft;
        profile_data_t zlarfx;
        profile_data_t zlarfy;
        profile_data_t zlargv;
        profile_data_t zlarnv;
        profile_data_t zlarrv;
        profile_data_t zlartg;
        profile_data_t zlartv;
        profile_data_t zlarz;
        profile_data_t zlarzb;
        profile_data_t zlarzt;
        profile_data_t zlascl;
        profile_data_t zlaset;
        profile_data_t zlasr;
        profile_data_t zlassq;
        profile_data_t zlaswlq;
        profile_data_t zlaswp;
        profile_data_t zlasyf;
        profile_data_t zlasyf_aa;
        profile_data_t zlasyf_rk;
        profile_data_t zlasyf_rook;
        profile_data_t zlat2c;
        profile_data_t zlatbs;
        profile_data_t zlatdf;
        profile_data_t zlatps;
        profile_data_t zlatrd;
        profile_data_t zlatrs;
        profile_data_t zlatrz;
        profile_data_t zlatsqr;
        profile_data_t zlatzm;
        profile_data_t zlaunhr_col_getrfnp;
        profile_data_t zlaunhr_col_getrfnp2;
        profile_data_t zlauu2;
        profile_data_t zlauum;
        profile_data_t zpbcon;
        profile_data_t zpbequ;
        profile_data_t zpbrfs;
        profile_data_t zpbstf;
        profile_data_t zpbsv;
        profile_data_t zpbsvx;
        profile_data_t zpbtf2;
        profile_data_t zpbtrf;
        profile_data_t zpbtrs;
        profile_data_t zpftrf;
        profile_data_t zpftri;
        profile_data_t zpftrs;
        profile_data_t zpocon;
        profile_data_t zpoequ;
        profile_data_t zpoequb;
        profile_data_t zporfs;
        profile_data_t zposv;
        profile_data_t zposvx;
        profile_data_t zpotf2;
        profile_data_t zpotrf;
        profile_data_t zpotrf2;
        profile_data_t zpotri;
        profile_data_t zpotrs;
        profile_data_t zppcon;
        profile_data_t zppequ;
        profile_data_t zpprfs;
        profile_data_t zppsv;
        profile_data_t zppsvx;
        profile_data_t zpptrf;
        profile_data_t zpptri;
        profile_data_t zpptrs;
        profile_data_t zpstf2;
        profile_data_t zpstrf;
        profile_data_t zptcon;
        profile_data_t zpteqr;
        profile_data_t zptrfs;
        profile_data_t zptsv;
        profile_data_t zptsvx;
        profile_data_t zpttrf;
        profile_data_t zpttrs;
        profile_data_t zptts2;
        profile_data_t zrot;
        profile_data_t zspcon;
        profile_data_t zspmv;
        profile_data_t zspr;
        profile_data_t zsprfs;
        profile_data_t zspsv;
        profile_data_t zspsvx;
        profile_data_t zsptrf;
        profile_data_t zsptri;
        profile_data_t zsptrs;
        profile_data_t zstedc;
        profile_data_t zstegr;
        profile_data_t zstein;
        profile_data_t zstemr;
        profile_data_t zsteqr;
        profile_data_t zsycon;
        profile_data_t zsycon_3;
        profile_data_t zsycon_rook;
        profile_data_t zsyconv;
        profile_data_t zsyconvf;
        profile_data_t zsyconvf_rook;
        profile_data_t zsyequb;
        profile_data_t zsymv;
        profile_data_t zsyr;
        profile_data_t zsyrfs;
        profile_data_t zsysv;
        profile_data_t zsysv_aa;
        profile_data_t zsysv_aa_2stage;
        profile_data_t zsysv_rk;
        profile_data_t zsysv_rook;
        profile_data_t zsysvx;
        profile_data_t zsyswapr;
        profile_data_t zsytf2;
        profile_data_t zsytf2_rk;
        profile_data_t zsytf2_rook;
        profile_data_t zsytrf;
        profile_data_t zsytrf_aa;
        profile_data_t zsytrf_aa_2stage;
        profile_data_t zsytrf_rk;
        profile_data_t zsytrf_rook;
        profile_data_t zsytri;
        profile_data_t zsytri2;
        profile_data_t zsytri2x;
        profile_data_t zsytri_3;
        profile_data_t zsytri_3x;
        profile_data_t zsytri_rook;
        profile_data_t zsytrs;
        profile_data_t zsytrs2;
        profile_data_t zsytrs_3;
        profile_data_t zsytrs_aa;
        profile_data_t zsytrs_aa_2stage;
        profile_data_t zsytrs_rook;
        profile_data_t ztbcon;
        profile_data_t ztbrfs;
        profile_data_t ztbtrs;
        profile_data_t ztfsm;
        profile_data_t ztftri;
        profile_data_t ztfttp;
        profile_data_t ztfttr;
        profile_data_t ztgevc;
        profile_data_t ztgex2;
        profile_data_t ztgexc;
        profile_data_t ztgsen;
        profile_data_t ztgsja;
        profile_data_t ztgsna;
        profile_data_t ztgsy2;
        profile_data_t ztgsyl;
        profile_data_t ztpcon;
        profile_data_t ztplqt;
        profile_data_t ztplqt2;
        profile_data_t ztpmlqt;
        profile_data_t ztpmqrt;
        profile_data_t ztpqrt;
        profile_data_t ztpqrt2;
        profile_data_t ztprfb;
        profile_data_t ztprfs;
        profile_data_t ztptri;
        profile_data_t ztptrs;
        profile_data_t ztpttf;
        profile_data_t ztpttr;
        profile_data_t ztrcon;
        profile_data_t ztrevc;
        profile_data_t ztrevc3;
        profile_data_t ztrexc;
        profile_data_t ztrrfs;
        profile_data_t ztrsen;
        profile_data_t ztrsna;
        profile_data_t ztrsyl;
        profile_data_t ztrti2;
        profile_data_t ztrtri;
        profile_data_t ztrtrs;
        profile_data_t ztrttf;
        profile_data_t ztrttp;
        profile_data_t ztzrqf;
        profile_data_t ztzrzf;
        profile_data_t zunbdb;
        profile_data_t zunbdb1;
        profile_data_t zunbdb2;
        profile_data_t zunbdb3;
        profile_data_t zunbdb4;
        profile_data_t zunbdb5;
        profile_data_t zunbdb6;
        profile_data_t zuncsd;
        profile_data_t zuncsd2by1;
        profile_data_t zung2l;
        profile_data_t zung2r;
        profile_data_t zungbr;
        profile_data_t zunghr;
        profile_data_t zungl2;
        profile_data_t zunglq;
        profile_data_t zungql;
        profile_data_t zungqr;
        profile_data_t zungr2;
        profile_data_t zungrq;
        profile_data_t zungtr;
        profile_data_t zungtsqr;
        profile_data_t zunhr_col;
        profile_data_t zunm22;
        profile_data_t zunm2l;
        profile_data_t zunm2r;
        profile_data_t zunmbr;
        profile_data_t zunmhr;
        profile_data_t zunml2;
        profile_data_t zunmlq;
        profile_data_t zunmql;
        profile_data_t zunmqr;
        profile_data_t zunmr2;
        profile_data_t zunmr3;
        profile_data_t zunmrq;
        profile_data_t zunmrz;
        profile_data_t zunmtr;
        profile_data_t zupgtr;
        profile_data_t zupmtr;

        /* LAPACK 3.9.1 */
        profile_data_t cgetsqrhrt;
        profile_data_t clarfb_gett;
        profile_data_t cungtsqr_row;
        profile_data_t dgetsqrhrt;
        profile_data_t dlarfb_gett;
        profile_data_t dorgtsqr_row;
        profile_data_t sgetsqrhrt;
        profile_data_t slarfb_gett;
        profile_data_t sorgtsqr_row;
        profile_data_t zgetsqrhrt;
        profile_data_t zlarfb_gett;
        profile_data_t zungtsqr_row;


        /* LAPACK 3.10.0 */
        profile_data_t claqz0;
        profile_data_t claqz1;
        profile_data_t claqz2;
        profile_data_t claqz3;
        profile_data_t zlaqz0;
        profile_data_t zlaqz1;
        profile_data_t zlaqz2;
        profile_data_t zlaqz3;
        profile_data_t dlaqz0;
        profile_data_t dlaqz1;
        profile_data_t dlaqz2;
        profile_data_t dlaqz3;
        profile_data_t dlaqz4;
        profile_data_t slaqz0;
        profile_data_t slaqz1;
        profile_data_t slaqz2;
        profile_data_t slaqz3;
        profile_data_t slaqz4;

        /* LAPACK 3.10.1 */
        profile_data_t droundup_lwork;
        profile_data_t sroundup_lwork;

        /* LAPACK 3.11.0 */
        profile_data_t ctrsyl3;
        profile_data_t dtrsyl3;
        profile_data_t strsyl3;
        profile_data_t ztrsyl3;
        profile_data_t clatrs3;
        profile_data_t dlatrs3;
        profile_data_t slatrs3;
        profile_data_t zlatrs3;
        profile_data_t cgelst;
        profile_data_t dgelst;
        profile_data_t sgelst;
        profile_data_t zgelst;
        profile_data_t dlarmm;
        profile_data_t slarmm;







    } blas_calls_t;

    extern blas_calls_t *data;


#ifdef __cplusplus
};
#endif

#endif /* end of include guard: PROFILE_HOOK_H */
