/*
 *  Copyright (c) 2018-present, Facebook, Inc.
 *  All rights reserved.
 *
 *  This source code is licensed under the BSD-style license found in the
 *  LICENSE file in the root directory of this source tree.
 */

#pragma once

#include <fizz/crypto/exchange/HybridKeyExchange.h>
#include <fizz/protocol/OpenSSLFactory.h>

namespace fizz {
class HybridKeyExFactory : public OpenSSLFactory {
  std::unique_ptr<KeyExchange> makeClientKeyExchange(
      NamedGroup group) const override {
    switch (group) {
      case NamedGroup::secp521r1_x25519:
        return std::make_unique<HybridKeyExchange>(
            std::make_unique<OpenSSLECKeyExchange<P521>>(),
            std::make_unique<X25519KeyExchange>());
      default:
        throw std::runtime_error("ke: not implemented");
    }
  }
  std::unique_ptr<KeyExchange> makeServerKeyExchange(
      NamedGroup group) const override {
    switch (group) {
      case NamedGroup::secp521r1_x25519:
        return std::make_unique<HybridKeyExchange>(
            std::make_unique<OpenSSLECKeyExchange<P521>>(),
            std::make_unique<X25519KeyExchange>());
      default:
        throw std::runtime_error("ke: not implemented");
    }
  }
};
} // namespace fizz
