/*
 * FISG - Fast IRC Stats Generator
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003-2004 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _FISG_H
#define _FISG_H

#include "th_util.h"
#include "th_string.h"
#include <assert.h>

/*
 * Program name, version
 */
#define FISG_NAME	"FISG"
#define FISG_VERSION	"0.3.12"
#define FISG_COPYRIGHT	"by ccr/TNSP (C) Copyright 2004 TNSP"
#define FISG_FULLNAME	"Fast IRC Stats Generator"


/*
 * Settings and constants
 */
#define SET_MAX_INFILES		(4096)
#define SET_MAX_NICKLEN		(32)
#define SET_MIN_COMMENT_LEN	(10)

#define SET_HASH_MAXINDEX	(256)

#define	SET_HOURS_DAY		(24)
#define	SET_DAY_DIVISOR		(6)

 
/*
 * Typedefs, structures
 */
typedef struct {
	BOOL	autoFollowNicks,
		autoHeuristics,
		stripCtrlChars,
		usePisgScoring,
		statOnlyListed,
		showHappy,
		showComment,
		showPicture,
		showURL,
		statActiveTimes,
		statTopUsers,
		statAlmostTop,
		statURLs,
		statBigNumbers,
		statTopics;

	
	t_uint	commentMaxLength,
		commentMinLength,
		showTopUserMax,
		showAlmostMax,
		showURLsMax,
		showTopicsMax;


	char	*ircChannel,
		*ircNetwork,
		*message,
		*dateFormat,
		*userFilename;
		
} t_fisgconfig;


typedef struct tusernode {
	/* Read from config */
	char	*userHandle;		/* Handle (real nick) */
	char	*picPath;		/* Path/filename of user's picture */
	char	*linkURL;		/* Link to homepages, etc. */
	BOOL	isManaged;		/* Managed user? */
	BOOL	isIgnored;		/* TRUE if user is ignored in stats */

	/* Calculated during parsing */
	t_ulint	nWords, nChars, nPublics, nCaps,
		nQuestions, nYelling,
		nKicks, nModeChanges, nTopicSets,
		nActions, nNotices, nGotKicked,
		nURLs, nJoins, nNickChanges,
		nTopics, nLove;

	t_ulint	nWordsPerHour[SET_HOURS_DAY],
		nPublicsPerHour[SET_HOURS_DAY];

	char	*sComment;

	/* Computed after parsing */
	t_float	fWordsPerPublic,
		fCharsPerWord,
		fHappiness,
		fLove,
		fTotalScore,
		fCapsPercent,
		fActivityPerHour[SET_HOURS_DAY];

	struct tusernode *pPrev, *pNext;
} t_user_entry;


typedef struct tuserdata {
	t_user_entry	*pList,		/* Linked list of users */
			**ppIndex;	/* Index of users */
	t_ulint		n;		/* Number of nodes in index */

	BOOL		dirtyN,		/* TRUE if nIndex not updated after pList change */
			dirtyIndex;	/* TRUE if ppIndex not updated after pList change */
} t_user_data;


typedef struct {
	/* Computed during parsing */
	t_ulint nLines, nChars, nLogFiles, nDays;

	t_user_data	*usersList,
			*usersIgnored,
			*usersRemoved;
	
	t_str_hash	nickList,
			urlList;
	t_str_node	*topicList;


	/* Computed after parsing */
	t_str_index	*urlIndex,
			*topicIndex;

	t_user_entry
		*mostStupid,
		*mostLoud,
		*mostActions,
		*mostNotices,
		*mostModes,
		*mostKicks,
		*mostKicked,
		*mostCaps,
		*mostHappy,
		*mostSad,
		*mostURLs,
		*mostJoins,
		*mostTopics;

	t_ulint	nTimeElapsed;
	t_float	fActivityPerHour[SET_HOURS_DAY];
	int	activityPeak;
} t_stats;


typedef struct {
	int		iMode;
	BOOL		isSet;
	t_user_entry	*pUser;
} t_mode;


typedef struct {
	int	iYear, iMonth, iDay,
		iHours, iMinutes, iSeconds;
} t_datetime;


typedef struct {
	t_datetime	ts;
	t_user_entry	*pUser, *pUser2;
	t_mode	setModes[16];
	char	pText[SET_MAX_BUF + 1];
} t_lineinfo;


/*
 * Internationalization
 */
#define	_(MSTR)	(MSTR)

/*
 * Functions
 */
t_user_entry	*user_new(char *);
void		user_free(t_user_entry *);
void		user_insert(t_user_data *, t_user_entry *);
void		user_delete(t_user_data *, t_user_entry *);
int		parse_userfile(char *, t_stats *, t_fisgconfig *);


t_user_data *	user_data_new(void);
void		user_data_free(t_user_data *);
int		user_data_makeindex(t_user_data *);

int		nickhash_insert(t_str_hash, t_str_node *);
t_str_node	*nickhash_search(t_str_hash, char *);

void		NDMSG(const char *, ...);
void		NDPRINT(const char *, ...);

#endif /* _FISG_H */
