/*
mimedump.c - FireMIME test program
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <unistd.h>
#include "firemake.h"
#include "firemime.h"

int handler(struct firemime_part *stack, int depth, void *opaque) {
	int i;
	struct firemime_param *iter;
	
	/* this function is passed as a parameter to firemime_parse() below
	 * it is called once for every part in the message */

	/* print a number of tabs to represent depth into the message, so the output looks like a tree */
	for (i = 0; i < depth; i++)
		firestring_fprintf(stdout,"\t");

	/* print encoding, disposition, type and subtype */
	firestring_fprintf(stdout,"(%e) %e: %e/%e (%db headers, %db body) [",&stack[depth].encoding,&stack[depth].disposition,&stack[depth].type,&stack[depth].subtype,stack[depth].headers.l,stack[depth].body.l);

	/* print type parameters */
	iter = stack[depth].type_params;
	while (iter != NULL) {
		firestring_fprintf(stdout,"%e='%e'",&iter->name,&iter->value);
		if (iter->next != NULL)
			firestring_fprintf(stdout,", ");
		iter = iter->next;
	}

	/* seperator */
	firestring_fprintf(stdout,"] [");

	/* disposition parameters */
	iter = stack[depth].disposition_params;
	while (iter != NULL) {
		firestring_fprintf(stdout,"%e='%e'",&iter->name,&iter->value);
		if (iter->next != NULL)
			firestring_fprintf(stdout,", ");
		iter = iter->next;
	}

	/* end of line */
	firestring_fprintf(stdout,"]\n");

	/* tell firemime to continue parsing */
	return 0;
}

int main() {
	struct firestring_estr_t message;
	int l,i;

	/* read in the message from standard input */
	firestring_estr_alloc(&message,4096);
	while ((l = read(0,&message.s[message.l],message.a - message.l)) > 0) {
		message.l += l;
		firestring_estr_expand(&message,message.l + 4096);
	}

	/* call the parser */
	i = firemime_parse(&message,handler,&ESTR_S("\n"),NULL);

	/* print results */
	firestring_fprintf(stdout,"Result: %d (%s)\n",i,firemime_strerror(i));

	/* free memory (to make leak checking possible) */
	firestring_estr_free(&message);

	return i;
}
