/*
firemime.h - FireMIME function declarations
Copyright (C) 2000 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/* int handler(struct firemime_part *stack, int depth);
 * returns:
 * 0 to continue normally
 * 1 to continue at depth but not dive
 * 2 to stop immediately
 * */
#include <firestring.h>

#ifndef _FIREMIME_C
extern const char *firemime_version;
#endif

struct firemime_param {
	struct firestring_estr_t name;
	struct firestring_estr_t value;
	int alloc; /* internal use only */
	struct firemime_param *next;
};

struct firemime_part {
	struct firestring_estr_t headers;
	struct firestring_estr_t body;
	struct firestring_estr_t type;
	struct firestring_estr_t subtype;
	struct firestring_estr_t encoding;
	struct firestring_estr_t disposition;
	struct firemime_param *type_params;
	struct firemime_param *disposition_params;
};

int firemime_parse(struct firestring_estr_t *message, int (*handler)(struct firemime_part *, int, void *), struct firestring_estr_t *linebreak, void *opaque);
int firemime_decode_body(struct firestring_estr_t *dest, struct firemime_part *part, struct firestring_estr_t *linebreak);
int firemime_strip_markup(struct firestring_estr_t *dest, struct firestring_estr_t *source);
int firemime_strip_comments(struct firestring_estr_t *dest, struct firestring_estr_t *source);
struct firestring_estr_t *firemime_get_header(struct firestring_estr_t *headers, struct firestring_estr_t *headername, struct firestring_estr_t *linebreak);
struct firestring_estr_t *firemime_get_full_header(struct firestring_estr_t *headers, struct firestring_estr_t *headername, struct firestring_estr_t *linebreak);
struct firestring_estr_t *firemime_param_value(struct firemime_param *paramlist, struct firestring_estr_t *name);
const char *firemime_strerror(int error);
